/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.experimental.graphinfo.GraphNode;
import com.android.tools.r8.experimental.graphinfo.a;
import com.android.tools.r8.graph.L;
import com.android.tools.r8.graph.Q;
import com.android.tools.r8.graph.U;
import com.android.tools.r8.graph.Y;
import com.android.tools.r8.graph.a0;
import com.android.tools.r8.graph.e0;
import com.android.tools.r8.shaking.GraphReporter;

public abstract class KeepReason {
    static KeepReason annotatedOn(L l4) {
        return new AnnotatedOn(l4);
    }

    static KeepReason instantiatedIn(Q q4) {
        return new InstatiatedIn(q4);
    }

    public static KeepReason invokedViaSuperFrom(Q q4) {
        return new InvokedViaSuper(q4);
    }

    public static KeepReason reachableFromLiveType(e0 e02) {
        return new ReachableFromLiveType(e02);
    }

    public static KeepReason invokedFrom(a0 a02, Q q4) {
        return new InvokedFrom(a02, q4);
    }

    public static KeepReason invokedFromLambdaCreatedIn(Q q4) {
        return new InvokedFromLambdaCreatedIn(q4);
    }

    public static KeepReason isLibraryMethod(a0 a02, e0 e02) {
        return new IsLibraryMethod(a02.c, e02);
    }

    public static KeepReason fieldReferencedIn(Q q4) {
        return new ReferencedFrom(q4);
    }

    public static KeepReason referencedInAnnotation(U u4) {
        return new ReferencedInAnnotation(u4);
    }

    public static KeepReason targetedBySuperFrom(Q q4) {
        return new TargetedBySuper(q4);
    }

    public static KeepReason reflectiveUseIn(Q q4) {
        return new ReflectiveUseFrom(q4);
    }

    public static KeepReason methodHandleReferencedIn(Q q4) {
        return new MethodHandleReferencedFrom(q4);
    }

    public abstract a.a edgeKind();

    public abstract GraphNode getSourceNode(GraphReporter var1);

    public boolean isDueToKeepRule() {
        return false;
    }

    public boolean isDueToReflectiveUse() {
        return false;
    }

    private static class MethodHandleReferencedFrom
    extends BasedOnOtherMethod {
        private MethodHandleReferencedFrom(Q q4) {
            super(q4);
        }

        @Override
        public a.a edgeKind() {
            return a.a.q;
        }

        @Override
        String getKind() {
            return "method handle referenced from";
        }
    }

    private static class ReflectiveUseFrom
    extends BasedOnOtherMethod {
        private ReflectiveUseFrom(Q q4) {
            super(q4);
        }

        @Override
        public boolean isDueToReflectiveUse() {
            return true;
        }

        @Override
        public a.a edgeKind() {
            return a.a.l;
        }

        @Override
        String getKind() {
            return "reflective use in";
        }
    }

    private static class AnnotatedOn
    extends KeepReason {
        static final /* synthetic */ boolean $assertionsDisabled;
        private final L holder;

        private AnnotatedOn(L l4) {
            this.holder = l4;
        }

        static {
            $assertionsDisabled = KeepReason.class.desiredAssertionStatus() ^ true;
        }

        @Override
        public a.a edgeKind() {
            return a.a.j;
        }

        @Override
        public GraphNode getSourceNode(GraphReporter graphReporter) {
            if (this.holder.i()) {
                return graphReporter.getClassGraphNode(this.holder.f().c);
            }
            if (this.holder.j()) {
                return graphReporter.getFieldGraphNode(this.holder.g().a);
            }
            if (!$assertionsDisabled && !this.holder.k()) {
                throw new AssertionError();
            }
            return graphReporter.getMethodGraphNode(this.holder.h().a);
        }
    }

    private static class ReferencedInAnnotation
    extends KeepReason {
        private final U holder;

        private ReferencedInAnnotation(U u4) {
            this.holder = u4;
        }

        @Override
        public a.a edgeKind() {
            return a.a.n;
        }

        @Override
        public GraphNode getSourceNode(GraphReporter graphReporter) {
            return graphReporter.getAnnotationGraphNode(this.holder);
        }
    }

    public static class IsLibraryMethod
    extends KeepReason {
        private final e0 implementer;
        private final e0 libraryType;

        private IsLibraryMethod(e0 e02, e0 e03) {
            this.implementer = e02;
            this.libraryType = e03;
        }

        @Override
        public a.a edgeKind() {
            return a.a.o;
        }

        @Override
        public GraphNode getSourceNode(GraphReporter graphReporter) {
            return graphReporter.getClassGraphNode(this.implementer);
        }
    }

    private static class ReachableFromLiveType
    extends KeepReason {
        private final e0 type;

        private ReachableFromLiveType(e0 e02) {
            this.type = e02;
        }

        @Override
        public a.a edgeKind() {
            return a.a.m;
        }

        @Override
        public GraphNode getSourceNode(GraphReporter graphReporter) {
            return graphReporter.getClassGraphNode(this.type);
        }
    }

    private static class ReferencedFrom
    extends BasedOnOtherMethod {
        private ReferencedFrom(Q q4) {
            super(q4);
        }

        @Override
        public a.a edgeKind() {
            return a.a.k;
        }

        @Override
        String getKind() {
            return "referenced from";
        }
    }

    private static class InvokedFromLambdaCreatedIn
    extends BasedOnOtherMethod {
        private InvokedFromLambdaCreatedIn(Q q4) {
            super(q4);
        }

        @Override
        public a.a edgeKind() {
            return a.a.i;
        }

        @Override
        String getKind() {
            return "invoked from lambda created in";
        }
    }

    private static class InvokedFrom
    extends BasedOnOtherMethod {
        static final /* synthetic */ boolean $assertionsDisabled;

        private InvokedFrom(a0 a02, Q q4) {
            super(q4);
            if (!$assertionsDisabled && a02.c != q4.a.c) {
                throw new AssertionError();
            }
        }

        static {
            $assertionsDisabled = KeepReason.class.desiredAssertionStatus() ^ true;
        }

        @Override
        public a.a edgeKind() {
            return a.a.h;
        }

        @Override
        String getKind() {
            return "invoked from";
        }
    }

    private static class TargetedBySuper
    extends BasedOnOtherMethod {
        private TargetedBySuper(Q q4) {
            super(q4);
        }

        @Override
        public a.a edgeKind() {
            return a.a.g;
        }

        @Override
        String getKind() {
            return "targeted by super from";
        }
    }

    private static class InvokedViaSuper
    extends BasedOnOtherMethod {
        private InvokedViaSuper(Q q4) {
            super(q4);
        }

        @Override
        public a.a edgeKind() {
            return a.a.f;
        }

        @Override
        String getKind() {
            return "invoked via super from";
        }
    }

    public static class InstatiatedIn
    extends BasedOnOtherMethod {
        private InstatiatedIn(Q q4) {
            super(q4);
        }

        @Override
        public a.a edgeKind() {
            return a.a.e;
        }

        @Override
        String getKind() {
            return "instantiated in";
        }
    }

    private static abstract class BasedOnOtherMethod
    extends KeepReason {
        private final Q method;

        private BasedOnOtherMethod(Q q4) {
            this.method = q4;
        }

        abstract String getKind();

        public Y getMethod() {
            return this.method.a;
        }

        @Override
        public GraphNode getSourceNode(GraphReporter graphReporter) {
            return graphReporter.getMethodGraphNode(this.method.a);
        }
    }
}

