/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.core;

import com.android.builder.core.DefaultProductFlavor;
import com.android.builder.errors.EvalIssueReporter;
import com.android.builder.model.BaseConfig;
import com.android.builder.model.ProductFlavor;
import com.google.common.collect.Lists;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0017\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J\u0012\u0010\u0014\u001a\u00020\u00102\b\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0017"}, d2={"Lcom/android/builder/core/MergedFlavor;", "Lcom/android/builder/core/DefaultProductFlavor;", "name", "", "issueReporter", "Lcom/android/builder/errors/EvalIssueReporter;", "(Ljava/lang/String;Lcom/android/builder/errors/EvalIssueReporter;)V", "getIssueReporter", "()Lcom/android/builder/errors/EvalIssueReporter;", "reportErrorWithWorkaround", "", "fieldName", "outputFieldName", "fieldValue", "", "setVersionCode", "Lcom/android/builder/model/ProductFlavor;", "versionCode", "", "(Ljava/lang/Integer;)Lcom/android/builder/model/ProductFlavor;", "setVersionName", "versionName", "Companion", "builder"})
public final class MergedFlavor
extends DefaultProductFlavor {
    @NotNull
    private final EvalIssueReporter issueReporter;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public ProductFlavor setVersionCode(@Nullable Integer versionCode) {
        this.reportErrorWithWorkaround("versionCode", "versionCodeOverride", versionCode);
        return this;
    }

    @Override
    @NotNull
    public ProductFlavor setVersionName(@Nullable String versionName) {
        this.reportErrorWithWorkaround("versionName", "versionNameOverride", versionName);
        return this;
    }

    private final void reportErrorWithWorkaround(String fieldName, String outputFieldName, Object fieldValue) {
        String formattedFieldValue = fieldValue instanceof String ? "\"" + fieldValue + "\"" : String.valueOf(fieldValue);
        String message = '\n' + fieldName + " cannot be set on a mergedFlavor directly.\n" + outputFieldName + " can instead be set for variant outputs using the following syntax:\nandroid {\n    applicationVariants.all { variant ->\n        variant.outputs.each { output ->\n            output." + outputFieldName + " = " + formattedFieldValue + "\n        }\n    }\n}";
        EvalIssueReporter.reportError$default(this.issueReporter, EvalIssueReporter.Type.GENERIC, message, null, null, 12, null);
    }

    @NotNull
    public final EvalIssueReporter getIssueReporter() {
        return this.issueReporter;
    }

    public MergedFlavor(@NotNull String name, @NotNull EvalIssueReporter issueReporter) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)issueReporter, (String)"issueReporter");
        super(name);
        this.issueReporter = issueReporter;
    }

    @JvmStatic
    @NotNull
    public static final MergedFlavor clone(@NotNull ProductFlavor productFlavor, @NotNull EvalIssueReporter issueReporter) {
        return Companion.clone(productFlavor, issueReporter);
    }

    @JvmStatic
    @NotNull
    public static final ProductFlavor mergeFlavors(@NotNull ProductFlavor lowestPriority, @NotNull List<? extends ProductFlavor> flavors, @NotNull EvalIssueReporter issueReporter) {
        return Companion.mergeFlavors(lowestPriority, flavors, issueReporter);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J&\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\r"}, d2={"Lcom/android/builder/core/MergedFlavor$Companion;", "", "()V", "clone", "Lcom/android/builder/core/MergedFlavor;", "productFlavor", "Lcom/android/builder/model/ProductFlavor;", "issueReporter", "Lcom/android/builder/errors/EvalIssueReporter;", "mergeFlavors", "lowestPriority", "flavors", "", "builder"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final MergedFlavor clone(@NotNull ProductFlavor productFlavor, @NotNull EvalIssueReporter issueReporter) {
            Intrinsics.checkParameterIsNotNull((Object)productFlavor, (String)"productFlavor");
            Intrinsics.checkParameterIsNotNull((Object)issueReporter, (String)"issueReporter");
            String string = productFlavor.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"productFlavor.name");
            MergedFlavor mergedFlavor = new MergedFlavor(string, issueReporter);
            mergedFlavor._initWith((BaseConfig)productFlavor);
            return mergedFlavor;
        }

        @JvmStatic
        @NotNull
        public final ProductFlavor mergeFlavors(@NotNull ProductFlavor lowestPriority, @NotNull List<? extends ProductFlavor> flavors, @NotNull EvalIssueReporter issueReporter) {
            Intrinsics.checkParameterIsNotNull((Object)lowestPriority, (String)"lowestPriority");
            Intrinsics.checkParameterIsNotNull(flavors, (String)"flavors");
            Intrinsics.checkParameterIsNotNull((Object)issueReporter, (String)"issueReporter");
            MergedFlavor mergedFlavor = Companion.clone(lowestPriority, issueReporter);
            for (ProductFlavor flavor : Lists.reverse(flavors)) {
                mergedFlavor.mergeWithHigherPriorityFlavor(flavor);
            }
            String applicationIdSuffix = lowestPriority.getApplicationIdSuffix();
            String versionNameSuffix = lowestPriority.getVersionNameSuffix();
            for (ProductFlavor productFlavor : flavors) {
                applicationIdSuffix = DefaultProductFlavor.mergeApplicationIdSuffix(productFlavor.getApplicationIdSuffix(), applicationIdSuffix);
                versionNameSuffix = DefaultProductFlavor.mergeVersionNameSuffix(productFlavor.getVersionNameSuffix(), versionNameSuffix);
            }
            mergedFlavor.setApplicationIdSuffix(applicationIdSuffix);
            mergedFlavor.setVersionNameSuffix(versionNameSuffix);
            return mergedFlavor;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

