/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.errors.f;

public abstract class ProguardWildcard {
    abstract void setCaptured(String var1);

    abstract void clearCaptured();

    abstract String getCaptured();

    abstract ProguardWildcard materialize();

    boolean isPattern() {
        return false;
    }

    Pattern asPattern() {
        return null;
    }

    boolean isBackReference() {
        return false;
    }

    BackReference asBackReference() {
        return null;
    }

    static class BackReference
    extends ProguardWildcard {
        Pattern reference;
        final int referenceIndex;

        BackReference(int n4) {
            this.referenceIndex = n4;
        }

        void setReference(Pattern pattern) {
            this.reference = pattern;
        }

        @Override
        void setCaptured(String string) {
            throw new f("A back reference refers back to a previously matched wildcard.");
        }

        @Override
        void clearCaptured() {
        }

        @Override
        String getCaptured() {
            ProguardWildcard proguardWildcard = ((BackReference)proguardWildcard).reference;
            return proguardWildcard != null ? ((Pattern)proguardWildcard).getCaptured() : null;
        }

        @Override
        BackReference materialize() {
            Pattern pattern = this.reference;
            if (pattern != null && pattern.getCaptured() != null) {
                BackReference backReference = new BackReference(this.referenceIndex);
                backReference.setReference(this.reference.materialize());
                return backReference;
            }
            return this;
        }

        @Override
        boolean isBackReference() {
            return true;
        }

        @Override
        BackReference asBackReference() {
            return this;
        }

        public String toString() {
            return "<" + this.referenceIndex + ">";
        }
    }

    static class Pattern
    extends ProguardWildcard {
        final String pattern;
        private String captured = null;

        Pattern(String string) {
            this.pattern = string;
        }

        @Override
        synchronized void setCaptured(String string) {
            this.captured = string;
        }

        @Override
        synchronized void clearCaptured() {
            this.captured = null;
        }

        @Override
        synchronized String getCaptured() {
            return this.captured;
        }

        @Override
        Pattern materialize() {
            if (this.captured == null) {
                return this;
            }
            Pattern pattern = new Pattern(this.pattern);
            pattern.setCaptured(this.captured);
            return pattern;
        }

        @Override
        boolean isPattern() {
            return true;
        }

        @Override
        Pattern asPattern() {
            return this;
        }

        public String toString() {
            return this.pattern;
        }
    }
}

