/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.graph.T;
import com.android.tools.r8.graph.V;
import com.android.tools.r8.graph.e0;
import com.android.tools.r8.utils.T0;
import java.util.function.Consumer;

class UsagePrinter {
    private static final String INDENT = "    ";
    static final UsagePrinter DONT_PRINT;
    static final /* synthetic */ boolean $assertionsDisabled;
    private final Consumer<String> consumer;
    private e0 enclosingClazz = null;
    private boolean clazzPrefixPrinted = false;

    UsagePrinter(Consumer<String> consumer) {
        this.consumer = consumer;
    }

    private void printClazzPrefixIfNecessary() {
        if (!$assertionsDisabled && this.enclosingClazz == null) {
            throw new AssertionError();
        }
        if (!this.clazzPrefixPrinted) {
            UsagePrinter usagePrinter = this;
            usagePrinter.append(usagePrinter.enclosingClazz.toSourceString());
            usagePrinter.append(":");
            usagePrinter.append(T0.c);
            usagePrinter.clazzPrefixPrinted = true;
        }
    }

    static {
        $assertionsDisabled = UsagePrinter.class.desiredAssertionStatus() ^ true;
        DONT_PRINT = new NoOpUsagePrinter();
    }

    void append(String string) {
        this.consumer.accept(string);
    }

    void printUnusedClass(e0 e02) {
        UsagePrinter usagePrinter = this;
        usagePrinter.append(e02.toSourceString());
        usagePrinter.append(T0.c);
    }

    void visiting(e0 e02) {
        if (!$assertionsDisabled && this.enclosingClazz != null) {
            throw new AssertionError();
        }
        this.enclosingClazz = e02;
    }

    void visited() {
        UsagePrinter usagePrinter = this;
        usagePrinter.enclosingClazz = null;
        usagePrinter.clazzPrefixPrinted = false;
    }

    void printUnusedMethod(V v4) {
        UsagePrinter usagePrinter = this;
        usagePrinter.printClazzPrefixIfNecessary();
        usagePrinter.append(INDENT);
        String string = v4.d.toString();
        if (!string.isEmpty()) {
            UsagePrinter usagePrinter2 = this;
            usagePrinter2.append(string);
            usagePrinter2.append(" ");
        }
        UsagePrinter usagePrinter3 = this;
        UsagePrinter usagePrinter4 = this;
        usagePrinter4.append(v4.c.d.d.toSourceString());
        usagePrinter4.append(" ");
        usagePrinter3.append(v4.c.e.toSourceString());
        usagePrinter3.append("(");
        for (int i4 = 0; i4 < v4.c.d.e.a.length; ++i4) {
            if (i4 != 0) {
                this.append(",");
            }
            this.append(v4.c.d.e.a[i4].toSourceString());
        }
        UsagePrinter usagePrinter5 = this;
        usagePrinter5.append(")");
        usagePrinter5.append(T0.c);
    }

    void printUnusedField(T t4) {
        UsagePrinter usagePrinter = this;
        usagePrinter.printClazzPrefixIfNecessary();
        usagePrinter.append(INDENT);
        String string = t4.d.toString();
        if (!string.isEmpty()) {
            UsagePrinter usagePrinter2 = this;
            usagePrinter2.append(string);
            usagePrinter2.append(" ");
        }
        UsagePrinter usagePrinter3 = this;
        UsagePrinter usagePrinter4 = this;
        usagePrinter4.append(t4.c.d.toSourceString());
        usagePrinter4.append(" ");
        usagePrinter3.append(t4.c.e.toSourceString());
        usagePrinter3.append(T0.c);
    }

    private static class NoOpUsagePrinter
    extends UsagePrinter {
        public NoOpUsagePrinter() {
            super(null);
        }

        @Override
        void printUnusedClass(e0 e02) {
        }

        @Override
        void visiting(e0 e02) {
        }

        @Override
        void visited() {
        }

        @Override
        void printUnusedMethod(V v4) {
        }

        @Override
        void printUnusedField(T t4) {
        }
    }
}

