/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.experimental.graphinfo.ClassGraphNode;
import com.android.tools.r8.experimental.graphinfo.FieldGraphNode;
import com.android.tools.r8.experimental.graphinfo.GraphConsumer;
import com.android.tools.r8.experimental.graphinfo.GraphNode;
import com.android.tools.r8.experimental.graphinfo.KeepRuleGraphNode;
import com.android.tools.r8.experimental.graphinfo.MethodGraphNode;
import com.android.tools.r8.experimental.graphinfo.a;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.position.Position;
import com.android.tools.r8.position.TextPosition;
import com.android.tools.r8.position.TextRange;
import com.android.tools.r8.references.ClassReference;
import com.android.tools.r8.references.FieldReference;
import com.android.tools.r8.references.MethodReference;
import com.android.tools.r8.references.TypeReference;
import com.android.tools.r8.shaking.CollectingGraphConsumer;
import com.android.tools.r8.utils.D0;
import com.android.tools.r8.utils.O0;
import com.android.tools.r8.utils.T;
import com.android.tools.r8.utils.Y0;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class WhyAreYouKeepingConsumer
extends CollectingGraphConsumer {
    static final /* synthetic */ boolean $assertionsDisabled;

    public WhyAreYouKeepingConsumer(GraphConsumer graphConsumer) {
        super(graphConsumer);
    }

    private void printNothingKeeping(GraphNode graphNode, PrintStream printStream) {
        printStream.print("Nothing is keeping ");
        printStream.println(this.getNodeString(graphNode));
    }

    private void printNothingKeeping(ClassReference classReference, PrintStream printStream) {
        printStream.print("Nothing is keeping ");
        printStream.println(T.b(classReference.getDescriptor()));
    }

    private List<O0<GraphNode, a>> findShortestPathTo(GraphNode graphNode) {
        LinkedList<GraphPath> linkedList;
        IdentityHashMap<GraphNode, GraphNode> identityHashMap;
        if (graphNode == null) {
            return null;
        }
        IdentityHashMap<GraphNode, GraphNode> identityHashMap2 = identityHashMap;
        identityHashMap = new IdentityHashMap<GraphNode, GraphNode>();
        LinkedList<GraphPath> linkedList2 = linkedList;
        linkedList = new LinkedList<GraphPath>();
        GraphPath graphPath = null;
        Object object = graphNode;
        while ((object = this.getSourcesTargeting((GraphNode)object)) != null) {
            if (!$assertionsDisabled && object.isEmpty()) {
                throw new AssertionError();
            }
            for (GraphNode graphNode2 : object.keySet()) {
                GraphPath graphPath2;
                if (identityHashMap2.containsKey(graphNode2)) continue;
                GraphNode graphNode3 = graphNode2;
                identityHashMap2.put(graphNode3, graphNode3);
                GraphPath graphPath3 = graphPath2;
                graphPath2 = new GraphPath(graphNode2, graphPath);
                linkedList2.addLast(graphPath3);
            }
            if (linkedList2.isEmpty()) {
                return this.getCanonicalPath(new GraphPath(GraphNode.cycle(), graphPath), graphNode);
            }
            graphPath = (GraphPath)linkedList2.removeFirst();
            object = graphPath.node;
        }
        return this.getCanonicalPath(graphPath, graphNode);
    }

    private List<O0<GraphNode, a>> getCanonicalPath(GraphPath graphPath, GraphNode object) {
        ArrayList<O0<GraphNode, a>> arrayList;
        if (graphPath == null) {
            return null;
        }
        ArrayList<O0<GraphNode, a>> arrayList2 = arrayList;
        arrayList = new ArrayList<O0<GraphNode, a>>();
        while (graphPath.path != null) {
            Object object2 = graphPath.node;
            if (((GraphNode)object2).isCycle()) {
                a a5;
                GraphNode graphNode = object2;
                object2 = a5;
                a5 = new a(a.a.t);
                arrayList2.add(new O0<GraphNode, Object>(graphNode, object2));
            } else {
                Set<a> set = ((CollectingGraphConsumer)((Object)graphNode)).getSourcesTargeting(graphPath.path.node).get(object2);
                arrayList2.add(new O0<Object, a>(object2, super.getCanonicalInfo(set)));
            }
            graphPath = graphPath.path;
        }
        ArrayList<O0<GraphNode, a>> arrayList3 = arrayList2;
        object = ((CollectingGraphConsumer)((Object)graphNode)).getSourcesTargeting((GraphNode)object).get(graphPath.node);
        WhyAreYouKeepingConsumer whyAreYouKeepingConsumer = graphNode;
        GraphNode graphNode = graphPath.node;
        arrayList3.add(new O0<Object, a>(graphNode, whyAreYouKeepingConsumer.getCanonicalInfo((Set<a>)object)));
        return arrayList3;
    }

    private a getCanonicalInfo(Set<a> set) {
        a.a[] aArray = a.a.a();
        int n4 = 20;
        for (int i4 = 0; i4 < n4; ++i4) {
            a.a a5 = aArray[i4];
            for (a a6 : set) {
                if (a6.a() != a5) continue;
                return a6;
            }
        }
        if ($assertionsDisabled) {
            return a.c();
        }
        throw new AssertionError((Object)"Unexpected empty set of graph edge info");
    }

    private void printEdge(GraphNode graphNode, a a5, Formatter formatter) {
        formatter.addReason("is " + a5.b() + ":");
        this.addNodeMessage(graphNode, formatter);
    }

    private String getNodeString(GraphNode object) {
        Object object2;
        if (object instanceof ClassGraphNode) {
            return T.b(((ClassGraphNode)object).getReference().getDescriptor());
        }
        if (object instanceof MethodGraphNode) {
            StringBuilder stringBuilder;
            object2 = ((MethodGraphNode)object).getReference();
            object = stringBuilder;
            stringBuilder = new StringBuilder();
            String string = ((MethodReference)object2).getReturnType() == null ? "void" : ((MethodReference)object2).getReturnType().getTypeName();
            return ((StringBuilder)object).append(string).append(' ').append(((MethodReference)object2).getHolderClass().getTypeName()).append('.').append(((MethodReference)object2).getMethodName()).append(Y0.a(D0.a(((MethodReference)object2).getFormalTypes(), TypeReference::getTypeName), ",", Y0.a.a)).toString();
        }
        if (object instanceof FieldGraphNode) {
            object2 = ((FieldGraphNode)object).getReference();
            return ((FieldReference)object2).getFieldType().getTypeName() + ' ' + ((FieldReference)object2).getHolderClass().getTypeName() + '.' + ((FieldReference)object2).getFieldName();
        }
        if (object instanceof KeepRuleGraphNode) {
            object2 = (KeepRuleGraphNode)object;
            return ((KeepRuleGraphNode)object2).getOrigin() == Origin.unknown() ? ((KeepRuleGraphNode)object2).getContent() : ((KeepRuleGraphNode)object2).getOrigin() + ":" + WhyAreYouKeepingConsumer.shortPositionInfo(((KeepRuleGraphNode)object2).getPosition());
        }
        if (object == GraphNode.cycle()) {
            return "only cyclic dependencies remain, failed to determine a path from a keep rule";
        }
        if ($assertionsDisabled) {
            return Objects.toString(object);
        }
        throw new AssertionError((Object)("Unexpected graph node type: " + object));
    }

    private void addNodeMessage(GraphNode graphNode, Formatter formatter) {
        Iterator<String> iterator = Y0.b(((WhyAreYouKeepingConsumer)((Object)iterator)).getNodeString(graphNode)).iterator();
        while (iterator.hasNext()) {
            formatter.addMessage((String)iterator.next());
        }
    }

    private static String shortPositionInfo(Position position) {
        if (position instanceof TextRange) {
            position = ((TextRange)position).getStart();
            return ((TextPosition)position).getLine() + ":" + ((TextPosition)position).getColumn();
        }
        return position.getDescription();
    }

    static {
        $assertionsDisabled = WhyAreYouKeepingConsumer.class.desiredAssertionStatus() ^ true;
    }

    public ClassGraphNode getClassNode(ClassReference classReference) {
        for (GraphNode graphNode : ((CollectingGraphConsumer)this).getTargets()) {
            if (!(graphNode instanceof ClassGraphNode) || ((ClassGraphNode)(graphNode = (ClassGraphNode)graphNode)).getReference() != classReference) continue;
            return graphNode;
        }
        return null;
    }

    public MethodGraphNode getMethodNode(MethodReference methodReference) {
        for (GraphNode graphNode : ((CollectingGraphConsumer)this).getTargets()) {
            if (!(graphNode instanceof MethodGraphNode) || ((MethodGraphNode)(graphNode = (MethodGraphNode)graphNode)).getReference() != methodReference) continue;
            return graphNode;
        }
        return null;
    }

    public FieldGraphNode getFieldNode(FieldReference fieldReference) {
        for (GraphNode graphNode : ((CollectingGraphConsumer)this).getTargets()) {
            if (!(graphNode instanceof FieldGraphNode) || ((FieldGraphNode)(graphNode = (FieldGraphNode)graphNode)).getReference() != fieldReference) continue;
            return graphNode;
        }
        return null;
    }

    public void printWhyAreYouKeeping(ClassReference classReference, PrintStream printStream) {
        ClassGraphNode classGraphNode = this.getClassNode(classReference);
        if (classGraphNode == null) {
            ClassGraphNode classGraphNode2;
            classGraphNode = classGraphNode2;
            classGraphNode2 = new ClassGraphNode(false, classReference);
        }
        this.printWhyAreYouKeeping(classGraphNode, printStream);
    }

    public void printWhyAreYouKeeping(MethodReference methodReference, PrintStream printStream) {
        MethodGraphNode methodGraphNode = this.getMethodNode(methodReference);
        if (methodGraphNode == null) {
            MethodGraphNode methodGraphNode2;
            methodGraphNode = methodGraphNode2;
            methodGraphNode2 = new MethodGraphNode(false, methodReference);
        }
        this.printWhyAreYouKeeping(methodGraphNode, printStream);
    }

    public void printWhyAreYouKeeping(FieldReference fieldReference, PrintStream printStream) {
        FieldGraphNode fieldGraphNode = this.getFieldNode(fieldReference);
        if (fieldGraphNode == null) {
            FieldGraphNode fieldGraphNode2;
            fieldGraphNode = fieldGraphNode2;
            fieldGraphNode2 = new FieldGraphNode(false, fieldReference);
        }
        this.printWhyAreYouKeeping(fieldGraphNode, printStream);
    }

    public void printWhyAreYouKeeping(GraphNode graphNode, PrintStream object) {
        Formatter formatter;
        Formatter formatter2 = formatter;
        formatter = new Formatter((PrintStream)object);
        List<O0<GraphNode, a>> list = this.findShortestPathTo(graphNode);
        if (list == null) {
            this.printNothingKeeping(graphNode, (PrintStream)object);
            return;
        }
        formatter2.startItem(this.getNodeString(graphNode));
        for (int i4 = list.size() - 1; i4 >= 0; --i4) {
            object = list.get(i4);
            this.printEdge((GraphNode)((O0)object).a(), (a)((O0)object).b(), formatter2);
        }
        formatter2.endItem();
    }

    private static class Formatter {
        private final PrintStream output;
        private int indentation = -1;

        public Formatter(PrintStream printStream) {
            this.output = printStream;
        }

        private void indent() {
            for (int i4 = 0; i4 < this.indentation; ++i4) {
                this.output.print("  ");
            }
        }

        void startItem(String string) {
            Formatter formatter = this;
            ++formatter.indentation;
            formatter.indent();
            formatter.output.println(string);
        }

        void addReason(String string) {
            Formatter formatter = this;
            formatter.indent();
            formatter.output.print("|- ");
            formatter.output.println(string);
        }

        void addMessage(String string) {
            Formatter formatter = this;
            formatter.indent();
            formatter.output.print("|  ");
            formatter.output.println(string);
        }

        void endItem() {
            --this.indentation;
        }
    }

    private static class GraphPath {
        static final /* synthetic */ boolean $assertionsDisabled;
        final GraphNode node;
        final GraphPath path;

        public GraphPath(GraphNode graphNode, GraphPath graphPath) {
            if (!$assertionsDisabled && graphNode == null) {
                throw new AssertionError();
            }
            GraphPath graphPath2 = this;
            graphPath2.node = graphNode;
            graphPath2.path = graphPath;
        }

        static {
            $assertionsDisabled = WhyAreYouKeepingConsumer.class.desiredAssertionStatus() ^ true;
        }
    }
}

