/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.errors.k;
import com.android.tools.r8.graph.U;
import com.android.tools.r8.graph.W;
import com.android.tools.r8.graph.X;
import com.android.tools.r8.graph.Z;
import com.android.tools.r8.graph.d0;
import com.android.tools.r8.graph.f;
import com.android.tools.r8.q.a.a.b.C;
import com.android.tools.r8.q.a.a.b.w;
import com.android.tools.r8.shaking.AnnotationMatchResult;
import com.android.tools.r8.shaking.DexStringCache;
import com.android.tools.r8.shaking.ProguardAccessFlags;
import com.android.tools.r8.shaking.ProguardConfigurationParser;
import com.android.tools.r8.shaking.ProguardKeepRule;
import com.android.tools.r8.shaking.ProguardMemberRuleReturnValue;
import com.android.tools.r8.shaking.ProguardMemberType;
import com.android.tools.r8.shaking.ProguardNameMatcher;
import com.android.tools.r8.shaking.ProguardTypeMatcher;
import com.android.tools.r8.shaking.ProguardWildcard;
import com.android.tools.r8.shaking.RootSetBuilder;
import com.android.tools.r8.utils.Y0;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class ProguardMemberRule {
    private final List<ProguardTypeMatcher> annotations;
    private final ProguardAccessFlags accessFlags;
    private final ProguardAccessFlags negatedAccessFlags;
    private final ProguardMemberType ruleType;
    private final ProguardTypeMatcher type;
    private final ProguardNameMatcher name;
    private final List<ProguardTypeMatcher> arguments;
    private final ProguardMemberRuleReturnValue returnValue;

    private ProguardMemberRule(List<ProguardTypeMatcher> list, ProguardAccessFlags proguardAccessFlags, ProguardAccessFlags proguardAccessFlags2, ProguardMemberType proguardMemberType, ProguardTypeMatcher proguardTypeMatcher, ProguardNameMatcher proguardNameMatcher, List<ProguardTypeMatcher> list2, ProguardMemberRuleReturnValue proguardMemberRuleReturnValue) {
        this.annotations = list;
        this.accessFlags = proguardAccessFlags;
        this.negatedAccessFlags = proguardAccessFlags2;
        this.ruleType = proguardMemberType;
        this.type = proguardTypeMatcher;
        this.name = proguardNameMatcher;
        list = list2 != null ? Collections.unmodifiableList(list2) : null;
        ProguardMemberRule proguardMemberRule = this;
        proguardMemberRule.arguments = list;
        proguardMemberRule.returnValue = proguardMemberRuleReturnValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ProguardMemberRule defaultKeepAllRule() {
        Builder builder = new Builder();
        builder.setRuleType(ProguardMemberType.ALL);
        return builder.build();
    }

    private static /* synthetic */ ProguardTypeMatcher lambda$materialize$1(Z z4, ProguardTypeMatcher proguardTypeMatcher) {
        return proguardTypeMatcher.materialize(z4);
    }

    public List<ProguardTypeMatcher> getAnnotations() {
        return this.annotations;
    }

    public ProguardAccessFlags getAccessFlags() {
        return this.accessFlags;
    }

    public ProguardAccessFlags getNegatedAccessFlags() {
        return this.negatedAccessFlags;
    }

    public ProguardMemberType getRuleType() {
        return this.ruleType;
    }

    public ProguardTypeMatcher getType() {
        return this.type;
    }

    public ProguardNameMatcher getName() {
        return this.name;
    }

    public List<ProguardTypeMatcher> getArguments() {
        return this.arguments;
    }

    public boolean hasReturnValue() {
        return this.returnValue != null;
    }

    public ProguardMemberRuleReturnValue getReturnValue() {
        return this.returnValue;
    }

    public ProguardTypeMatcher getTypeMatcher() {
        return this.type;
    }

    public boolean matches(U u4, f<?> f4, Consumer<AnnotationMatchResult> consumer, DexStringCache object) {
        X x4 = f4.j().getOriginalFieldSignature(u4.c);
        int n4 = this.getRuleType().ordinal();
        if (n4 != 0) {
            if ((n4 == 1 || n4 == 2) && this.getAccessFlags().containsAll(u4.d) && this.getNegatedAccessFlags().containsNone(u4.d)) {
                return RootSetBuilder.containsAllAnnotations(this.annotations, u4, consumer);
            }
        } else {
            object = ((DexStringCache)object).lookupString(x4.e);
            if (this.getName().matches((String)object) && this.getAccessFlags().containsAll(u4.d) && this.getNegatedAccessFlags().containsNone(u4.d) && this.getType().matches(x4.d, f4)) {
                return RootSetBuilder.containsAllAnnotations(this.annotations, u4, consumer);
            }
        }
        return false;
    }

    public boolean matches(W j0Array, f<?> f4, Consumer<AnnotationMatchResult> consumer, DexStringCache object) {
        d0 d02 = f4.j().getOriginalMethodSignature(j0Array.c);
        switch (((ProguardMemberRule)this).getRuleType().ordinal()) {
            default: {
                break;
            }
            case 7: {
                if (!((ProguardMemberRule)this).type.matches(d02.d.c, f4)) break;
            }
            case 4: 
            case 5: 
            case 6: {
                object = ((DexStringCache)object).lookupString(d02.e);
                if (!((ProguardMemberRule)this).getName().matches((String)object) || !((ProguardMemberRule)this).getAccessFlags().containsAll(j0Array.d) || !((ProguardMemberRule)this).getNegatedAccessFlags().containsNone(j0Array.d)) break;
                if (!RootSetBuilder.containsAllAnnotations(((ProguardMemberRule)this).annotations, j0Array, consumer)) {
                    return false;
                }
                if ((this = ((ProguardMemberRule)this).getArguments()).size() == 1 && ((ProguardTypeMatcher)this.get(0)).isTripleDotPattern()) {
                    return true;
                }
                j0Array = d02.d.d.a;
                if (d02.d.d.a.length != this.size()) break;
                for (int i4 = 0; i4 < j0Array.length; ++i4) {
                    if (((ProguardTypeMatcher)this.get(i4)).matches(j0Array[i4], f4)) continue;
                    return false;
                }
                return true;
            }
            case 3: {
                if (j0Array.J()) break;
            }
            case 2: {
                if (!((ProguardMemberRule)this).getAccessFlags().containsAll(j0Array.d) || !((ProguardMemberRule)this).getNegatedAccessFlags().containsNone(j0Array.d)) break;
                return RootSetBuilder.containsAllAnnotations(((ProguardMemberRule)this).annotations, j0Array, consumer);
            }
        }
        return false;
    }

    public boolean isSpecific() {
        int n4 = this.getRuleType().ordinal();
        if (n4 != 1 && n4 != 2 && n4 != 3) {
            return w.e(this.getWildcards()) == 0;
        }
        return false;
    }

    Iterable<ProguardWildcard> getWildcards() {
        ProguardMemberRule proguardMemberRule = iterable2;
        Iterable<ProguardWildcard> iterable2 = ProguardTypeMatcher.getWildcardsOrEmpty(proguardMemberRule.annotations);
        Iterable<ProguardWildcard> iterable3 = ProguardTypeMatcher.getWildcardsOrEmpty(proguardMemberRule.type);
        Iterable<ProguardWildcard> iterable4 = ProguardNameMatcher.getWildcardsOrEmpty(proguardMemberRule.name);
        Iterable<ProguardTypeMatcher> iterable5 = proguardMemberRule.arguments;
        iterable5 = iterable5 != null ? iterable5.stream().map(ProguardTypeMatcher::getWildcards).flatMap(iterable -> StreamSupport.stream(iterable.spliterator(), false))::iterator : Collections::emptyIterator;
        return C.a(iterable2, iterable3, iterable4, iterable5);
    }

    ProguardMemberRule materialize(Z object) {
        ProguardMemberRule proguardMemberRule;
        ProguardMemberRule proguardMemberRule2 = proguardMemberRuleReturnValue;
        List<ProguardTypeMatcher> list = ProguardTypeMatcher.materializeList(proguardMemberRule2.getAnnotations(), (Z)object);
        ProguardAccessFlags proguardAccessFlags = proguardMemberRule2.getAccessFlags();
        ProguardAccessFlags proguardAccessFlags2 = proguardMemberRule2.getNegatedAccessFlags();
        ProguardMemberType proguardMemberType = proguardMemberRule2.getRuleType();
        ProguardTypeMatcher proguardTypeMatcher = proguardMemberRule2.getType() == null ? null : ((ProguardMemberRule)((Object)proguardMemberRuleReturnValue)).getType().materialize((Z)object);
        ProguardNameMatcher proguardNameMatcher = ((ProguardMemberRule)((Object)proguardMemberRuleReturnValue)).getName() == null ? null : ((ProguardMemberRule)((Object)proguardMemberRuleReturnValue)).getName().materialize();
        object = ((ProguardMemberRule)((Object)proguardMemberRuleReturnValue)).getArguments() == null ? null : ((ProguardMemberRule)((Object)proguardMemberRuleReturnValue)).getArguments().stream().map(arg_0 -> ProguardMemberRule.lambda$materialize$1((Z)object, arg_0)).collect(Collectors.toList());
        ProguardMemberRule proguardMemberRule3 = proguardMemberRule;
        ProguardMemberRuleReturnValue proguardMemberRuleReturnValue = ((ProguardMemberRule)((Object)proguardMemberRuleReturnValue)).getReturnValue();
        proguardMemberRule3(list, proguardAccessFlags, proguardAccessFlags2, proguardMemberType, proguardTypeMatcher, proguardNameMatcher, (List<ProguardTypeMatcher>)object, proguardMemberRuleReturnValue);
        return proguardMemberRule3;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ProguardMemberRule)) {
            return false;
        }
        object = (ProguardMemberRule)object;
        if (!((ProguardMemberRule)((Object)list)).annotations.equals(((ProguardMemberRule)object).annotations)) {
            return false;
        }
        if (!((ProguardMemberRule)((Object)list)).accessFlags.equals(((ProguardMemberRule)object).accessFlags)) {
            return false;
        }
        if (!((ProguardMemberRule)((Object)list)).negatedAccessFlags.equals(((ProguardMemberRule)object).negatedAccessFlags)) {
            return false;
        }
        if (((ProguardMemberRule)((Object)list)).ruleType != ((ProguardMemberRule)object).ruleType) {
            return false;
        }
        Object object2 = ((ProguardMemberRule)((Object)list)).name;
        if (object2 != null ? !object2.equals(((ProguardMemberRule)object).name) : ((ProguardMemberRule)object).name != null) {
            return false;
        }
        object2 = ((ProguardMemberRule)((Object)list)).type;
        if (object2 != null ? !((ProguardTypeMatcher)object2).equals(((ProguardMemberRule)object).type) : ((ProguardMemberRule)object).type != null) {
            return false;
        }
        List<ProguardTypeMatcher> list = ((ProguardMemberRule)((Object)list)).arguments;
        return list != null ? list.equals(((ProguardMemberRule)object).arguments) : ((ProguardMemberRule)object).arguments == null;
    }

    public int hashCode() {
        ProguardMemberRule proguardMemberRule = this;
        int n4 = ((proguardMemberRule.annotations.hashCode() * 31 + this.accessFlags.hashCode()) * 31 + this.negatedAccessFlags.hashCode()) * 31;
        ProguardMemberType proguardMemberType = proguardMemberRule.ruleType;
        int n5 = proguardMemberType != null ? proguardMemberType.hashCode() : 0;
        n4 = (n4 + n5) * 31;
        ProguardTypeMatcher proguardTypeMatcher = this.type;
        int n6 = proguardTypeMatcher != null ? proguardTypeMatcher.hashCode() : 0;
        n4 = (n4 + n6) * 31;
        ProguardNameMatcher proguardNameMatcher = this.name;
        int n7 = proguardNameMatcher != null ? proguardNameMatcher.hashCode() : 0;
        int n8 = (n4 + n7) * 31;
        List<ProguardTypeMatcher> list = this.arguments;
        int n9 = list != null ? list.hashCode() : 0;
        return n8 + n9;
    }

    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        Iterator<ProguardTypeMatcher> iterator = this.annotations.iterator();
        while (iterator.hasNext()) {
            ProguardKeepRule.appendNonEmpty(stringBuilder2, "@", iterator.next(), " ");
        }
        ProguardKeepRule.appendNonEmpty(stringBuilder2, null, this.accessFlags, " ");
        ProguardKeepRule.appendNonEmpty(stringBuilder2, null, this.negatedAccessFlags.toString().replace(" ", " !"), " ");
        switch (this.getRuleType().ordinal()) {
            default: {
                throw new k("Unknown kind of member rule");
            }
            case 7: {
                StringBuilder stringBuilder3 = stringBuilder2;
                stringBuilder3.append(this.getType());
                stringBuilder3.append(' ');
            }
            case 4: 
            case 5: 
            case 6: {
                StringBuilder stringBuilder4 = stringBuilder2;
                StringBuilder stringBuilder5 = stringBuilder2;
                stringBuilder5.append(this.getName());
                stringBuilder5.append('(');
                stringBuilder4.append(Y0.a(this.getArguments(), ","));
                stringBuilder4.append(')');
                break;
            }
            case 3: {
                stringBuilder2.append("<methods>");
                break;
            }
            case 0: {
                StringBuilder stringBuilder6 = stringBuilder2;
                stringBuilder6.append(this.getType());
                stringBuilder6.append(' ');
                stringBuilder2.append(this.getName());
                break;
            }
            case 1: {
                stringBuilder2.append("<fields>");
                break;
            }
            case 2: {
                stringBuilder2.append("*");
            }
        }
        if (this.hasReturnValue()) {
            stringBuilder2.append(this.returnValue.toString());
        }
        return stringBuilder2.toString();
    }

    public static class Builder {
        static final /* synthetic */ boolean $assertionsDisabled;
        private List<ProguardTypeMatcher> annotations = Collections.emptyList();
        private ProguardAccessFlags accessFlags = new ProguardAccessFlags();
        private ProguardAccessFlags negatedAccessFlags = new ProguardAccessFlags();
        private ProguardMemberType ruleType;
        private ProguardTypeMatcher type;
        private ProguardNameMatcher name;
        private List<ProguardTypeMatcher> arguments;
        private ProguardMemberRuleReturnValue returnValue;

        private Builder() {
        }

        static {
            $assertionsDisabled = ProguardMemberRule.class.desiredAssertionStatus() ^ true;
        }

        public void setAnnotations(List<ProguardTypeMatcher> list) {
            if (!$assertionsDisabled && list == null) {
                throw new AssertionError();
            }
            this.annotations = list;
        }

        public ProguardAccessFlags getAccessFlags() {
            return this.accessFlags;
        }

        public Builder setAccessFlags(ProguardAccessFlags proguardAccessFlags) {
            this.accessFlags = proguardAccessFlags;
            return this;
        }

        public ProguardAccessFlags getNegatedAccessFlags() {
            return this.negatedAccessFlags;
        }

        public void setNegatedAccessFlags(ProguardAccessFlags proguardAccessFlags) {
            this.negatedAccessFlags = proguardAccessFlags;
        }

        public Builder setRuleType(ProguardMemberType proguardMemberType) {
            this.ruleType = proguardMemberType;
            return this;
        }

        public ProguardTypeMatcher getTypeMatcher() {
            return this.type;
        }

        public Builder setTypeMatcher(ProguardTypeMatcher proguardTypeMatcher) {
            this.type = proguardTypeMatcher;
            return this;
        }

        public Builder setName(ProguardConfigurationParser.IdentifierPatternWithWildcards identifierPatternWithWildcards) {
            this.name = ProguardNameMatcher.create(identifierPatternWithWildcards);
            return this;
        }

        public Builder setArguments(List<ProguardTypeMatcher> list) {
            this.arguments = list;
            return this;
        }

        public Builder setReturnValue(ProguardMemberRuleReturnValue proguardMemberRuleReturnValue) {
            this.returnValue = proguardMemberRuleReturnValue;
            return this;
        }

        public boolean isValid() {
            return this.ruleType != null;
        }

        public ProguardMemberRule build() {
            if (!$assertionsDisabled && !((Builder)((Object)list)).isValid()) {
                throw new AssertionError();
            }
            Builder builder = list;
            List<ProguardTypeMatcher> list = builder.annotations;
            ProguardAccessFlags proguardAccessFlags = builder.accessFlags;
            ProguardAccessFlags proguardAccessFlags2 = builder.negatedAccessFlags;
            ProguardMemberType proguardMemberType = builder.ruleType;
            ProguardTypeMatcher proguardTypeMatcher = builder.type;
            ProguardNameMatcher proguardNameMatcher = builder.name;
            List<ProguardTypeMatcher> list2 = builder.arguments;
            ProguardMemberRuleReturnValue proguardMemberRuleReturnValue = builder.returnValue;
            return new ProguardMemberRule(list, proguardAccessFlags, proguardAccessFlags2, proguardMemberType, proguardTypeMatcher, proguardNameMatcher, list2, proguardMemberRuleReturnValue);
        }
    }
}

