/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.compiler;

import com.android.SdkConstants;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessExecutor;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.process.ProcessResult;
import com.android.utils.FileUtils;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;

public class ShaderProcessor {
    public static final String EXT_VERT = "vert";
    public static final String EXT_TESC = "tesc";
    public static final String EXT_TESE = "tese";
    public static final String EXT_GEOM = "geom";
    public static final String EXT_FRAG = "frag";
    public static final String EXT_COMP = "comp";

    public static File getGlslcLocation(File ndkLocation) {
        if (ndkLocation == null) {
            throw new IllegalStateException("NDK location is missing. It is required to compile shaders.");
        }
        if (ndkLocation == null || !ndkLocation.isDirectory()) {
            throw new IllegalStateException("NDK location does not exist. It is required to compile shaders: " + ndkLocation);
        }
        File glslcRootFolder = new File(ndkLocation, "shader-tools");
        switch (SdkConstants.currentPlatform()) {
            case 3: {
                glslcRootFolder = new File(glslcRootFolder, "darwin-x86_64");
                break;
            }
            case 2: {
                glslcRootFolder = new File(glslcRootFolder, "windows-x86_64");
                if (glslcRootFolder.isDirectory()) break;
                glslcRootFolder = new File(glslcRootFolder, "windows");
                break;
            }
            case 1: {
                glslcRootFolder = new File(glslcRootFolder, "linux-x86_64");
            }
        }
        if (!glslcRootFolder.isDirectory()) {
            throw new IllegalStateException("Missing NDK subfolder: " + glslcRootFolder);
        }
        File glslcLocation = new File(glslcRootFolder, SdkConstants.FN_GLSLC);
        if (!glslcLocation.isFile()) {
            throw new IllegalStateException("glslc is missing: " + glslcLocation);
        }
        return glslcLocation;
    }

    public static class ShaderProcessorParams
    implements Serializable {
        private final File mSourceFolder;
        private final File mOutputDir;
        private final List<String> mDefaultArgs;
        private final Map<String, List<String>> mScopedArgs;
        private final ProcessExecutor mProcessExecutor;
        private final ProcessOutputHandler mProcessOutputHandler;
        private final Path start;
        private final Path path;
        private final File mGlslcLocation;

        public ShaderProcessorParams(File mSourceFolder, File mOutputDir, List<String> mDefaultArgs, Map<String, List<String>> mScopedArgs, ProcessExecutor mProcessExecutor, ProcessOutputHandler mProcessOutputHandler, Path start, Path path, File mGlslcLocation) {
            this.mSourceFolder = mSourceFolder;
            this.mOutputDir = mOutputDir;
            this.mDefaultArgs = mDefaultArgs;
            this.mScopedArgs = mScopedArgs;
            this.mProcessExecutor = mProcessExecutor;
            this.mProcessOutputHandler = mProcessOutputHandler;
            this.start = start;
            this.path = path;
            this.mGlslcLocation = mGlslcLocation;
        }
    }

    public static class ShaderProcessorRunnable
    implements Runnable {
        private final ShaderProcessorParams params;

        public ShaderProcessorRunnable(ShaderProcessorParams params) {
            this.params = params;
        }

        private List<String> getArgs(String relativePath) {
            int pos = relativePath.indexOf(File.separatorChar);
            if (pos == -1) {
                return this.params.mDefaultArgs;
            }
            String key = relativePath.substring(0, pos);
            List args = (List)this.params.mScopedArgs.get(key);
            if (args != null) {
                return args;
            }
            return this.params.mDefaultArgs;
        }

        @Override
        public void run() {
            ProcessInfoBuilder builder = new ProcessInfoBuilder();
            builder.setExecutable(this.params.mGlslcLocation);
            builder.addArgs("-I", this.params.mSourceFolder.getPath());
            String relativePath = FileUtils.relativePath((File)this.params.path.toFile(), (File)this.params.start.toFile());
            File destFile = new File(this.params.mOutputDir, relativePath + ".spv");
            builder.addArgs(this.getArgs(relativePath));
            builder.addArgs(this.params.path.toString());
            builder.addArgs("-o", destFile.getPath());
            FileUtils.mkdirs((File)destFile.getParentFile());
            ProcessResult result = this.params.mProcessExecutor.execute(builder.createProcess(), this.params.mProcessOutputHandler);
            try {
                result.rethrowFailure().assertNormalExitValue();
            }
            catch (ProcessException pe) {
                throw new RuntimeException(pe);
            }
        }
    }
}

