/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.aapt.v2;

import com.android.builder.internal.aapt.AaptConvertConfig;
import com.android.builder.internal.aapt.AaptException;
import com.android.builder.internal.aapt.AaptPackageConfig;
import com.android.builder.internal.aapt.AaptUtils;
import com.android.builder.packaging.PackagingUtils;
import com.android.ide.common.resources.CompileResourceRequest;
import com.android.utils.FileUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003H\u0002\u001a\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\u00052\u0006\u0010\t\u001a\u00020\n\u001a\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00010\u00052\u0006\u0010\t\u001a\u00020\f\u00a8\u0006\r"}, d2={"getNoCompressRegex", "", "noCompressList", "", "makeCompileCommand", "Lcom/google/common/collect/ImmutableList;", "request", "Lcom/android/ide/common/resources/CompileResourceRequest;", "makeConvertCommand", "config", "Lcom/android/builder/internal/aapt/AaptConvertConfig;", "makeLinkCommand", "Lcom/android/builder/internal/aapt/AaptPackageConfig;", "builder"})
@JvmName(name="AaptV2CommandBuilder")
public final class AaptV2CommandBuilder {
    @NotNull
    public static final ImmutableList<String> makeCompileCommand(@NotNull CompileResourceRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        ImmutableList.Builder parameters = new ImmutableList.Builder();
        if (request.isPseudoLocalize()) {
            parameters.add((Object)"--pseudo-localize");
        }
        if (!request.isPngCrunching()) {
            String string = request.getInputFile().getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"request.inputFile.path");
            String string2 = string;
            Locale locale = Locale.US;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.US");
            Locale locale2 = locale;
            boolean bl = false;
            String string3 = string2;
            boolean bl2 = false;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.toLowerCase(locale2);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toLowerCase(locale)");
            String lowerName = string5;
            if (StringsKt.endsWith$default((String)lowerName, (String)".png", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)lowerName, (String)".9.png", (boolean)false, (int)2, null)) {
                parameters.add((Object)"--no-crunch");
            }
        }
        if (request.getPartialRFile() != null) {
            Object[] objectArray = new String[2];
            objectArray[0] = "--output-text-symbols";
            File file = request.getPartialRFile();
            if (file == null) {
                Intrinsics.throwNpe();
            }
            objectArray[1] = file.getAbsolutePath();
            parameters.add(objectArray);
        }
        parameters.add((Object)"--legacy");
        parameters.add((Object[])new String[]{"-o", request.getOutputDirectory().getAbsolutePath()});
        parameters.add((Object)request.getInputFile().getAbsolutePath());
        ImmutableList immutableList = parameters.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"parameters.build()");
        return immutableList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public static final ImmutableList<String> makeLinkCommand(@NotNull AaptPackageConfig config) throws AaptException {
        Iterable<String> densityResSplits;
        List<String> additionalParameters;
        Object splitter;
        boolean $i$f$forEach;
        Object[] objectArray;
        File resourceOutputApk;
        ImmutableList.Builder builder;
        block68: {
            Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
            builder = ImmutableList.builder();
            if (config.getVerbose()) {
                builder.add((Object)"-v");
            }
            if (config.getGenerateProtos()) {
                builder.add((Object)"--proto-format");
            }
            if (config.getExcludeSources()) {
                if (!config.getGenerateProtos()) {
                    throw (Throwable)new AaptException("AAPT2 only supports excluding sources when building for a bundle.");
                }
                builder.add((Object)"--exclude-sources");
            }
            if (config.getMergeOnly()) {
                builder.add((Object)"--merge-only");
            } else {
                builder.add((Object[])new String[]{"-I", (String)Preconditions.checkNotNull((Object)config.getAndroidJarPath())});
            }
            Iterable $this$forEach$iv = (Iterable)config.getImports();
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                UnmodifiableIterator file = (UnmodifiableIterator)element$iv;
                boolean bl = false;
                Object[] objectArray2 = new String[2];
                objectArray2[0] = "-I";
                UnmodifiableIterator unmodifiableIterator = file;
                Intrinsics.checkExpressionValueIsNotNull((Object)unmodifiableIterator, (String)"file");
                objectArray2[1] = unmodifiableIterator.getAbsolutePath();
                builder.add(objectArray2);
            }
            File manifestFile = config.getManifestFile();
            Preconditions.checkNotNull((Object)manifestFile);
            builder.add((Object[])new String[]{"--manifest", manifestFile.getAbsolutePath()});
            File file = config.getResourceOutputApk();
            if (file == null) {
                File tmpOutput;
                try {
                    tmpOutput = File.createTempFile("aapt-", "-out");
                    tmpOutput.deleteOnExit();
                }
                catch (IOException e5) {
                    throw (Throwable)new AaptException("No output apk defined and failed to create tmp file", e5);
                }
                file = tmpOutput;
            }
            File file2 = resourceOutputApk = file;
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"resourceOutputApk");
            FileUtils.mkdirs((File)file2.getParentFile());
            builder.add((Object[])new String[]{"-o", resourceOutputApk.getAbsolutePath()});
            if (!config.getResourceDirs().isEmpty()) {
                try {
                    int n4;
                    if (config.isListResourceFiles()) {
                        File file3 = config.getIntermediateDir();
                        if (file3 == null) {
                            Intrinsics.throwNpe();
                        }
                        File resourceListFile = new File(file3, "resources-list-for-" + resourceOutputApk.getName() + ".txt");
                        FileUtils.deleteIfExists((File)resourceListFile);
                        Files.createDirectories(config.getIntermediateDir().toPath(), new FileAttribute[0]);
                        for (Object dir : config.getResourceDirs()) {
                            Closeable bl = new FileOutputStream(resourceListFile);
                            boolean bl2 = false;
                            boolean bl3 = false;
                            Throwable throwable = null;
                            try {
                                FileOutputStream fos = (FileOutputStream)bl;
                                boolean bl4 = false;
                                Closeable closeable = new PrintWriter(fos);
                                n4 = 0;
                                boolean bl5 = false;
                                objectArray = null;
                                try {
                                    void $this$forEach$iv2;
                                    Iterable $this$sortedBy$iv;
                                    void $this$filterTo$iv$iv;
                                    Iterable $this$filter$iv;
                                    PrintWriter pw = (PrintWriter)closeable;
                                    boolean bl6 = false;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)((File)dir).listFiles(), (String)"dir.listFiles()");
                                    boolean $i$f$filter = false;
                                    Iterator iterator = $this$filter$iv;
                                    Collection destination$iv$iv = new ArrayList();
                                    boolean $i$f$filterTo = false;
                                    void var22_60 = $this$filterTo$iv$iv;
                                    int n5 = ((void)var22_60).length;
                                    for (int i4 = 0; i4 < n5; ++i4) {
                                        void element$iv$iv;
                                        void it = element$iv$iv = var22_60[i4];
                                        boolean bl7 = false;
                                        void v5 = it;
                                        Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"it");
                                        if (!v5.isFile()) continue;
                                        destination$iv$iv.add(element$iv$iv);
                                    }
                                    $this$filter$iv = (List)destination$iv$iv;
                                    boolean $i$f$sortedBy = false;
                                    boolean bl8 = false;
                                    $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

                                        public final int compare(T a5, T b5) {
                                            boolean bl = false;
                                            File it = (File)a5;
                                            boolean bl2 = false;
                                            File file = it;
                                            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it");
                                            it = (File)b5;
                                            Comparable comparable = (Comparable)((Object)file.getPath());
                                            bl2 = false;
                                            File file2 = it;
                                            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"it");
                                            String string = file2.getPath();
                                            return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string)));
                                        }
                                    });
                                    boolean $i$f$forEach3 = false;
                                    for (Object element$iv : $this$forEach$iv2) {
                                        File it = (File)element$iv;
                                        boolean bl9 = false;
                                        StringBuilder stringBuilder = new StringBuilder();
                                        File file4 = it;
                                        Intrinsics.checkExpressionValueIsNotNull((Object)file4, (String)"it");
                                        pw.print(stringBuilder.append(file4.getAbsolutePath()).append(" ").toString());
                                    }
                                    pw = Unit.INSTANCE;
                                }
                                catch (Throwable pw) {
                                    objectArray = pw;
                                    throw pw;
                                }
                                finally {
                                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)objectArray);
                                }
                                fos = Unit.INSTANCE;
                            }
                            catch (Throwable fos) {
                                throwable = fos;
                                throw fos;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)bl, (Throwable)throwable);
                            }
                        }
                        builder.add((Object[])new String[]{"-R", "@" + resourceListFile.getAbsolutePath()});
                        break block68;
                    }
                    for (File dir : config.getResourceDirs()) {
                        void $this$forEach$iv3;
                        Iterable $this$sortedBy$iv;
                        Iterator $this$filterTo$iv$iv32;
                        Iterable $this$filter$iv;
                        Intrinsics.checkExpressionValueIsNotNull((Object)dir.listFiles(), (String)"dir.listFiles()");
                        boolean $i$f$filter = false;
                        void var8_15 = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$filterTo = false;
                        void bl4 = $this$filterTo$iv$iv32;
                        int n6 = ((void)bl4).length;
                        for (n4 = 0; n4 < n6; ++n4) {
                            void element$iv$iv;
                            void it = element$iv$iv = bl4[n4];
                            boolean bl = false;
                            void v8 = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)v8, (String)"it");
                            if (!v8.isFile()) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $this$filter$iv = (List)destination$iv$iv;
                        boolean $i$f$sortedBy = false;
                        boolean $this$filterTo$iv$iv32 = false;
                        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

                            public final int compare(T a5, T b5) {
                                boolean bl = false;
                                File it = (File)a5;
                                boolean bl2 = false;
                                File file = it;
                                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it");
                                it = (File)b5;
                                Comparable comparable = (Comparable)((Object)file.getPath());
                                bl2 = false;
                                File file2 = it;
                                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"it");
                                String string = file2.getPath();
                                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string)));
                            }
                        });
                        $i$f$forEach = false;
                        $this$filterTo$iv$iv32 = $this$forEach$iv3.iterator();
                        while ($this$filterTo$iv$iv32.hasNext()) {
                            Object element$iv = $this$filterTo$iv$iv32.next();
                            File it = (File)element$iv;
                            boolean bl = false;
                            Object[] objectArray3 = new String[2];
                            objectArray3[0] = "-R";
                            File file5 = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)file5, (String)"it");
                            objectArray3[1] = file5.getAbsolutePath();
                            builder.add(objectArray3);
                        }
                    }
                }
                catch (IOException e6) {
                    throw (Throwable)new AaptException("Failed to walk paths " + Joiner.on((char)File.pathSeparatorChar).join((Iterable)config.getResourceDirs()), e6);
                }
            }
        }
        builder.add((Object)"--auto-add-overlay");
        if (config.getSourceOutputDir() != null) {
            builder.add((Object[])new String[]{"--java", config.getSourceOutputDir().getAbsolutePath()});
        }
        if (config.getProguardOutputFile() != null) {
            builder.add((Object[])new String[]{"--proguard", config.getProguardOutputFile().getAbsolutePath()});
        }
        if (config.getMainDexListProguardOutputFile() != null) {
            builder.add((Object[])new String[]{"--proguard-main-dex", config.getMainDexListProguardOutputFile().getAbsolutePath()});
        }
        if (config.getSplits() != null) {
            for (String split : config.getSplits()) {
                splitter = File.pathSeparator;
                builder.add((Object[])new String[]{"--split", resourceOutputApk.toString() + "_" + split + (String)splitter + split});
            }
        }
        if (!config.getVariantType().isTestComponent() && config.getCustomPackageForR() != null) {
            builder.add((Object[])new String[]{"--custom-package", config.getCustomPackageForR()});
        }
        boolean generateFinalIds = true;
        if (config.getVariantType().isAar()) {
            generateFinalIds = false;
        }
        if (!generateFinalIds) {
            builder.add((Object)"--non-final-ids");
        }
        builder.add((Object[])new String[]{"-0", "apk"});
        Collection<String> noCompressList = Objects.requireNonNull(config.getOptions()).getNoCompress();
        if (noCompressList != null) {
            splitter = noCompressList;
            $i$f$forEach = false;
            if (!splitter.isEmpty()) {
                boolean bl;
                block69: {
                    Iterable $this$any$iv = noCompressList;
                    boolean $i$f$any = false;
                    if (((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl10 = false;
                            if (!Strings.isNullOrEmpty((String)it)) continue;
                            bl = true;
                            break block69;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    builder.add((Object)"--no-compress");
                } else {
                    builder.add((Object[])new String[]{"--no-compress-regex", AaptV2CommandBuilder.getNoCompressRegex(noCompressList)});
                }
            }
        }
        if ((additionalParameters = config.getOptions().getAdditionalParameters()) != null) {
            builder.addAll((Iterable)additionalParameters);
        }
        ArrayList resourceConfigs = new ArrayList((Collection)config.getResourceConfigs());
        ArrayList densityResourceConfigs = Lists.newArrayList(AaptUtils.getDensityResConfigs(resourceConfigs));
        ArrayList otherResourceConfigs = Lists.newArrayList(AaptUtils.getNonDensityResConfigs(resourceConfigs));
        String preferredDensity = config.getPreferredDensity();
        Iterable<String> iterable = densityResSplits = config.getSplits() != null ? AaptUtils.getDensityResConfigs((Iterable)config.getSplits()) : (Iterable<String>)ImmutableList.of();
        if ((preferredDensity != null || densityResSplits.iterator().hasNext()) && !densityResourceConfigs.isEmpty()) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "When using splits in tools 21 and above, resConfigs should not contain any densities. Right now, it contains \"%1$s\"\nSuggestion: remove these from resConfigs from build.gradle";
            objectArray = new Object[]{Joiner.on((String)"\",\"").join((Iterable)densityResourceConfigs)};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            throw (Throwable)new AaptException(string2);
        }
        if (densityResourceConfigs.size() > 1) {
            throw (Throwable)new AaptException("Cannot filter assets for multiple densities using SDK build tools 21 or later. Consider using apk splits instead.");
        }
        if (!otherResourceConfigs.isEmpty() && config.getSplits() != null) {
            Iterable<String> nonDensitySplits = AaptUtils.getNonDensityResConfigs((Iterable)config.getSplits());
            otherResourceConfigs.addAll(Lists.newArrayList(nonDensitySplits));
        }
        if (preferredDensity == null && densityResourceConfigs.size() == 1) {
            preferredDensity = (String)Iterables.getOnlyElement((Iterable)densityResourceConfigs);
        }
        if (!otherResourceConfigs.isEmpty()) {
            Joiner joiner = Joiner.on((char)',');
            builder.add((Object[])new String[]{"-c", joiner.join((Iterable)otherResourceConfigs)});
        }
        if (preferredDensity != null) {
            builder.add((Object[])new String[]{"--preferred-density", preferredDensity});
        }
        if (config.getSymbolOutputDir() != null) {
            File rDotTxt = new File(config.getSymbolOutputDir(), "R.txt");
            builder.add((Object[])new String[]{"--output-text-symbols", rDotTxt.getAbsolutePath()});
        }
        if (config.getPackageId() != null) {
            if (config.getAllowReservedPackageId()) {
                builder.add((Object)"--allow-reserved-package-id");
            }
            builder.add((Object[])new String[]{"--package-id", "0x" + Integer.toHexString(config.getPackageId())});
            for (File dependentFeature : config.getDependentFeatures()) {
                Object[] objectArray4 = new String[2];
                objectArray4[0] = "-I";
                File file = dependentFeature;
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"dependentFeature");
                objectArray4[1] = file.getAbsolutePath();
                builder.add(objectArray4);
            }
        } else if (!config.getDependentFeatures().isEmpty()) {
            throw (Throwable)new AaptException("Dependent features configured but no package ID was set.");
        }
        builder.add((Object)"--no-version-vectors");
        if (config.getUseConditionalKeepRules()) {
            builder.add((Object)"--proguard-conditional-keep-rules");
        }
        if (config.getUseMinimalKeepRules()) {
            builder.add((Object)"--proguard-minimal-keep-rules");
        }
        if (config.isStaticLibrary()) {
            builder.add((Object)"--static-lib");
            if (!config.getStaticLibraryDependencies().isEmpty()) {
                throw (Throwable)new AaptException("Static libraries to link against should be passed as imports");
            }
        } else {
            UnmodifiableIterator unmodifiableIterator = config.getStaticLibraryDependencies().iterator();
            while (unmodifiableIterator.hasNext()) {
                File file;
                File file6 = file = (File)unmodifiableIterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)file6, (String)"file");
                builder.add((Object)file6.getAbsolutePath());
            }
        }
        builder.add((Object)"--no-proguard-location-reference");
        if (config.getEmitStableIdsFile() != null) {
            builder.add((Object[])new String[]{"--emit-ids", config.getEmitStableIdsFile().getAbsolutePath()});
        }
        if (config.getConsumeStableIdsFile() != null) {
            builder.add((Object[])new String[]{"--stable-ids", config.getConsumeStableIdsFile().getAbsolutePath()});
        }
        ImmutableList immutableList = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"builder.build()");
        return immutableList;
    }

    @NotNull
    public static final ImmutableList<String> makeConvertCommand(@NotNull AaptConvertConfig config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)"--output-format");
        if (config.getConvertToProtos()) {
            builder.add((Object)"proto");
        } else {
            builder.add((Object)"binary");
        }
        FileUtils.mkdirs((File)config.getOutputFile().getParentFile());
        builder.add((Object)"-o").add((Object)config.getOutputFile().getAbsolutePath());
        builder.add((Object)config.getInputFile().getAbsolutePath());
        ImmutableList immutableList = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"builder.build()");
        return immutableList;
    }

    private static final String getNoCompressRegex(Collection<String> noCompressList) {
        return "((" + Joiner.on((String)"$)|(").join((Iterable)PackagingUtils.getNoCompressForAapt(noCompressList)) + "$))";
    }
}

