/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.io.instructions;

import com.android.dx.io.instructions.BaseCodeCursor;
import com.android.dx.io.instructions.CodeOutput;

public final class ShortArrayCodeOutput
extends BaseCodeCursor
implements CodeOutput {
    private final short[] array;

    public ShortArrayCodeOutput(int maxSize) {
        if (maxSize < 0) {
            throw new IllegalArgumentException("maxSize < 0");
        }
        this.array = new short[maxSize];
    }

    public short[] getArray() {
        int cursor = this.cursor();
        if (cursor == this.array.length) {
            return this.array;
        }
        short[] result = new short[cursor];
        System.arraycopy(this.array, 0, result, 0, cursor);
        return result;
    }

    @Override
    public void write(short codeUnit) {
        this.array[this.cursor()] = codeUnit;
        this.advance(1);
    }

    @Override
    public void write(short u02, short u12) {
        this.write(u02);
        this.write(u12);
    }

    @Override
    public void write(short u02, short u12, short u22) {
        this.write(u02);
        this.write(u12);
        this.write(u22);
    }

    @Override
    public void write(short u02, short u12, short u22, short u32) {
        this.write(u02);
        this.write(u12);
        this.write(u22);
        this.write(u32);
    }

    @Override
    public void write(short u02, short u12, short u22, short u32, short u4) {
        this.write(u02);
        this.write(u12);
        this.write(u22);
        this.write(u32);
        this.write(u4);
    }

    @Override
    public void writeInt(int value) {
        this.write((short)value);
        this.write((short)(value >> 16));
    }

    @Override
    public void writeLong(long value) {
        this.write((short)value);
        this.write((short)(value >> 16));
        this.write((short)(value >> 32));
        this.write((short)(value >> 48));
    }

    @Override
    public void write(byte[] data) {
        int value = 0;
        boolean even = true;
        for (byte b5 : data) {
            if (even) {
                value = b5 & 0xFF;
                even = false;
                continue;
            }
            this.write((short)(value |= b5 << 8));
            even = true;
        }
        if (!even) {
            this.write((short)value);
        }
    }

    @Override
    public void write(short[] data) {
        for (short unit : data) {
            this.write(unit);
        }
    }

    @Override
    public void write(int[] data) {
        for (int i4 : data) {
            this.writeInt(i4);
        }
    }

    @Override
    public void write(long[] data) {
        for (long l4 : data) {
            this.writeLong(l4);
        }
    }
}

