/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.util;

public final class Bits {
    private Bits() {
    }

    public static int[] makeBitSet(int max) {
        int size = max + 31 >> 5;
        return new int[size];
    }

    public static int getMax(int[] bits) {
        return bits.length * 32;
    }

    public static boolean get(int[] bits, int idx) {
        int arrayIdx = idx >> 5;
        int bit = 1 << (idx & 0x1F);
        return (bits[arrayIdx] & bit) != 0;
    }

    public static void set(int[] bits, int idx, boolean value) {
        int arrayIdx = idx >> 5;
        int bit = 1 << (idx & 0x1F);
        if (value) {
            int n4 = arrayIdx;
            bits[n4] = bits[n4] | bit;
        } else {
            int n5 = arrayIdx;
            bits[n5] = bits[n5] & ~bit;
        }
    }

    public static void set(int[] bits, int idx) {
        int arrayIdx = idx >> 5;
        int bit = 1 << (idx & 0x1F);
        int n4 = arrayIdx;
        bits[n4] = bits[n4] | bit;
    }

    public static void clear(int[] bits, int idx) {
        int arrayIdx = idx >> 5;
        int bit = 1 << (idx & 0x1F);
        int n4 = arrayIdx;
        bits[n4] = bits[n4] & ~bit;
    }

    public static boolean isEmpty(int[] bits) {
        int len = bits.length;
        for (int i4 = 0; i4 < len; ++i4) {
            if (bits[i4] == 0) continue;
            return false;
        }
        return true;
    }

    public static int bitCount(int[] bits) {
        int len = bits.length;
        int count = 0;
        for (int i4 = 0; i4 < len; ++i4) {
            count += Integer.bitCount(bits[i4]);
        }
        return count;
    }

    public static boolean anyInRange(int[] bits, int start, int end) {
        int idx = Bits.findFirst(bits, start);
        return idx >= 0 && idx < end;
    }

    public static int findFirst(int[] bits, int idx) {
        int len = bits.length;
        int minBit = idx & 0x1F;
        for (int arrayIdx = idx >> 5; arrayIdx < len; ++arrayIdx) {
            int bitIdx;
            int word = bits[arrayIdx];
            if (word != 0 && (bitIdx = Bits.findFirst(word, minBit)) >= 0) {
                return (arrayIdx << 5) + bitIdx;
            }
            minBit = 0;
        }
        return -1;
    }

    public static int findFirst(int value, int idx) {
        int result = Integer.numberOfTrailingZeros(value &= ~((1 << idx) - 1));
        return result == 32 ? -1 : result;
    }

    public static void or(int[] a5, int[] b5) {
        for (int i4 = 0; i4 < b5.length; ++i4) {
            int n4 = i4;
            a5[n4] = a5[n4] | b5[i4];
        }
    }

    public static String toHuman(int[] bits) {
        StringBuilder sb = new StringBuilder();
        boolean needsComma = false;
        sb.append('{');
        int bitsLength = 32 * bits.length;
        for (int i4 = 0; i4 < bitsLength; ++i4) {
            if (!Bits.get(bits, i4)) continue;
            if (needsComma) {
                sb.append(',');
            }
            needsComma = true;
            sb.append(i4);
        }
        sb.append('}');
        return sb.toString();
    }
}

