/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.sdk;

import com.android.repository.api.RemotePackage;
import com.google.common.collect.ImmutableList;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;

public final class InstallFailedException
extends Exception {
    private final ImmutableList<RemotePackage> failedPackages;

    public InstallFailedException(Path sdkLocation, List<RemotePackage> failedPackages) {
        super(InstallFailedException.getMessage(failedPackages, sdkLocation));
        this.failedPackages = ImmutableList.copyOf(failedPackages);
    }

    public ImmutableList<RemotePackage> getAffectedPackages() {
        return this.failedPackages;
    }

    private static String getMessage(List<RemotePackage> affectedPackages, Path sdkLocation) {
        StringBuilder message = new StringBuilder("Failed to install the following SDK components:\n");
        for (RemotePackage affectedPackage : affectedPackages) {
            message.append("    ").append(affectedPackage.getPath()).append(' ').append(affectedPackage.getDisplayName()).append('\n');
        }
        if (!Files.isWritable(sdkLocation)) {
            message.append("The SDK directory is not writable (").append(sdkLocation.toString()).append(")\n");
        } else {
            message.append("Install the missing components using the SDK manager in Android Studio.\n");
        }
        return message.toString();
    }
}

