/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.signing;

import com.android.builder.model.SigningConfig;
import com.google.common.base.MoreObjects;
import java.io.File;
import java.security.KeyStore;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u001e\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0016\u0018\u0000 72\u00020\u0001:\u00017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u00100\u001a\u00020\u00062\b\u00101\u001a\u0004\u0018\u000102H\u0096\u0002J\b\u00103\u001a\u00020\u0003H\u0016J\b\u00104\u001a\u000205H\u0016J\u0010\u0010 \u001a\u00020\u00002\b\u0010\u001d\u001a\u0004\u0018\u00010\u0003J\u0010\u0010#\u001a\u00020\u00002\b\u0010!\u001a\u0004\u0018\u00010\u0003J\u0010\u0010(\u001a\u00020\u00002\b\u0010$\u001a\u0004\u0018\u00010%J\u0010\u0010,\u001a\u00020\u00002\b\u0010*\u001a\u0004\u0018\u00010\u0003J\u0010\u0010/\u001a\u00020\u00002\b\u0010-\u001a\u0004\u0018\u00010\u0003J\b\u00106\u001a\u00020\u0003H\u0016R\u001e\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001e\u0010\f\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\r\u0010\b\"\u0004\b\u000e\u0010\nR\u001e\u0010\u000f\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\u0010\u0010\b\"\u0004\b\u0011\u0010\nR\u001e\u0010\u0012\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\u0013\u0010\b\"\u0004\b\u0014\u0010\nR\u0014\u0010\u0015\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R$\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0006@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0016\"\u0004\b\u0019\u0010\u001aR$\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0006@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0016\"\u0004\b\u001c\u0010\u001aR\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010\u0004R\u001c\u0010!\u001a\u0004\u0018\u00010\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001f\"\u0004\b#\u0010\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010$\u001a\u0004\u0018\u00010%X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001c\u0010*\u001a\u0004\u0018\u00010\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u001f\"\u0004\b,\u0010\u0004R\u001c\u0010-\u001a\u0004\u0018\u00010\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\u001f\"\u0004\b/\u0010\u0004\u00a8\u00068"}, d2={"Lcom/android/builder/signing/DefaultSigningConfig;", "Lcom/android/builder/model/SigningConfig;", "mName", "", "(Ljava/lang/String;)V", "enableV1Signing", "", "getEnableV1Signing", "()Ljava/lang/Boolean;", "setEnableV1Signing", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "enableV2Signing", "getEnableV2Signing", "setEnableV2Signing", "enableV3Signing", "getEnableV3Signing", "setEnableV3Signing", "enableV4Signing", "getEnableV4Signing", "setEnableV4Signing", "isSigningReady", "()Z", "value", "isV1SigningEnabled", "setV1SigningEnabled", "(Z)V", "isV2SigningEnabled", "setV2SigningEnabled", "keyAlias", "getKeyAlias", "()Ljava/lang/String;", "setKeyAlias", "keyPassword", "getKeyPassword", "setKeyPassword", "storeFile", "Ljava/io/File;", "getStoreFile", "()Ljava/io/File;", "setStoreFile", "(Ljava/io/File;)V", "storePassword", "getStorePassword", "setStorePassword", "storeType", "getStoreType", "setStoreType", "equals", "other", "", "getName", "hashCode", "", "toString", "Companion", "builder"})
public class DefaultSigningConfig
implements SigningConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String mName;
    @Nullable
    private File storeFile;
    @Nullable
    private String storePassword;
    @Nullable
    private String keyAlias;
    @Nullable
    private String keyPassword;
    @Nullable
    private String storeType;
    private boolean isV1SigningEnabled;
    private boolean isV2SigningEnabled;
    @Nullable
    private Boolean enableV1Signing;
    @Nullable
    private Boolean enableV2Signing;
    @Nullable
    private Boolean enableV3Signing;
    @Nullable
    private Boolean enableV4Signing;
    @NotNull
    public static final String DEFAULT_PASSWORD = "android";
    @NotNull
    public static final String DEFAULT_ALIAS = "AndroidDebugKey";

    public DefaultSigningConfig(@NotNull String mName) {
        Intrinsics.checkParameterIsNotNull((Object)mName, (String)"mName");
        this.mName = mName;
        this.storeType = KeyStore.getDefaultType();
        this.isV1SigningEnabled = true;
        this.isV2SigningEnabled = true;
    }

    @Nullable
    public File getStoreFile() {
        return this.storeFile;
    }

    public void setStoreFile(@Nullable File file) {
        this.storeFile = file;
    }

    @Nullable
    public String getStorePassword() {
        return this.storePassword;
    }

    public void setStorePassword(@Nullable String string) {
        this.storePassword = string;
    }

    @Nullable
    public String getKeyAlias() {
        return this.keyAlias;
    }

    public void setKeyAlias(@Nullable String string) {
        this.keyAlias = string;
    }

    @Nullable
    public String getKeyPassword() {
        return this.keyPassword;
    }

    public void setKeyPassword(@Nullable String string) {
        this.keyPassword = string;
    }

    @Nullable
    public String getStoreType() {
        return this.storeType;
    }

    public void setStoreType(@Nullable String string) {
        this.storeType = string;
    }

    public boolean isV1SigningEnabled() {
        return this.isV1SigningEnabled;
    }

    public void setV1SigningEnabled(boolean value) {
        this.enableV1Signing = value;
        this.isV1SigningEnabled = value;
    }

    public boolean isV2SigningEnabled() {
        return this.isV2SigningEnabled;
    }

    public void setV2SigningEnabled(boolean value) {
        this.enableV2Signing = value;
        this.isV2SigningEnabled = value;
    }

    @Nullable
    public final Boolean getEnableV1Signing() {
        return this.enableV1Signing;
    }

    public final void setEnableV1Signing(@Nullable Boolean bl2) {
        this.enableV1Signing = bl2;
    }

    @Nullable
    public final Boolean getEnableV2Signing() {
        return this.enableV2Signing;
    }

    public final void setEnableV2Signing(@Nullable Boolean bl2) {
        this.enableV2Signing = bl2;
    }

    @Nullable
    public final Boolean getEnableV3Signing() {
        return this.enableV3Signing;
    }

    public final void setEnableV3Signing(@Nullable Boolean bl2) {
        this.enableV3Signing = bl2;
    }

    @Nullable
    public final Boolean getEnableV4Signing() {
        return this.enableV4Signing;
    }

    public final void setEnableV4Signing(@Nullable Boolean bl2) {
        this.enableV4Signing = bl2;
    }

    public boolean isSigningReady() {
        return this.getStoreFile() != null && this.getStorePassword() != null && this.getKeyAlias() != null && this.getKeyPassword() != null;
    }

    @NotNull
    public String getName() {
        return this.mName;
    }

    @NotNull
    public final DefaultSigningConfig setStoreFile(@Nullable File storeFile) {
        this.setStoreFile(storeFile);
        return this;
    }

    @NotNull
    public final DefaultSigningConfig setStorePassword(@Nullable String storePassword) {
        this.setStorePassword(storePassword);
        return this;
    }

    @NotNull
    public final DefaultSigningConfig setKeyAlias(@Nullable String keyAlias) {
        this.setKeyAlias(keyAlias);
        return this;
    }

    @NotNull
    public final DefaultSigningConfig setKeyPassword(@Nullable String keyPassword) {
        this.setKeyPassword(keyPassword);
        return this;
    }

    @NotNull
    public final DefaultSigningConfig setStoreType(@Nullable String storeType) {
        this.setStoreType(storeType);
        return this;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual(this.getClass(), other.getClass())) {
            return false;
        }
        DefaultSigningConfig that = (DefaultSigningConfig)other;
        if (!Intrinsics.areEqual((Object)this.getKeyAlias(), (Object)that.getKeyAlias())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getKeyPassword(), (Object)that.getKeyPassword())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getStoreFile(), (Object)that.getStoreFile())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getStorePassword(), (Object)that.getStorePassword())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getStoreType(), (Object)that.getStoreType())) {
            return false;
        }
        if (this.isV1SigningEnabled() != that.isV1SigningEnabled()) {
            return false;
        }
        if (this.isV2SigningEnabled() != that.isV2SigningEnabled()) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.enableV1Signing, (Object)that.enableV1Signing)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.enableV2Signing, (Object)that.enableV2Signing)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.enableV3Signing, (Object)that.enableV3Signing)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.enableV4Signing, (Object)that.enableV4Signing);
    }

    public int hashCode() {
        int n10;
        int result = super.hashCode();
        Object object = this.getStoreFile();
        result = 31 * result + (object == null ? 0 : (n10 = ((File)object).hashCode()));
        object = this.getStorePassword();
        result = 31 * result + (object == null ? 0 : (n10 = ((String)object).hashCode()));
        object = this.getKeyAlias();
        result = 31 * result + (object == null ? 0 : (n10 = ((String)object).hashCode()));
        object = this.getKeyPassword();
        result = 31 * result + (object == null ? 0 : (n10 = ((String)object).hashCode()));
        object = this.getStoreType();
        result = 31 * result + (object == null ? 0 : (n10 = ((String)object).hashCode()));
        result = 31 * result + (this.isV1SigningEnabled() ? 17 : 0);
        result = 31 * result + (this.isV2SigningEnabled() ? 17 : 0);
        object = this.enableV1Signing;
        result = 31 * result + (object == null ? 0 : (n10 = object.hashCode()));
        object = this.enableV2Signing;
        result = 31 * result + (object == null ? 0 : (n10 = object.hashCode()));
        object = this.enableV3Signing;
        result = 31 * result + (object == null ? 0 : (n10 = object.hashCode()));
        object = this.enableV4Signing;
        result = 31 * result + (object == null ? 0 : (n10 = object.hashCode()));
        return result;
    }

    @NotNull
    public String toString() {
        File file;
        String string = MoreObjects.toStringHelper((Object)this).add("storeFile", (Object)((file = this.getStoreFile()) == null ? null : file.getAbsolutePath())).add("storePassword", (Object)this.getStorePassword()).add("keyAlias", (Object)this.getKeyAlias()).add("keyPassword", (Object)this.getKeyPassword()).add("storeType", (Object)this.getStoreType()).add("v1SigningEnabled", this.isV1SigningEnabled()).add("v2SigningEnabled", this.isV2SigningEnabled()).add("enableV1Signing", (Object)this.enableV1Signing).add("enableV2Signing", (Object)this.enableV2Signing).add("enableV3Signing", (Object)this.enableV3Signing).add("enableV4Signing", (Object)this.enableV4Signing).toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"toStringHelper(this)\n            .add(\"storeFile\", storeFile?.absolutePath)\n            .add(\"storePassword\", storePassword)\n            .add(\"keyAlias\", keyAlias)\n            .add(\"keyPassword\", keyPassword)\n            .add(\"storeType\", storeType)\n            .add(\"v1SigningEnabled\", isV1SigningEnabled)\n            .add(\"v2SigningEnabled\", isV2SigningEnabled)\n            .add(\"enableV1Signing\", enableV1Signing)\n            .add(\"enableV2Signing\", enableV2Signing)\n            .add(\"enableV3Signing\", enableV3Signing)\n            .add(\"enableV4Signing\", enableV4Signing)\n            .toString()");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final DefaultSigningConfig debugSigningConfig(@NotNull File storeFile) {
        return Companion.debugSigningConfig(storeFile);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/builder/signing/DefaultSigningConfig$Companion;", "", "()V", "DEFAULT_ALIAS", "", "DEFAULT_PASSWORD", "debugSigningConfig", "Lcom/android/builder/signing/DefaultSigningConfig;", "storeFile", "Ljava/io/File;", "builder"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final DefaultSigningConfig debugSigningConfig(@NotNull File storeFile) {
            Intrinsics.checkParameterIsNotNull((Object)storeFile, (String)"storeFile");
            DefaultSigningConfig result = new DefaultSigningConfig("debug");
            result.setStoreFile(storeFile);
            result.setStorePassword(DefaultSigningConfig.DEFAULT_PASSWORD);
            result.setKeyAlias(DefaultSigningConfig.DEFAULT_ALIAS);
            result.setKeyPassword(DefaultSigningConfig.DEFAULT_PASSWORD);
            return result;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

