/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.compiler;

import com.android.SdkConstants;
import com.android.builder.internal.compiler.DirectoryWalker;
import com.android.ide.common.internal.WaitableExecutor;
import com.android.ide.common.process.ProcessExecutor;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.process.ProcessResult;
import com.android.io.CancellableFileIo;
import com.android.sdklib.BuildToolInfo;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\b\u0017\u0018\u0000 H2\u00020\u0001:\u0003FGHB\u0087\u0001\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\u0004\u0012\u0006\u0010\t\u001a\u00020\u0004\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u0012\u0006\u0010\u0012\u001a\u00020\u0010\u0012\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u0018J\u0016\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-JP\u0010.\u001a\u00020)2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u0004002\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0014\u00101\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u0015022\u0006\u00103\u001a\u00020\u00042\n\b\u0002\u00104\u001a\u0004\u0018\u00010\u0015H\u0002J,\u00105\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u001502H\u0002JG\u00106\u001a\u00020)2\u0006\u00107\u001a\u00020\u00042\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u001502H\u0002\u00a2\u0006\u0002\u00109JL\u0010:\u001a\u00020)2\u0006\u0010;\u001a\u00020\u00042\u0006\u0010<\u001a\u00020\u001b2\u0006\u0010=\u001a\u00020\u00152\u0006\u0010>\u001a\u00020\u00042\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u001502H\u0002JL\u0010?\u001a\u00020\u00042\u0006\u0010@\u001a\u00020\u00042\u0006\u0010<\u001a\u00020\u001b2\u0006\u0010A\u001a\u00020\u00152\u0006\u0010B\u001a\u00020\u00042\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u001502H\u0002J<\u0010C\u001a\u00020)2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u0004002\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0014\u00101\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u001502H\u0002J\u0010\u0010D\u001a\u00020\u00042\u0006\u0010E\u001a\u00020\u0015H\u0002R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001cR\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001cR\u000e\u0010\u001e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020&0%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u0004\u0018\u00010&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lcom/android/builder/internal/compiler/RenderScriptProcessor;", "", "sourceFolders", "", "Ljava/io/File;", "importFolders", "sourceOutputDir", "resOutputDir", "objOutputDir", "libOutputDir", "buildToolInfo", "Lcom/android/sdklib/BuildToolInfo;", "targetApi", "", "optimizationLevel", "ndkMode", "", "supportMode", "useAndroidX", "abiFilters", "", "", "logger", "Lcom/android/utils/ILogger;", "(Ljava/util/Collection;Ljava/util/Collection;Ljava/io/File;Ljava/io/File;Ljava/io/File;Ljava/io/File;Lcom/android/sdklib/BuildToolInfo;IIZZZLjava/util/Set;Lcom/android/utils/ILogger;)V", "abis32", "", "Lcom/android/builder/internal/compiler/RenderScriptProcessor$Abi;", "[Lcom/android/builder/internal/compiler/RenderScriptProcessor$Abi;", "abis64", "actualTargetApi", "genericRawFolder", "getGenericRawFolder", "()Ljava/io/File;", "is32Bit", "is64Bit", "libClCore", "", "Ljava/nio/file/Path;", "rsLib", "build", "", "processExecutor", "Lcom/android/ide/common/process/ProcessExecutor;", "processOutputHandler", "Lcom/android/ide/common/process/ProcessOutputHandler;", "compileBCFiles", "inputFiles", "", "env", "", "outputFile", "arch", "createSupportFiles", "createSupportFilesHelper", "rawFolder", "abis", "(Ljava/io/File;[Lcom/android/builder/internal/compiler/RenderScriptProcessor$Abi;Lcom/android/ide/common/process/ProcessExecutor;Lcom/android/ide/common/process/ProcessOutputHandler;Ljava/util/Map;)V", "createSupportLibFile", "objFile", "abi", "soName", "libAbiFolder", "createSupportObjFile", "bcFile", "objName", "objAbiFolder", "doMainCompilation", "getArchSpecificRawFolder", "architecture", "Abi", "AbiType", "Companion", "builder"})
public final class RenderScriptProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Collection<File> sourceFolders;
    @NotNull
    private final Collection<File> importFolders;
    @NotNull
    private final File sourceOutputDir;
    @NotNull
    private final File resOutputDir;
    @NotNull
    private final File objOutputDir;
    @NotNull
    private final File libOutputDir;
    @NotNull
    private final BuildToolInfo buildToolInfo;
    private final int optimizationLevel;
    private final boolean ndkMode;
    private final boolean supportMode;
    private final boolean useAndroidX;
    @NotNull
    private final Set<String> abiFilters;
    @NotNull
    private final ILogger logger;
    private final boolean is32Bit;
    private final boolean is64Bit;
    @Nullable
    private final Path rsLib;
    @NotNull
    private final Map<String, Path> libClCore;
    @NotNull
    private final Abi[] abis32;
    @NotNull
    private final Abi[] abis64;
    private final int actualTargetApi;

    public RenderScriptProcessor(@NotNull Collection<? extends File> sourceFolders, @NotNull Collection<? extends File> importFolders, @NotNull File sourceOutputDir, @NotNull File resOutputDir, @NotNull File objOutputDir, @NotNull File libOutputDir, @NotNull BuildToolInfo buildToolInfo, int targetApi, int optimizationLevel, boolean ndkMode, boolean supportMode, boolean useAndroidX, @NotNull Set<String> abiFilters, @NotNull ILogger logger) {
        int n12;
        boolean bl2;
        Intrinsics.checkNotNullParameter(sourceFolders, (String)"sourceFolders");
        Intrinsics.checkNotNullParameter(importFolders, (String)"importFolders");
        Intrinsics.checkNotNullParameter((Object)sourceOutputDir, (String)"sourceOutputDir");
        Intrinsics.checkNotNullParameter((Object)resOutputDir, (String)"resOutputDir");
        Intrinsics.checkNotNullParameter((Object)objOutputDir, (String)"objOutputDir");
        Intrinsics.checkNotNullParameter((Object)libOutputDir, (String)"libOutputDir");
        Intrinsics.checkNotNullParameter((Object)buildToolInfo, (String)"buildToolInfo");
        Intrinsics.checkNotNullParameter(abiFilters, (String)"abiFilters");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.sourceFolders = sourceFolders;
        this.importFolders = importFolders;
        this.sourceOutputDir = sourceOutputDir;
        this.resOutputDir = resOutputDir;
        this.objOutputDir = objOutputDir;
        this.libOutputDir = libOutputDir;
        this.buildToolInfo = buildToolInfo;
        this.optimizationLevel = optimizationLevel;
        this.ndkMode = ndkMode;
        this.supportMode = supportMode;
        this.useAndroidX = useAndroidX;
        this.abiFilters = abiFilters;
        this.logger = logger;
        int n13 = 0;
        this.libClCore = new LinkedHashMap();
        if (this.supportMode) {
            n13 = 18;
            bl2 = false;
            n12 = Math.max(n13, targetApi);
        } else {
            n13 = 11;
            bl2 = false;
            n12 = Math.max(n13, targetApi);
        }
        this.actualTargetApi = n12;
        this.abis32 = RenderScriptProcessor.Companion.getAbis(AbiType.BIT_32);
        this.abis64 = RenderScriptProcessor.Companion.getAbis(AbiType.BIT_64);
        if (this.supportMode) {
            boolean bl3;
            Path path;
            String string;
            Map<String, Path> map;
            Path rsClCoreFile;
            Path rs2 = this.buildToolInfo.getLocation().resolve("renderscript");
            this.rsLib = rs2.resolve("lib");
            Path bcFolder = this.rsLib.resolve("bc");
            for (Abi abi : this.abis32) {
                rsClCoreFile = bcFolder.resolve(Intrinsics.stringPlus((String)abi.getDevice(), (Object)"/libclcore.bc"));
                if (!CancellableFileIo.exists((Path)rsClCoreFile, (LinkOption[])new LinkOption[0])) continue;
                map = this.libClCore;
                string = abi.getDevice();
                Intrinsics.checkNotNullExpressionValue((Object)rsClCoreFile, (String)"rsClCoreFile");
                path = rsClCoreFile;
                bl3 = false;
                map.put(string, path);
            }
            for (Abi abi : this.abis64) {
                rsClCoreFile = bcFolder.resolve(Intrinsics.stringPlus((String)abi.getDevice(), (Object)"/libclcore.bc"));
                if (!CancellableFileIo.exists((Path)rsClCoreFile, (LinkOption[])new LinkOption[0])) continue;
                map = this.libClCore;
                string = abi.getDevice();
                Intrinsics.checkNotNullExpressionValue((Object)rsClCoreFile, (String)"rsClCoreFile");
                path = rsClCoreFile;
                bl3 = false;
                map.put(string, path);
            }
        } else {
            this.rsLib = null;
        }
        if (this.abiFilters.isEmpty()) {
            this.is32Bit = true;
            this.is64Bit = true;
        } else {
            boolean bl4;
            boolean bl5;
            block12: {
                boolean bl6;
                Abi abi;
                Abi element$iv;
                int n14;
                int n15;
                Abi[] abiArray;
                Abi[] $this$any$iv;
                boolean $i$f$any;
                RenderScriptProcessor renderScriptProcessor;
                block11: {
                    Abi[] rs2 = this.abis32;
                    renderScriptProcessor = this;
                    $i$f$any = false;
                    abiArray = $this$any$iv;
                    n15 = abiArray.length;
                    for (n14 = 0; n14 < n15; ++n14) {
                        abi = element$iv = abiArray[n14];
                        boolean bl7 = false;
                        if (!this.abiFilters.contains(abi.getDevice())) continue;
                        bl6 = true;
                        break block11;
                    }
                    bl6 = false;
                }
                renderScriptProcessor.is32Bit = bl5 = bl6;
                $this$any$iv = this.abis64;
                renderScriptProcessor = this;
                $i$f$any = false;
                abiArray = $this$any$iv;
                n15 = abiArray.length;
                for (n14 = 0; n14 < n15; ++n14) {
                    abi = element$iv = abiArray[n14];
                    boolean bl8 = false;
                    if (!this.abiFilters.contains(abi.getDevice())) continue;
                    bl4 = true;
                    break block12;
                }
                bl4 = false;
            }
            renderScriptProcessor.is64Bit = bl5 = bl4;
        }
        if (targetApi < 21 && this.is64Bit && this.ndkMode) {
            throw new RuntimeException("Api version " + targetApi + " does not support 64 bit ndk compilation");
        }
    }

    private final File getGenericRawFolder() {
        return new File(this.resOutputDir, "raw");
    }

    public final void build(@NotNull ProcessExecutor processExecutor, @NotNull ProcessOutputHandler processOutputHandler) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)processExecutor, (String)"processExecutor");
        Intrinsics.checkNotNullParameter((Object)processOutputHandler, (String)"processOutputHandler");
        boolean bl2 = false;
        List renderscriptFiles = new ArrayList();
        for (File dir : this.sourceFolders) {
            object = new String[]{"rs", "fs"};
            DirectoryWalker.builder().root(dir.toPath()).extensions((String)object).action(new DirectoryWalker.FileAction(renderscriptFiles){
                final /* synthetic */ List<File> $renderscriptFiles;
                {
                    this.$renderscriptFiles = $renderscriptFiles;
                }

                public final void call(@NotNull Path $noName_0, @NotNull Path path) {
                    Intrinsics.checkNotNullParameter((Object)$noName_0, (String)"$noName_0");
                    Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                    File file = path.toFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"path.toFile()");
                    this.$renderscriptFiles.add(file);
                }
            }).build().walk();
        }
        if (renderscriptFiles.isEmpty()) {
            return;
        }
        boolean bl3 = false;
        Map env = new LinkedHashMap();
        if (SdkConstants.CURRENT_PLATFORM == 3) {
            Map map = env;
            object = "DYLD_LIBRARY_PATH";
            String string = ((Object)this.buildToolInfo.getLocation().toAbsolutePath()).toString();
            boolean bl4 = false;
            map.put(object, string);
        } else if (SdkConstants.CURRENT_PLATFORM == 1) {
            Map map = env;
            object = "LD_LIBRARY_PATH";
            String string = ((Object)this.buildToolInfo.getLocation().toAbsolutePath()).toString();
            boolean bl5 = false;
            map.put(object, string);
        }
        this.doMainCompilation(renderscriptFiles, processExecutor, processOutputHandler, env);
        if (this.supportMode) {
            this.createSupportFiles(processExecutor, processOutputHandler, env);
        }
    }

    private final File getArchSpecificRawFolder(String architecture) {
        String[] stringArray = new String[]{"raw", Intrinsics.stringPlus((String)"bc", (Object)architecture)};
        File file = FileUtils.join((File)this.resOutputDir, (String[])stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"join(resOutputDir, SdkConstants.FD_RES_RAW, \"bc$architecture\")");
        return file;
    }

    private final void doMainCompilation(List<? extends File> inputFiles, ProcessExecutor processExecutor, ProcessOutputHandler processOutputHandler, Map<String, String> env) {
        boolean bl2 = false;
        List architectures = new ArrayList();
        if (this.is32Bit) {
            architectures.add("32");
        }
        if (this.is64Bit) {
            architectures.add("64");
        }
        if (this.actualTargetApi >= 21 && this.ndkMode) {
            for (String arch : architectures) {
                this.compileBCFiles(inputFiles, processExecutor, processOutputHandler, env, this.getArchSpecificRawFolder(arch), arch);
            }
        } else {
            RenderScriptProcessor.compileBCFiles$default(this, inputFiles, processExecutor, processOutputHandler, env, this.getGenericRawFolder(), null, 32, null);
        }
    }

    private final void compileBCFiles(List<? extends File> inputFiles, ProcessExecutor processExecutor, ProcessOutputHandler processOutputHandler, Map<String, String> env, File outputFile, String arch) {
        boolean bl2;
        Boolean bl3;
        ProcessInfoBuilder builder = new ProcessInfoBuilder();
        String renderscript = this.buildToolInfo.getPath(BuildToolInfo.PathId.LLVM_RS_CC);
        String string = renderscript;
        if (string == null) {
            bl3 = null;
        } else {
            String string2 = string;
            bl2 = false;
            boolean bl4 = false;
            String it2 = string2;
            boolean bl5 = false;
            bl3 = new File(it2).isFile();
        }
        boolean bl6 = Intrinsics.areEqual(bl3, (Object)true);
        boolean bl7 = false;
        bl2 = false;
        if (!bl6) {
            boolean bl4 = false;
            String string3 = BuildToolInfo.PathId.LLVM_RS_CC + " is missing";
            throw (Throwable)new IllegalStateException(string3.toString());
        }
        builder.setExecutable(renderscript);
        builder.addEnvironments(env);
        String rsPath = this.buildToolInfo.getPath(BuildToolInfo.PathId.ANDROID_RS);
        String rsClangPath = this.buildToolInfo.getPath(BuildToolInfo.PathId.ANDROID_RS_CLANG);
        builder.addArgs("-I");
        builder.addArgs(rsPath);
        builder.addArgs("-I");
        builder.addArgs(rsClangPath);
        for (File file : this.importFolders) {
            if (!file.isDirectory()) continue;
            builder.addArgs("-I");
            builder.addArgs(file.getAbsolutePath());
        }
        if (this.supportMode) {
            if (this.useAndroidX) {
                builder.addArgs("-rs-package-name=androidx.renderscript");
            } else {
                builder.addArgs("-rs-package-name=android.support.v8.renderscript");
            }
        }
        builder.addArgs("-p");
        builder.addArgs(this.sourceOutputDir.getAbsolutePath());
        builder.addArgs("-target-api");
        builder.addArgs(String.valueOf(this.actualTargetApi));
        for (File file : inputFiles) {
            builder.addArgs(file.getAbsolutePath());
        }
        if (this.ndkMode) {
            builder.addArgs("-reflect-c++");
        }
        builder.addArgs("-O");
        builder.addArgs(String.valueOf(this.optimizationLevel));
        builder.addArgs("-o");
        builder.addArgs(outputFile.getAbsolutePath());
        if (arch != null) {
            builder.addArgs(Intrinsics.stringPlus((String)"-m", (Object)arch));
        }
        ProcessResult result = processExecutor.execute(builder.createProcess(), processOutputHandler);
        result.rethrowFailure().assertNormalExitValue();
    }

    static /* synthetic */ void compileBCFiles$default(RenderScriptProcessor renderScriptProcessor, List list, ProcessExecutor processExecutor, ProcessOutputHandler processOutputHandler, Map map, File file, String string, int n12, Object object) {
        if ((n12 & 0x20) != 0) {
            string = null;
        }
        renderScriptProcessor.compileBCFiles(list, processExecutor, processOutputHandler, map, file, string);
    }

    private final void createSupportFiles(ProcessExecutor processExecutor, ProcessOutputHandler processOutputHandler, Map<String, String> env) {
        if (this.actualTargetApi < 21) {
            File rawFolder = this.getGenericRawFolder();
            this.createSupportFilesHelper(rawFolder, this.abis32, processExecutor, processOutputHandler, env);
        } else {
            File rawFolder32 = this.getArchSpecificRawFolder("32");
            this.createSupportFilesHelper(rawFolder32, this.abis32, processExecutor, processOutputHandler, env);
            File rawFolder64 = this.getArchSpecificRawFolder("64");
            this.createSupportFilesHelper(rawFolder64, this.abis64, processExecutor, processOutputHandler, env);
        }
    }

    private final void createSupportFilesHelper(File rawFolder, Abi[] abis, ProcessExecutor processExecutor, ProcessOutputHandler processOutputHandler, Map<String, String> env) {
        WaitableExecutor mExecutor = WaitableExecutor.useGlobalSharedThreadPool();
        boolean bl2 = false;
        List files = new ArrayList();
        String[] stringArray = new String[]{"bc"};
        DirectoryWalker.builder().root(rawFolder.toPath()).extensions(stringArray).action(new DirectoryWalker.FileAction(files){
            final /* synthetic */ List<File> $files;
            {
                this.$files = $files;
            }

            public final void call(@NotNull Path $noName_0, @NotNull Path path) {
                Intrinsics.checkNotNullParameter((Object)$noName_0, (String)"$noName_0");
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                File file = path.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"path.toFile()");
                this.$files.add(file);
            }
        }).build().walk();
        for (File bcFile : files) {
            String name = bcFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
            CharSequence charSequence = name;
            Abi[] abiArray = "\\.bc";
            int n12 = 0;
            abiArray = new Regex((String)abiArray);
            String string = ".o";
            int n13 = 0;
            String objName = abiArray.replace(charSequence, string);
            abiArray = name;
            string = "\\.bc";
            n13 = 0;
            string = new Regex(string);
            String string2 = ".so";
            boolean bl3 = false;
            String soName = Intrinsics.stringPlus((String)"librs.", (Object)string.replace((CharSequence)abiArray, string2));
            for (Abi abi : abis) {
                Collection collection = this.abiFilters;
                boolean bl4 = false;
                if (!collection.isEmpty() && !this.abiFilters.contains(abi.getDevice())) continue;
                if (this.libClCore.get(abi.getDevice()) == null) {
                    this.logger.warning(StringsKt.trimMargin((String)("|Skipped RenderScript support mode compilation for " + abi.getDevice() + " : required components not found in Build-Tools " + this.buildToolInfo.getRevision() + "\n                           |Please check and update your BuildTools."), (String)"|"), new Object[0]);
                    continue;
                }
                File objAbiFolder = new File(this.objOutputDir, abi.getDevice());
                if (!objAbiFolder.isDirectory() && !objAbiFolder.mkdirs()) {
                    throw new IOException(Intrinsics.stringPlus((String)"Unable to create dir ", (Object)objAbiFolder.getAbsolutePath()));
                }
                File libAbiFolder = new File(this.libOutputDir, abi.getDevice());
                if (!libAbiFolder.isDirectory() && !libAbiFolder.mkdirs()) {
                    throw new IOException(Intrinsics.stringPlus((String)"Unable to create dir ", (Object)libAbiFolder.getAbsolutePath()));
                }
                mExecutor.execute(new Callable(this, bcFile, abi, objName, objAbiFolder, processExecutor, processOutputHandler, env, soName, libAbiFolder){
                    final /* synthetic */ RenderScriptProcessor this$0;
                    final /* synthetic */ File $bcFile;
                    final /* synthetic */ Abi $abi;
                    final /* synthetic */ String $objName;
                    final /* synthetic */ File $objAbiFolder;
                    final /* synthetic */ ProcessExecutor $processExecutor;
                    final /* synthetic */ ProcessOutputHandler $processOutputHandler;
                    final /* synthetic */ Map<String, String> $env;
                    final /* synthetic */ String $soName;
                    final /* synthetic */ File $libAbiFolder;
                    {
                        this.this$0 = $receiver;
                        this.$bcFile = $bcFile;
                        this.$abi = $abi;
                        this.$objName = $objName;
                        this.$objAbiFolder = $objAbiFolder;
                        this.$processExecutor = $processExecutor;
                        this.$processOutputHandler = $processOutputHandler;
                        this.$env = $env;
                        this.$soName = $soName;
                        this.$libAbiFolder = $libAbiFolder;
                    }

                    @Nullable
                    public final Void call() {
                        File objFile = RenderScriptProcessor.access$createSupportObjFile(this.this$0, this.$bcFile, this.$abi, this.$objName, this.$objAbiFolder, this.$processExecutor, this.$processOutputHandler, this.$env);
                        RenderScriptProcessor.access$createSupportLibFile(this.this$0, objFile, this.$abi, this.$soName, this.$libAbiFolder, this.$processExecutor, this.$processOutputHandler, this.$env);
                        return null;
                    }
                });
            }
        }
        mExecutor.waitForTasksWithQuickFail(true);
    }

    private final File createSupportObjFile(File bcFile, Abi abi, String objName, File objAbiFolder, ProcessExecutor processExecutor, ProcessOutputHandler processOutputHandler, Map<String, String> env) {
        ProcessInfoBuilder builder = new ProcessInfoBuilder();
        builder.setExecutable(this.buildToolInfo.getPath(BuildToolInfo.PathId.BCC_COMPAT));
        builder.addEnvironments(env);
        builder.addArgs(Intrinsics.stringPlus((String)"-O", (Object)this.optimizationLevel));
        File outFile = new File(objAbiFolder, objName);
        builder.addArgs("-o", outFile.getAbsolutePath());
        builder.addArgs("-fPIC");
        builder.addArgs("-shared");
        builder.addArgs("-rt-path", ((Object)((Path)MapsKt.getValue(this.libClCore, (Object)abi.getDevice())).toAbsolutePath()).toString());
        builder.addArgs("-mtriple", abi.getToolchain());
        builder.addArgs(bcFile.getAbsolutePath());
        processExecutor.execute(builder.createProcess(), processOutputHandler).rethrowFailure().assertNormalExitValue();
        return outFile;
    }

    private final void createSupportLibFile(File objFile, Abi abi, String soName, File libAbiFolder, ProcessExecutor processExecutor, ProcessOutputHandler processOutputHandler, Map<String, String> env) {
        Path path = this.rsLib;
        Path root = path == null ? Paths.get("", new String[0]) : path;
        Path intermediatesFolder = root.resolve("intermediates");
        Path intermediatesAbiFolder = intermediatesFolder.resolve(abi.getDevice());
        Path packagedFolder = root.resolve("packaged");
        Path packagedAbiFolder = packagedFolder.resolve(abi.getDevice());
        ProcessInfoBuilder builder = new ProcessInfoBuilder();
        builder.setExecutable(this.buildToolInfo.getPath(abi.getLinker()));
        builder.addEnvironments(env);
        String[] stringArray = new String[]{"noexecstack", "-z", "relro", "-z", "now"};
        builder.addArgs(abi.getLinkerArgs()).addArgs("--eh-frame-hdr").addArgs("-shared", "-Bsymbolic", "-z", stringArray);
        File outFile = new File(libAbiFolder, soName);
        builder.addArgs("-o", outFile.getAbsolutePath());
        String[] stringArray2 = new String[]{soName, objFile.getAbsolutePath(), ((Object)intermediatesAbiFolder.resolve("libcompiler_rt.a").toAbsolutePath()).toString(), "-lRSSupport", "-lm", "-lc"};
        builder.addArgs(Intrinsics.stringPlus((String)"-L", (Object)intermediatesAbiFolder.toAbsolutePath()), Intrinsics.stringPlus((String)"-L", (Object)packagedAbiFolder.toAbsolutePath()), "-soname", stringArray2);
        processExecutor.execute(builder.createProcess(), processOutputHandler).rethrowFailure().assertNormalExitValue();
    }

    @JvmStatic
    @NotNull
    public static final File getSupportJar(@NotNull File buildToolsFolder, boolean useAndroidX) {
        return Companion.getSupportJar(buildToolsFolder, useAndroidX);
    }

    @JvmStatic
    @NotNull
    public static final File getSupportNativeLibFolder(@NotNull File buildToolsFolder) {
        return Companion.getSupportNativeLibFolder(buildToolsFolder);
    }

    @JvmStatic
    @NotNull
    public static final File getSupportBlasLibFolder(@NotNull File buildToolsFolder) {
        return Companion.getSupportBlasLibFolder(buildToolsFolder);
    }

    @JvmStatic
    private static final File getBaseRenderscriptLibFolder(File buildToolsFolder) {
        return RenderScriptProcessor.Companion.getBaseRenderscriptLibFolder(buildToolsFolder);
    }

    @JvmStatic
    @VisibleForTesting
    @Nullable
    public static final Abi[] getAbis(@NotNull String abiType) {
        return Companion.getAbis(abiType);
    }

    public static final /* synthetic */ File access$createSupportObjFile(RenderScriptProcessor $this, File bcFile, Abi abi, String objName, File objAbiFolder, ProcessExecutor processExecutor, ProcessOutputHandler processOutputHandler, Map env) {
        return $this.createSupportObjFile(bcFile, abi, objName, objAbiFolder, processExecutor, processOutputHandler, env);
    }

    public static final /* synthetic */ void access$createSupportLibFile(RenderScriptProcessor $this, File objFile, Abi abi, String soName, File libAbiFolder, ProcessExecutor processExecutor, ProcessOutputHandler processOutputHandler, Map env) {
        $this.createSupportLibFile(objFile, abi, soName, libAbiFolder, processExecutor, processOutputHandler, env);
    }

    @VisibleForTesting
    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0002\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\t\u00a8\u0006\u0012"}, d2={"Lcom/android/builder/internal/compiler/RenderScriptProcessor$Abi;", "", "device", "", "toolchain", "linkerArgs", "", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "getDevice", "()Ljava/lang/String;", "linker", "Lcom/android/sdklib/BuildToolInfo$PathId;", "getLinker", "()Lcom/android/sdklib/BuildToolInfo$PathId;", "[Ljava/lang/String;", "getToolchain", "getLinkerArgs", "()[Ljava/lang/String;", "builder"})
    public static final class Abi {
        @NotNull
        private final String device;
        @NotNull
        private final String toolchain;
        @NotNull
        private final String[] linkerArgs;
        @NotNull
        private final BuildToolInfo.PathId linker;

        public Abi(@NotNull String device, @NotNull String toolchain, @NotNull String[] linkerArgs) {
            Intrinsics.checkNotNullParameter((Object)device, (String)"device");
            Intrinsics.checkNotNullParameter((Object)toolchain, (String)"toolchain");
            Intrinsics.checkNotNullParameter((Object)linkerArgs, (String)"linkerArgs");
            this.device = device;
            this.toolchain = toolchain;
            this.linkerArgs = linkerArgs;
            this.linker = BuildToolInfo.PathId.LLD;
        }

        @NotNull
        public final String getDevice() {
            return this.device;
        }

        @NotNull
        public final String getToolchain() {
            return this.toolchain;
        }

        @NotNull
        public final BuildToolInfo.PathId getLinker() {
            return this.linker;
        }

        @NotNull
        public final String[] getLinkerArgs() {
            Object[] objectArray = new String[]{"-flavor", "ld"};
            return (String[])ArraysKt.plus((Object[])objectArray, (Object[])this.linkerArgs);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/android/builder/internal/compiler/RenderScriptProcessor$AbiType;", "", "(Ljava/lang/String;I)V", "BIT_32", "BIT_64", "builder"})
    private static final class AbiType
    extends Enum<AbiType> {
        public static final /* enum */ AbiType BIT_32 = new AbiType();
        public static final /* enum */ AbiType BIT_64 = new AbiType();
        private static final /* synthetic */ AbiType[] $VALUES;

        public static AbiType[] values() {
            AbiType[] abiTypeArray = $VALUES;
            AbiType[] abiTypeArray2 = new AbiType[abiTypeArray.length];
            System.arraycopy(abiTypeArray, 0, abiTypeArray2, 0, abiTypeArray.length);
            return abiTypeArray2;
        }

        public static AbiType valueOf(String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return Enum.valueOf(AbiType.class, value);
        }

        static {
            AbiType[] abiTypeArray = new AbiType[]{BIT_32, BIT_64};
            $VALUES = abiTypeArray;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\bJ\u001d\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\nH\u0007\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0003J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0007J\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0007\u00a8\u0006\u0014"}, d2={"Lcom/android/builder/internal/compiler/RenderScriptProcessor$Companion;", "", "()V", "getAbis", "", "Lcom/android/builder/internal/compiler/RenderScriptProcessor$Abi;", "type", "Lcom/android/builder/internal/compiler/RenderScriptProcessor$AbiType;", "(Lcom/android/builder/internal/compiler/RenderScriptProcessor$AbiType;)[Lcom/android/builder/internal/compiler/RenderScriptProcessor$Abi;", "abiType", "", "(Ljava/lang/String;)[Lcom/android/builder/internal/compiler/RenderScriptProcessor$Abi;", "getBaseRenderscriptLibFolder", "Ljava/io/File;", "buildToolsFolder", "getSupportBlasLibFolder", "getSupportJar", "useAndroidX", "", "getSupportNativeLibFolder", "builder"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final File getSupportJar(@NotNull File buildToolsFolder, boolean useAndroidX) {
            Intrinsics.checkNotNullParameter((Object)buildToolsFolder, (String)"buildToolsFolder");
            return new File(this.getBaseRenderscriptLibFolder(buildToolsFolder), useAndroidX ? "androidx-rs.jar" : "renderscript-v8.jar");
        }

        @JvmStatic
        @NotNull
        public final File getSupportNativeLibFolder(@NotNull File buildToolsFolder) {
            Intrinsics.checkNotNullParameter((Object)buildToolsFolder, (String)"buildToolsFolder");
            return new File(this.getBaseRenderscriptLibFolder(buildToolsFolder), "packaged");
        }

        @JvmStatic
        @NotNull
        public final File getSupportBlasLibFolder(@NotNull File buildToolsFolder) {
            Intrinsics.checkNotNullParameter((Object)buildToolsFolder, (String)"buildToolsFolder");
            return new File(this.getBaseRenderscriptLibFolder(buildToolsFolder), "blas");
        }

        @JvmStatic
        private final File getBaseRenderscriptLibFolder(File buildToolsFolder) {
            return new File(buildToolsFolder, "renderscript/lib");
        }

        private final Abi[] getAbis(AbiType type) {
            Abi[] abiArray;
            AbiType abiType = type;
            int n12 = WhenMappings.$EnumSwitchMapping$0[abiType.ordinal()];
            switch (n12) {
                case 1: {
                    Abi[] abiArray2 = new Abi[3];
                    String[] stringArray = new String[]{"-dynamic-linker", "/system/bin/linker", "-X", "-m", "armelf_linux_eabi"};
                    abiArray2[0] = new Abi("armeabi-v7a", "armv7-none-linux-gnueabi", stringArray);
                    stringArray = new String[]{"-EL"};
                    abiArray2[1] = new Abi("mips", "mipsel-unknown-linux", stringArray);
                    stringArray = new String[]{"-m", "elf_i386"};
                    abiArray2[2] = new Abi("x86", "i686-unknown-linux", stringArray);
                    abiArray = abiArray2;
                    break;
                }
                case 2: {
                    Abi[] abiArray3 = new Abi[2];
                    String[] stringArray = new String[]{"-X", "--fix-cortex-a53-843419"};
                    abiArray3[0] = new Abi("arm64-v8a", "aarch64-linux-android", stringArray);
                    stringArray = new String[]{"-m", "elf_x86_64"};
                    abiArray3[1] = new Abi("x86_64", "x86_64-unknown-linux", stringArray);
                    abiArray = abiArray3;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return abiArray;
        }

        @JvmStatic
        @VisibleForTesting
        @Nullable
        public final Abi[] getAbis(@NotNull String abiType) {
            Intrinsics.checkNotNullParameter((Object)abiType, (String)"abiType");
            String string = abiType;
            return Intrinsics.areEqual((Object)string, (Object)"32") ? this.getAbis(AbiType.BIT_32) : (Intrinsics.areEqual((Object)string, (Object)"64") ? this.getAbis(AbiType.BIT_64) : null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[AbiType.values().length];
                nArray[AbiType.BIT_32.ordinal()] = 1;
                nArray[AbiType.BIT_64.ordinal()] = 2;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

