/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.aar;

import com.android.builder.utils.ZipEntryUtils;
import com.android.utils.FileUtils;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fR\u0012\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/builder/aar/AarExtractor;", "", "()V", "stringBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "choosePathInOutput", "", "entryName", "extract", "", "aar", "Ljava/io/File;", "outputDir", "builder"})
public final class AarExtractor {
    @NotNull
    private final StringBuilder stringBuilder;

    /*
     * WARNING - void declaration
     */
    public AarExtractor() {
        void $this$stringBuilder_u24lambda_u2d0;
        StringBuilder stringBuilder = new StringBuilder(60);
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuilder stringBuilder2 = stringBuilder;
        AarExtractor aarExtractor = this;
        boolean bl4 = false;
        $this$stringBuilder_u24lambda_u2d0.append("jars");
        $this$stringBuilder_u24lambda_u2d0.append(File.separatorChar);
        Unit unit = Unit.INSTANCE;
        aarExtractor.stringBuilder = stringBuilder;
    }

    private final String choosePathInOutput(String entryName) {
        String string;
        this.stringBuilder.setLength(5);
        if (Intrinsics.areEqual((Object)entryName, (Object)"classes.jar") || Intrinsics.areEqual((Object)entryName, (Object)"lint.jar")) {
            this.stringBuilder.append(entryName);
            String string2 = this.stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n                stringBuilder.append(entryName)\n                stringBuilder.toString()\n            }");
            string = string2;
        } else if (StringsKt.startsWith$default((String)entryName, (String)"libs/", (boolean)false, (int)2, null)) {
            String string3 = entryName;
            int n12 = 5;
            boolean bl2 = false;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n12);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
            String pathWithinLibs = string5;
            if (Intrinsics.areEqual((Object)pathWithinLibs, (Object)"classes.jar")) {
                this.stringBuilder.append("libs/").append("classes-2.jar");
            } else if (Intrinsics.areEqual((Object)pathWithinLibs, (Object)"lint.jar")) {
                this.stringBuilder.append("libs/").append("lint-2.jar");
            } else {
                this.stringBuilder.append("libs/").append(pathWithinLibs);
            }
            String string6 = this.stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"{\n                // In case we have libs/classes.jar we are going to rename them, due an issue in\n                // Gradle.\n                // TODO: stop doing this once this is fixed in gradle. b/65298222\n                when (val pathWithinLibs = entryName.substring(LIBS_PREFIX_LENGTH)) {\n                    FN_CLASSES_JAR -> stringBuilder.append(LIBS_PREFIX).append(\"classes-2$DOT_JAR\")\n                    FN_LINT_JAR -> stringBuilder.append(LIBS_PREFIX).append(\"lint-2$DOT_JAR\")\n                    else -> stringBuilder.append(LIBS_PREFIX).append(pathWithinLibs)\n                }\n                stringBuilder.toString()\n            }");
            string = string6;
        } else {
            string = entryName;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void extract(@NotNull File aar, @NotNull File outputDir) {
        Intrinsics.checkNotNullParameter((Object)aar, (String)"aar");
        Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
        Object object = aar;
        int n12 = 0;
        object = new FileInputStream((File)object);
        n12 = 8192;
        boolean bl2 = false;
        object = new ZipInputStream(object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n12));
        n12 = 0;
        bl2 = false;
        Throwable throwable = null;
        try {
            Object object2;
            ZipInputStream zipInputStream = (ZipInputStream)object;
            boolean bl3 = false;
            while ((object2 = zipInputStream.getNextEntry()) != null) {
                Object entry = object2;
                if (((ZipEntry)entry).isDirectory() || !ZipEntryUtils.isValidZipEntryName((ZipEntry)entry)) continue;
                object2 = ((ZipEntry)entry).getName();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"entry.name");
                object2 = (CharSequence)object2;
                boolean bl4 = false;
                if (object2.length() == 0) continue;
                String string = ((ZipEntry)entry).getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entry.name");
                String path = FileUtils.toSystemDependentPath((String)this.choosePathInOutput(string));
                File outputFile = new File(outputDir, path);
                Files.createParentDirs((File)outputFile);
                Files.asByteSink((File)outputFile, (FileWriteMode[])new FileWriteMode[0]).writeFrom((InputStream)zipInputStream);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }
}

