/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.files;

import com.android.builder.files.ZipCentralDirectory;
import com.android.utils.FileUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.function.Function;
import org.apache.commons.codec.binary.Base64;

public class KeyedFileCache {
    private final File directory;
    private final Function<File, String> keyFunction;

    public KeyedFileCache(File directory, Function<File, String> keyFunction) {
        Preconditions.checkArgument((boolean)directory.isDirectory(), (String)"!File.isDirectory(): %s", (Object)directory);
        this.directory = directory;
        this.keyFunction = keyFunction;
    }

    public void add(File f12) throws IOException {
        Preconditions.checkArgument((boolean)f12.isFile(), (String)"!File.isFile(): %s", (Object)f12);
        if (!this.directory.isDirectory()) {
            FileUtils.mkdirs((File)this.directory);
        }
        String k12 = this.key(f12);
        Files.copy((File)f12, (File)new File(this.directory, k12));
    }

    public void add(ZipCentralDirectory centralDirectory) throws IOException {
        File file = centralDirectory.getFile();
        Preconditions.checkArgument((boolean)file.isFile(), (String)"!File.isFile(): %s", (Object)file);
        if (!this.directory.isDirectory()) {
            FileUtils.mkdirs((File)this.directory);
        }
        centralDirectory.writeTo(new File(this.directory, this.key(file)));
    }

    public File get(File f12) {
        File file = new File(this.directory, this.key(f12));
        if (file.isFile()) {
            return file;
        }
        return null;
    }

    public void remove(File f12) throws IOException {
        File toRemove = new File(this.directory, this.key(f12));
        if (toRemove.exists()) {
            FileUtils.delete((File)toRemove);
        }
    }

    private String key(File f12) {
        String key = this.keyFunction.apply(f12);
        if (key != null) {
            return key;
        }
        throw new IllegalStateException("No key found for file " + f12);
    }

    public static String fileNameKey(File f12) {
        String absolutePath = f12.getAbsolutePath();
        byte[] sha1Sum = Hashing.sha1().hashString((CharSequence)absolutePath, Charsets.UTF_8).asBytes();
        return new String(Base64.encodeBase64((byte[])sha1Sum), Charsets.US_ASCII).replaceAll("/", "_");
    }

    public void clear() throws IOException {
        File[] files = this.directory.listFiles();
        if (files == null) {
            return;
        }
        for (File f12 : files) {
            if (!f12.isFile()) continue;
            FileUtils.delete((File)f12);
        }
    }
}

