/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.files;

import com.android.builder.files.ZipCentralDirectory;
import com.android.utils.FileUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.function.Function;
import org.apache.commons.codec.binary.Base64;

public class KeyedFileCache {
    private final File directory;
    private final Function<File, String> keyFunction;

    public KeyedFileCache(File directory, Function<File, String> keyFunction) {
        Preconditions.checkArgument((boolean)directory.isDirectory(), (String)"!File.isDirectory(): %s", (Object)directory);
        this.directory = directory;
        this.keyFunction = keyFunction;
    }

    public void add(File f10) throws IOException {
        Preconditions.checkArgument((boolean)f10.isFile(), (String)"!File.isFile(): %s", (Object)f10);
        if (!this.directory.isDirectory()) {
            FileUtils.mkdirs((File)this.directory);
        }
        String k10 = this.key(f10);
        Files.copy((File)f10, (File)new File(this.directory, k10));
    }

    public void add(ZipCentralDirectory centralDirectory) throws IOException {
        File file = centralDirectory.getFile();
        Preconditions.checkArgument((boolean)file.isFile(), (String)"!File.isFile(): %s", (Object)file);
        if (!this.directory.isDirectory()) {
            FileUtils.mkdirs((File)this.directory);
        }
        centralDirectory.writeTo(new File(this.directory, this.key(file)));
    }

    public File get(File f10) {
        File file = new File(this.directory, this.key(f10));
        if (file.isFile()) {
            return file;
        }
        return null;
    }

    public void remove(File f10) throws IOException {
        File toRemove = new File(this.directory, this.key(f10));
        if (toRemove.exists()) {
            FileUtils.delete((File)toRemove);
        }
    }

    private String key(File f10) {
        String key = this.keyFunction.apply(f10);
        if (key != null) {
            return key;
        }
        throw new IllegalStateException("No key found for file " + f10);
    }

    public static String fileNameKey(File f10) {
        String absolutePath = f10.getAbsolutePath();
        byte[] sha1Sum = Hashing.sha1().hashString((CharSequence)absolutePath, Charsets.UTF_8).asBytes();
        return new String(Base64.encodeBase64((byte[])sha1Sum), Charsets.US_ASCII).replaceAll("/", "_");
    }

    public void clear() throws IOException {
        File[] files = this.directory.listFiles();
        if (files == null) {
            return;
        }
        for (File f10 : files) {
            if (!f10.isFile()) continue;
            FileUtils.delete((File)f10);
        }
    }
}

