/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dexing;

import com.android.builder.dexing.D8DiagnosticsHandler;
import com.android.builder.dexing.DexArchiveEntry;
import com.android.builder.dexing.DexArchiveMerger;
import com.android.builder.dexing.DexArchiveMergerException;
import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.MessageReceiver;
import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.CompilationMode;
import com.android.tools.r8.D8;
import com.android.tools.r8.D8Command;
import com.android.tools.r8.Diagnostic;
import com.android.tools.r8.OutputMode;
import com.android.tools.r8.errors.DuplicateTypesDiagnostic;
import com.android.tools.r8.origin.Origin;
import com.google.common.util.concurrent.MoreExecutors;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

final class D8DexArchiveMerger
implements DexArchiveMerger {
    private static final Logger LOGGER = Logger.getLogger(D8DexArchiveMerger.class.getName());
    private static final String ERROR_MULTIDEX = "Cannot fit requested classes in a single dex file";
    private final int minSdkVersion;
    private final CompilationMode compilationMode;
    private final MessageReceiver messageReceiver;
    private final ForkJoinPool forkJoinPool;
    private volatile boolean hintForMultidex = false;
    private static final String DEX_LIMIT_EXCEEDED_ERROR = "The number of method references in a .dex file cannot exceed 64K.\nLearn how to resolve this issue at https://developer.android.com/tools/building/multidex.html";

    public D8DexArchiveMerger(@Nonnull MessageReceiver messageReceiver, int minSdkVersion, CompilationMode compilationMode, ForkJoinPool forkJoinPool) {
        this.minSdkVersion = minSdkVersion;
        this.compilationMode = compilationMode;
        this.messageReceiver = messageReceiver;
        this.forkJoinPool = forkJoinPool;
    }

    @Override
    public void mergeDexArchives(List<DexArchiveEntry> dexArchiveEntries, List<Path> globalSynthetics, Path outputDir, List<Path> mainDexRulesFiles, List<String> mainDexRules, Path userMultidexKeepFile, Collection<Path> libraryFiles, Path mainDexListOutput) throws DexArchiveMergerException {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, "Merging to '" + outputDir.toAbsolutePath().toString() + "' with D8 from all or a subset of dex files in " + dexArchiveEntries.stream().map(path -> path.getDexArchive().getRootPath().toAbsolutePath().toString()).collect(Collectors.joining(", ")) + ", and from all global synthetics files in " + globalSynthetics.stream().map(Path::toString).collect(Collectors.joining(", ")));
        }
        if (dexArchiveEntries.isEmpty() && globalSynthetics.isEmpty()) {
            return;
        }
        InterceptingDiagnosticsHandler d8DiagnosticsHandler = new InterceptingDiagnosticsHandler();
        D8Command.Builder builder = D8Command.builder(d8DiagnosticsHandler);
        builder.setDisableDesugaring(true);
        builder.setIncludeClassesChecksum(this.compilationMode == CompilationMode.DEBUG);
        for (DexArchiveEntry dexArchiveEntry : dexArchiveEntries) {
            builder.addDexProgramData(dexArchiveEntry.getDexFileContent(), D8DiagnosticsHandler.getOrigin(dexArchiveEntry));
        }
        builder.addGlobalSyntheticsFiles(globalSynthetics);
        try {
            if (mainDexRules != null) {
                builder.addMainDexRules(mainDexRules, Origin.unknown());
            }
            if (mainDexRulesFiles != null) {
                builder.addMainDexRulesFiles(mainDexRulesFiles);
            }
            if (userMultidexKeepFile != null) {
                builder.addMainDexListFiles(userMultidexKeepFile);
            }
            if (libraryFiles != null) {
                builder.addLibraryFiles(libraryFiles);
            }
            if (mainDexListOutput != null) {
                builder.setMainDexListOutputPath(mainDexListOutput);
            }
            ((D8Command.Builder)((D8Command.Builder)((D8Command.Builder)((D8Command.Builder)builder.setMinApiLevel(this.minSdkVersion)).setMode(this.compilationMode)).setOutput(outputDir, OutputMode.DexIndexed)).setDisableDesugaring(true)).setIntermediate(false);
            Object executorService = this.forkJoinPool != null ? this.forkJoinPool : MoreExecutors.newDirectExecutorService();
            D8.run((D8Command)builder.build(), (ExecutorService)executorService);
        }
        catch (CompilationFailedException e10) {
            throw this.getMergingExceptionToRethrow(e10, d8DiagnosticsHandler);
        }
    }

    private DexArchiveMergerException getMergingExceptionToRethrow(CompilationFailedException t10, D8DiagnosticsHandler d8DiagnosticsHandler) {
        StringBuilder msg = new StringBuilder("Error while merging dex archives: ");
        for (String hint : d8DiagnosticsHandler.getPendingHints()) {
            msg.append(System.lineSeparator());
            msg.append(hint);
        }
        return new DexArchiveMergerException(msg.toString(), t10);
    }

    private class InterceptingDiagnosticsHandler
    extends D8DiagnosticsHandler {
        public InterceptingDiagnosticsHandler() {
            super(D8DexArchiveMerger.this.messageReceiver);
        }

        @Override
        protected Message convertToMessage(Message.Kind kind, Diagnostic diagnostic) {
            if (diagnostic.getDiagnosticMessage().startsWith(D8DexArchiveMerger.ERROR_MULTIDEX)) {
                this.addHint(D8DexArchiveMerger.DEX_LIMIT_EXCEEDED_ERROR);
            }
            if (diagnostic instanceof DuplicateTypesDiagnostic) {
                this.addHint(diagnostic.getDiagnosticMessage());
                this.addHint("Learn how to resolve the issue at https://developer.android.com/studio/build/dependencies#duplicate_classes.");
            }
            return super.convertToMessage(kind, diagnostic);
        }
    }
}

