/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.aapt.v2;

import com.android.builder.internal.aapt.AaptConvertConfig;
import com.android.builder.internal.aapt.AaptPackageConfig;
import com.android.builder.internal.aapt.v2.Aapt2;
import com.android.builder.internal.aapt.v2.Aapt2Daemon;
import com.android.builder.internal.aapt.v2.Aapt2Exception;
import com.android.ide.common.resources.CompileResourceRequest;
import com.android.utils.ILogger;
import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001:\u0005)*+,-BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u001cJ\b\u0010\u001e\u001a\u00020\u0018H\u0003J\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u0018H\u0002J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00180\"H\u0002J\u0006\u0010'\u001a\u00020(R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0015\u001a\u00020\u00068\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00178\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010#\u001a\u00020$\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u0006."}, d2={"Lcom/android/builder/internal/aapt/v2/Aapt2DaemonManager;", "", "logger", "Lcom/android/utils/ILogger;", "daemonFactory", "Lkotlin/Function1;", "", "Lcom/android/builder/internal/aapt/v2/Aapt2Daemon;", "expiryTime", "", "expiryTimeUnit", "Ljava/util/concurrent/TimeUnit;", "listener", "Lcom/android/builder/internal/aapt/v2/Aapt2DaemonManager$Listener;", "timeSource", "Lcom/google/common/base/Ticker;", "<init>", "(Lcom/android/utils/ILogger;Lkotlin/jvm/functions/Function1;JLjava/util/concurrent/TimeUnit;Lcom/android/builder/internal/aapt/v2/Aapt2DaemonManager$Listener;Lcom/google/common/base/Ticker;)V", "getLogger", "()Lcom/android/utils/ILogger;", "expiryTimeNanoSeconds", "latestDisplayId", "pool", "", "Lcom/android/builder/internal/aapt/v2/Aapt2DaemonManager$LeasableAaptDaemon;", "leaseDaemon", "Lcom/android/builder/internal/aapt/v2/Aapt2DaemonManager$LeasedAaptDaemon;", "maintain", "", "shutdown", "newAaptDaemon", "returnProcess", "key", "takeExpiredDaemonsFromPool", "", "leasingAapt2Daemon", "Lcom/android/builder/internal/aapt/v2/Aapt2;", "getLeasingAapt2Daemon", "()Lcom/android/builder/internal/aapt/v2/Aapt2;", "stats", "Lcom/android/builder/internal/aapt/v2/Aapt2DaemonManager$Stats;", "LeasableAaptDaemon", "LeasedAaptDaemon", "Listener", "NoOpListener", "Stats", "builder"})
@ThreadSafe
@SourceDebugExtension(value={"SMAP\nAapt2DaemonManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Aapt2DaemonManager.kt\ncom/android/builder/internal/aapt/v2/Aapt2DaemonManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,234:1\n1#2:235\n1863#3,2:236\n1755#3,3:238\n1863#3,2:241\n1782#3,4:243\n*S KotlinDebug\n*F\n+ 1 Aapt2DaemonManager.kt\ncom/android/builder/internal/aapt/v2/Aapt2DaemonManager\n*L\n89#1:236,2\n95#1:238,3\n101#1:241,2\n228#1:243,4\n*E\n"})
public final class Aapt2DaemonManager {
    @NotNull
    private final ILogger logger;
    @NotNull
    private final Function1<Integer, Aapt2Daemon> daemonFactory;
    @NotNull
    private final Listener listener;
    @NotNull
    private final Ticker timeSource;
    private final long expiryTimeNanoSeconds;
    @GuardedBy(value="this")
    private int latestDisplayId;
    @GuardedBy(value="this")
    @NotNull
    private final List<LeasableAaptDaemon> pool;
    @NotNull
    private final Aapt2 leasingAapt2Daemon;

    public Aapt2DaemonManager(@NotNull ILogger logger, @NotNull Function1<? super Integer, ? extends Aapt2Daemon> daemonFactory, long expiryTime, @NotNull TimeUnit expiryTimeUnit, @NotNull Listener listener, @NotNull Ticker timeSource) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter(daemonFactory, (String)"daemonFactory");
        Intrinsics.checkNotNullParameter((Object)((Object)expiryTimeUnit), (String)"expiryTimeUnit");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)timeSource, (String)"timeSource");
        this.logger = logger;
        this.daemonFactory = daemonFactory;
        this.listener = listener;
        this.timeSource = timeSource;
        this.expiryTimeNanoSeconds = expiryTimeUnit.toNanos(expiryTime);
        this.pool = new ArrayList();
        this.leasingAapt2Daemon = new Aapt2(this){
            final /* synthetic */ Aapt2DaemonManager this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void compile(CompileResourceRequest request, ILogger logger) {
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
                Closeable closeable = this.this$0.leaseDaemon();
                Throwable throwable = null;
                try {
                    LeasedAaptDaemon it = (LeasedAaptDaemon)closeable;
                    boolean bl2 = false;
                    it.compile(request, logger);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void link(AaptPackageConfig request, ILogger logger) {
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
                Closeable closeable = this.this$0.leaseDaemon();
                Throwable throwable = null;
                try {
                    LeasedAaptDaemon it = (LeasedAaptDaemon)closeable;
                    boolean bl2 = false;
                    it.link(request, logger);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void convert(AaptConvertConfig request, ILogger logger) {
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
                Closeable closeable = this.this$0.leaseDaemon();
                Throwable throwable = null;
                try {
                    LeasedAaptDaemon it = (LeasedAaptDaemon)closeable;
                    boolean bl2 = false;
                    it.convert(request, logger);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
        };
    }

    public /* synthetic */ Aapt2DaemonManager(ILogger iLogger, Function1 function1, long l11, TimeUnit timeUnit, Listener listener, Ticker ticker, int n11, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n11 & 0x10) != 0) {
            listener = new NoOpListener();
        }
        if ((n11 & 0x20) != 0) {
            ticker = Ticker.systemTicker();
        }
        this(iLogger, (Function1<? super Integer, ? extends Aapt2Daemon>)function1, l11, timeUnit, listener, ticker);
    }

    @NotNull
    public final ILogger getLogger() {
        return this.logger;
    }

    @NotNull
    public final synchronized LeasedAaptDaemon leaseDaemon() {
        LeasableAaptDaemon leasableAaptDaemon;
        Object v02;
        block2: {
            Iterable iterable = this.pool;
            for (Object t11 : iterable) {
                LeasableAaptDaemon it = (LeasableAaptDaemon)t11;
                boolean bl2 = false;
                if (!(!it.getBusy())) continue;
                v02 = t11;
                break block2;
            }
            v02 = null;
        }
        if ((leasableAaptDaemon = (LeasableAaptDaemon)v02) == null) {
            leasableAaptDaemon = this.newAaptDaemon();
        }
        LeasableAaptDaemon daemon = leasableAaptDaemon;
        daemon.setBusy(true);
        return new LeasedAaptDaemon(daemon, (Function1<? super LeasableAaptDaemon, Unit>)((Function1)new Function1<LeasableAaptDaemon, Unit>((Object)this){

            public final void invoke(LeasableAaptDaemon p02) {
                Intrinsics.checkNotNullParameter((Object)p02, (String)"p0");
                Aapt2DaemonManager.access$returnProcess((Aapt2DaemonManager)this.receiver, p02);
            }
        }));
    }

    public final void maintain() {
        List<LeasableAaptDaemon> expiredDaemons = this.takeExpiredDaemonsFromPool();
        Iterable $this$forEach$iv = expiredDaemons;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LeasableAaptDaemon it = (LeasableAaptDaemon)element$iv;
            boolean bl2 = false;
            it.shutdown();
        }
    }

    public final synchronized void shutdown() {
        LeasableAaptDaemon it;
        boolean bl2;
        block6: {
            Iterable $this$any$iv = this.pool;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl2 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (LeasableAaptDaemon)element$iv;
                    boolean bl3 = false;
                    if (!it.getBusy()) continue;
                    bl2 = true;
                    break block6;
                }
                bl2 = false;
            }
        }
        if (bl2) {
            throw new IllegalStateException("AAPT Process manager cannot be shut down while daemons are in use".toString());
        }
        if (!this.pool.isEmpty()) {
            this.listener.lastDaemonStopped();
        }
        Iterable $this$forEach$iv = this.pool;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (LeasableAaptDaemon)element$iv;
            boolean bl4 = false;
            it.shutdown();
        }
        this.pool.clear();
    }

    @GuardedBy(value="this")
    private final LeasableAaptDaemon newAaptDaemon() {
        int n11 = this.latestDisplayId;
        this.latestDisplayId = n11 + 1;
        int displayId = n11;
        Aapt2Daemon process = (Aapt2Daemon)this.daemonFactory.invoke((Object)displayId);
        LeasableAaptDaemon daemon = new LeasableAaptDaemon(process, this.timeSource.read(), false, 4, null);
        if (this.pool.isEmpty()) {
            this.listener.firstDaemonStarted(this);
        }
        this.pool.add(daemon);
        return daemon;
    }

    private final synchronized void returnProcess(LeasableAaptDaemon key) {
        if (key.getDaemon().getState() != Aapt2Daemon.State.RUNNING) {
            this.pool.remove(key);
            if (this.pool.isEmpty()) {
                this.listener.lastDaemonStopped();
            }
            return;
        }
        key.setLastUsedNanoSeconds(this.timeSource.read());
        key.setBusy(false);
    }

    private final synchronized List<LeasableAaptDaemon> takeExpiredDaemonsFromPool() {
        List expired = new ArrayList();
        long expireHorizon = this.timeSource.read() - this.expiryTimeNanoSeconds;
        ArrayList oldPool = new ArrayList(this.pool);
        this.pool.clear();
        Iterator iterator = oldPool.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            boolean bl2;
            LeasableAaptDaemon daemon = (LeasableAaptDaemon)iterator2.next();
            if (daemon.getBusy() || daemon.getLastUsedNanoSeconds() >= expireHorizon) {
                Intrinsics.checkNotNull((Object)daemon);
                bl2 = this.pool.add(daemon);
                continue;
            }
            Intrinsics.checkNotNull((Object)daemon);
            bl2 = expired.add(daemon);
        }
        if (this.pool.isEmpty()) {
            this.listener.lastDaemonStopped();
        }
        return expired;
    }

    @NotNull
    public final Aapt2 getLeasingAapt2Daemon() {
        return this.leasingAapt2Daemon;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final synchronized Stats stats() {
        int n11;
        int n12;
        void $this$count$iv;
        Iterable iterable = this.pool;
        int n13 = this.pool.size();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n12 = 0;
        } else {
            void var3_4;
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                LeasableAaptDaemon it = (LeasableAaptDaemon)element$iv;
                boolean bl2 = false;
                if (!it.getBusy() || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n12 = var3_4;
        }
        int n14 = n11 = n12;
        int n15 = n13;
        return new Stats(n15, n14);
    }

    public static final /* synthetic */ void access$returnProcess(Aapt2DaemonManager $this, LeasableAaptDaemon key) {
        $this.returnProcess(key);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0014\u001a\u00020\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lcom/android/builder/internal/aapt/v2/Aapt2DaemonManager$LeasableAaptDaemon;", "", "daemon", "Lcom/android/builder/internal/aapt/v2/Aapt2Daemon;", "lastUsedNanoSeconds", "", "busy", "", "<init>", "(Lcom/android/builder/internal/aapt/v2/Aapt2Daemon;JZ)V", "getDaemon", "()Lcom/android/builder/internal/aapt/v2/Aapt2Daemon;", "getLastUsedNanoSeconds", "()J", "setLastUsedNanoSeconds", "(J)V", "getBusy", "()Z", "setBusy", "(Z)V", "shutdown", "", "builder"})
    public static final class LeasableAaptDaemon {
        @NotNull
        private final Aapt2Daemon daemon;
        private long lastUsedNanoSeconds;
        private boolean busy;

        public LeasableAaptDaemon(@NotNull Aapt2Daemon daemon, long lastUsedNanoSeconds, boolean busy) {
            Intrinsics.checkNotNullParameter((Object)daemon, (String)"daemon");
            this.daemon = daemon;
            this.lastUsedNanoSeconds = lastUsedNanoSeconds;
            this.busy = busy;
        }

        public /* synthetic */ LeasableAaptDaemon(Aapt2Daemon aapt2Daemon, long l11, boolean bl2, int n11, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n11 & 4) != 0) {
                bl2 = false;
            }
            this(aapt2Daemon, l11, bl2);
        }

        @NotNull
        public final Aapt2Daemon getDaemon() {
            return this.daemon;
        }

        public final long getLastUsedNanoSeconds() {
            return this.lastUsedNanoSeconds;
        }

        public final void setLastUsedNanoSeconds(long l11) {
            this.lastUsedNanoSeconds = l11;
        }

        public final boolean getBusy() {
            return this.busy;
        }

        public final void setBusy(boolean bl2) {
            this.busy = bl2;
        }

        public final void shutdown() {
            this.daemon.shutDown();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B%\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0013\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0015\u001a\u00020\u0007H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/builder/internal/aapt/v2/Aapt2DaemonManager$LeasedAaptDaemon;", "Lcom/android/builder/internal/aapt/v2/Aapt2;", "Ljava/io/Closeable;", "leasableDaemon", "Lcom/android/builder/internal/aapt/v2/Aapt2DaemonManager$LeasableAaptDaemon;", "closeAction", "Lkotlin/Function1;", "", "<init>", "(Lcom/android/builder/internal/aapt/v2/Aapt2DaemonManager$LeasableAaptDaemon;Lkotlin/jvm/functions/Function1;)V", "leaseValid", "", "compile", "request", "Lcom/android/ide/common/resources/CompileResourceRequest;", "logger", "Lcom/android/utils/ILogger;", "link", "Lcom/android/builder/internal/aapt/AaptPackageConfig;", "convert", "Lcom/android/builder/internal/aapt/AaptConvertConfig;", "close", "builder"})
    @NotThreadSafe
    public static final class LeasedAaptDaemon
    implements Aapt2,
    Closeable {
        @NotNull
        private final LeasableAaptDaemon leasableDaemon;
        @NotNull
        private final Function1<LeasableAaptDaemon, Unit> closeAction;
        private boolean leaseValid;

        public LeasedAaptDaemon(@NotNull LeasableAaptDaemon leasableDaemon, @NotNull Function1<? super LeasableAaptDaemon, Unit> closeAction) {
            Intrinsics.checkNotNullParameter((Object)leasableDaemon, (String)"leasableDaemon");
            Intrinsics.checkNotNullParameter(closeAction, (String)"closeAction");
            this.leasableDaemon = leasableDaemon;
            this.closeAction = closeAction;
            this.leaseValid = true;
        }

        @Override
        public void compile(@NotNull CompileResourceRequest request, @NotNull ILogger logger) throws Aapt2Exception {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            Preconditions.checkState((boolean)this.leaseValid, (String)"Leased process is already closed", (Object[])new Object[0]);
            this.leasableDaemon.getDaemon().compile(request, logger);
        }

        @Override
        public void link(@NotNull AaptPackageConfig request, @NotNull ILogger logger) throws Aapt2Exception {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            Preconditions.checkState((boolean)this.leaseValid, (String)"Leased process is already closed", (Object[])new Object[0]);
            this.leasableDaemon.getDaemon().link(request, logger);
        }

        @Override
        public void convert(@NotNull AaptConvertConfig request, @NotNull ILogger logger) throws Aapt2Exception {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            Preconditions.checkState((boolean)this.leaseValid, (String)"Leased process is already closed", (Object[])new Object[0]);
            this.leasableDaemon.getDaemon().convert(request, logger);
        }

        @Override
        public void close() {
            Preconditions.checkState((boolean)this.leaseValid, (String)"Leased process is already closed", (Object[])new Object[0]);
            this.closeAction.invoke((Object)this.leasableDaemon);
            this.leaseValid = false;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\b\u0010\u0006\u001a\u00020\u0003H&\u00a8\u0006\u0007\u00c0\u0006\u0003"}, d2={"Lcom/android/builder/internal/aapt/v2/Aapt2DaemonManager$Listener;", "", "firstDaemonStarted", "", "manager", "Lcom/android/builder/internal/aapt/v2/Aapt2DaemonManager;", "lastDaemonStopped", "builder"})
    public static interface Listener {
        public void firstDaemonStarted(@NotNull Aapt2DaemonManager var1);

        public void lastDaemonStopped();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0005H\u0016\u00a8\u0006\t"}, d2={"Lcom/android/builder/internal/aapt/v2/Aapt2DaemonManager$NoOpListener;", "Lcom/android/builder/internal/aapt/v2/Aapt2DaemonManager$Listener;", "<init>", "()V", "firstDaemonStarted", "", "manager", "Lcom/android/builder/internal/aapt/v2/Aapt2DaemonManager;", "lastDaemonStopped", "builder"})
    public static final class NoOpListener
    implements Listener {
        @Override
        public void firstDaemonStarted(@NotNull Aapt2DaemonManager manager) {
            Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        }

        @Override
        public void lastDaemonStopped() {
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/android/builder/internal/aapt/v2/Aapt2DaemonManager$Stats;", "", "poolSize", "", "busyCount", "<init>", "(II)V", "getPoolSize", "()I", "getBusyCount", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "builder"})
    public static final class Stats {
        private final int poolSize;
        private final int busyCount;

        public Stats(int poolSize, int busyCount) {
            this.poolSize = poolSize;
            this.busyCount = busyCount;
        }

        public final int getPoolSize() {
            return this.poolSize;
        }

        public final int getBusyCount() {
            return this.busyCount;
        }

        public final int component1() {
            return this.poolSize;
        }

        public final int component2() {
            return this.busyCount;
        }

        @NotNull
        public final Stats copy(int poolSize, int busyCount) {
            return new Stats(poolSize, busyCount);
        }

        public static /* synthetic */ Stats copy$default(Stats stats, int n11, int n12, int n13, Object object) {
            if ((n13 & 1) != 0) {
                n11 = stats.poolSize;
            }
            if ((n13 & 2) != 0) {
                n12 = stats.busyCount;
            }
            return stats.copy(n11, n12);
        }

        @NotNull
        public String toString() {
            return "Stats(poolSize=" + this.poolSize + ", busyCount=" + this.busyCount + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.poolSize);
            result = result * 31 + Integer.hashCode(this.busyCount);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Stats)) {
                return false;
            }
            Stats stats = (Stats)other;
            if (this.poolSize != stats.poolSize) {
                return false;
            }
            return this.busyCount == stats.busyCount;
        }
    }
}

