/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.assistant.runtime;

import com.android.tools.r8.assistant.runtime.ReflectiveOperationReceiver;
import com.android.tools.r8.keepanno.annotations.KeepForApi;
import java.util.Arrays;

@KeepForApi
public class ReflectiveOracle {
    private static Object instanceLock = new Object();
    private static volatile ReflectiveOperationReceiver INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ReflectiveOperationReceiver getInstance() {
        if (INSTANCE == null) {
            Object object = instanceLock;
            synchronized (object) {
                if (INSTANCE == null) {
                    INSTANCE = ReflectiveOracle.getReceiver();
                }
            }
        }
        return INSTANCE;
    }

    private static ReflectiveOperationReceiver getReceiver() {
        return new ReflectiveOperationLogger();
    }

    public static void onClassNewInstance(Class<?> clazz) {
        ReflectiveOracle.getInstance().onClassNewInstance(Stack.createStack(), clazz);
    }

    public static void onClassGetDeclaredMethod(Class<?> clazz, String name, Class<?> ... parameters) {
        ReflectiveOracle.getInstance().onClassGetDeclaredMethod(Stack.createStack(), clazz, name, parameters);
    }

    public static void onClassGetDeclaredMethods(Class<?> clazz) {
        ReflectiveOracle.getInstance().onClassGetDeclaredMethods(Stack.createStack(), clazz);
    }

    public static void onClassForName(String className) {
        ReflectiveOracle.getInstance().onClassForName(Stack.createStack(), className);
    }

    public static void onClassGetDeclaredField(Class<?> clazz, String fieldName) {
        ReflectiveOracle.getInstance().onClassGetDeclaredField(Stack.createStack(), clazz, fieldName);
    }

    public static void onClassGetName(Class<?> clazz) {
        ReflectiveOracle.getInstance().onClassGetName(Stack.createStack(), clazz, ReflectiveOperationReceiver.NameLookupType.NAME);
    }

    public static void onClassGetSimpleName(Class<?> clazz) {
        ReflectiveOracle.getInstance().onClassGetName(Stack.createStack(), clazz, ReflectiveOperationReceiver.NameLookupType.SIMPLE_NAME);
    }

    public static void onClassGetCanonicalName(Class<?> clazz) {
        ReflectiveOracle.getInstance().onClassGetName(Stack.createStack(), clazz, ReflectiveOperationReceiver.NameLookupType.CANONICAL_NAME);
    }

    public static void onClassGetTypeName(Class<?> clazz) {
        ReflectiveOracle.getInstance().onClassGetName(Stack.createStack(), clazz, ReflectiveOperationReceiver.NameLookupType.TYPE_NAME);
    }

    @KeepForApi
    public static class ReflectiveOperationLogger
    implements ReflectiveOperationReceiver {
        @Override
        public void onClassNewInstance(Stack stack, Class<?> clazz) {
            System.out.println("Reflectively created new instance of " + clazz.getName());
        }

        @Override
        public void onClassGetDeclaredMethod(Stack stack, Class<?> clazz, String method, Class<?> ... parameters) {
            System.out.println("Reflectively got declared method " + method + " on " + clazz.getName());
        }

        @Override
        public void onClassGetDeclaredField(Stack stack, Class<?> clazz, String fieldName) {
            System.out.println("Reflectively got declared field " + fieldName + " on " + clazz.getName());
        }

        @Override
        public void onClassGetDeclaredMethods(Stack stack, Class<?> clazz) {
            System.out.println("Reflectively got declared methods on " + clazz.getName());
        }

        @Override
        public void onClassGetName(Stack stack, Class<?> clazz, ReflectiveOperationReceiver.NameLookupType lookupType) {
            System.out.println("Reflectively got name on " + clazz.getName() + "(" + lookupType.toString() + ")");
        }

        @Override
        public void onClassForName(Stack stack, String className) {
            System.out.println("Reflectively called Class.forName on " + className);
        }

        @Override
        public boolean requiresStackInformation() {
            return true;
        }
    }

    @KeepForApi
    public static class Stack {
        private final StackTraceElement[] stackTraceElements;

        private Stack(StackTraceElement[] stackTraceElements) {
            this.stackTraceElements = stackTraceElements;
        }

        static Stack createStack() {
            assert (INSTANCE != null);
            if (INSTANCE.requiresStackInformation()) {
                StackTraceElement[] stackTrace = new RuntimeException().getStackTrace();
                return new Stack(Arrays.copyOfRange(stackTrace, 2, stackTrace.length));
            }
            return new Stack(null);
        }

        public StackTraceElement[] getStackTraceElements() {
            return this.stackTraceElements;
        }

        public String toStringStackTrace() {
            if (this.stackTraceElements == null) {
                return "Stack extraction not enabled.";
            }
            StringBuilder sb2 = new StringBuilder();
            for (StackTraceElement element : this.stackTraceElements) {
                sb2.append(" at ").append(element).append("\n");
            }
            return sb2.toString();
        }
    }
}

