/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.files;

import com.android.builder.files.RelativeFile;
import com.android.builder.files.RelativeFiles;
import com.android.builder.files.ZipEntry;
import com.android.builder.files.ZipEntryList;
import com.android.builder.files.ZipSnapshot;
import com.android.builder.files.ZipSnapshotRepository;
import com.android.ide.common.resources.FileStatus;
import com.android.tools.build.apkzlib.utils.IOExceptionRunnable;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.io.Closer;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class IncrementalRelativeFileSets {
    private IncrementalRelativeFileSets() {
    }

    @Deprecated
    public static ImmutableMap<RelativeFile, FileStatus> fromDirectory(File directory) {
        Preconditions.checkArgument((boolean)directory.isDirectory(), (Object)"!directory.isDirectory()");
        return ImmutableMap.copyOf((Map)Maps.asMap(RelativeFiles.fromDirectory(directory), (Function)Functions.constant((Object)FileStatus.NEW)));
    }

    public static ImmutableMap<RelativeFile, FileStatus> fromZipSnapshot(File zip, FileStatus status) throws IOException {
        Preconditions.checkArgument((boolean)zip.isFile(), (String)"!zip.isFile(): %s", (Object)zip);
        return ImmutableMap.builder().putAll(Maps.asMap(RelativeFiles.fromZip(zip), f11 -> status)).build();
    }

    public static ImmutableMap<RelativeFile, FileStatus> fromZipSnapshot(ZipSnapshot snapshot, FileStatus status) throws IOException {
        return ImmutableMap.builder().putAll(Maps.asMap(RelativeFiles.fromZipSnapshot(snapshot), f11 -> status)).build();
    }

    public static Map<RelativeFile, FileStatus> fromZip(File zip, ZipSnapshotRepository zipSnapshotRepository, Set<Runnable> cacheUpdates) throws IOException {
        ZipSnapshot snapshot = zipSnapshotRepository.getLastSnapshotOfZip(zip);
        if (snapshot == null) {
            if (!zip.isFile()) {
                return ImmutableMap.of();
            }
            cacheUpdates.add(IOExceptionRunnable.asRunnable(() -> zipSnapshotRepository.takeSnapshotOfZip(zip)));
            return IncrementalRelativeFileSets.fromZipSnapshot(zip, FileStatus.NEW);
        }
        if (!zip.isFile()) {
            ZipEntryList entryList = snapshot.getEntryList();
            HashMap map = Maps.newHashMapWithExpectedSize((int)entryList.getEntries().size());
            for (ZipEntry entry : entryList.getEntries().values()) {
                map.put(new RelativeFile(zip, entry.getName()), FileStatus.REMOVED);
            }
            cacheUpdates.add(IOExceptionRunnable.asRunnable(() -> zipSnapshotRepository.removeSnapshotOfZip(zip)));
            return Collections.unmodifiableMap(map);
        }
        HashMap result = Maps.newHashMap();
        try (Closer closer = Closer.create();){
            String path;
            ZipEntryList newEntries = ZipEntryList.Companion.fromZip(zip);
            ZipEntryList oldEntries = snapshot.getEntryList();
            for (ZipEntry entry : newEntries.getEntries().values()) {
                path = entry.getName();
                RelativeFile newRelative = new RelativeFile(zip, path);
                ZipEntry oldEntry = oldEntries.getEntries().get(path);
                if (oldEntry == null) {
                    result.put(newRelative, FileStatus.NEW);
                    continue;
                }
                if (oldEntry.getCrc() == entry.getCrc() && oldEntry.getSize() == entry.getSize()) continue;
                result.put(newRelative, FileStatus.CHANGED);
            }
            for (ZipEntry entry : oldEntries.getEntries().values()) {
                path = entry.getName();
                RelativeFile oldRelative = new RelativeFile(zip, path);
                ZipEntry newEntry = newEntries.getEntries().get(path);
                if (newEntry != null) continue;
                result.put(oldRelative, FileStatus.REMOVED);
            }
        }
        cacheUpdates.add(IOExceptionRunnable.asRunnable(() -> zipSnapshotRepository.takeSnapshotOfZip(zip)));
        return Collections.unmodifiableMap(result);
    }
}

