/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dexing;

import com.android.builder.dexing.ClassFileEntry;
import com.android.utils.FileUtils;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Locale;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Stream;

public interface ClassFileInput
extends Closeable {
    public static final Predicate<String> CLASS_MATCHER = s15 -> {
        String lowerCase = FileUtils.toSystemIndependentPath((String)s15.toLowerCase(Locale.US));
        if (!lowerCase.endsWith(".class")) {
            return false;
        }
        if (lowerCase.equals("module-info.class") || lowerCase.endsWith("/module-info.class")) {
            return false;
        }
        return !lowerCase.startsWith("/meta-inf/") && !lowerCase.startsWith("meta-inf/");
    };

    public Stream<ClassFileEntry> entries(BiPredicate<Path, String> var1) throws IOException;

    public Path getPath();
}

