/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.files;

import com.android.builder.files.RelativeFile;
import com.android.builder.files.ZipEntry;
import com.android.builder.files.ZipSnapshot;
import com.android.zipflinger.Entry;
import com.android.zipflinger.ZipMap;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class RelativeFiles {
    private RelativeFiles() {
    }

    public static Set<RelativeFile> fromDirectory(File directory) {
        return Collections.unmodifiableSet(RelativeFiles.fromDirectory(directory, directory));
    }

    public static Set<RelativeFile> fromDirectory(File directory, Predicate<RelativeFile> filter) {
        return Collections.unmodifiableSet(Sets.filter(RelativeFiles.fromDirectory(directory, directory), filter::test));
    }

    private static Set<RelativeFile> fromDirectory(File base, File directory) {
        File[] directoryFiles;
        Preconditions.checkArgument((boolean)base.isDirectory(), (String)"!File.isDirectory(): %s", (Object)base);
        Preconditions.checkArgument((boolean)directory.isDirectory(), (String)"!File.isDirectory(): %s", (Object)directory);
        HashSet files = Sets.newHashSet();
        for (File file : directoryFiles = (File[])Verify.verifyNotNull((Object)directory.listFiles(), (String)"directory.listFiles() == null", (Object[])new Object[0])) {
            if (file.isDirectory()) {
                files.addAll(RelativeFiles.fromDirectory(base, file));
                continue;
            }
            files.add(new RelativeFile(base, file));
        }
        return files;
    }

    public static Predicate<RelativeFile> fromPathPredicate(Predicate<String> predicate) {
        return rf5 -> predicate.test(rf5.getRelativePath());
    }

    public static Set<RelativeFile> fromZip(File zip) throws IOException {
        Collection values = ZipMap.from((Path)zip.toPath()).getEntries().values().stream().filter(item -> !item.isDirectory()).collect(Collectors.toList());
        HashSet files = Sets.newHashSetWithExpectedSize((int)values.size());
        for (Entry entry : values) {
            files.add(new RelativeFile(zip, entry.getName()));
        }
        return Collections.unmodifiableSet(files);
    }

    public static Set<RelativeFile> fromZipSnapshot(ZipSnapshot snapshot) throws IOException {
        Map<String, ZipEntry> entries = snapshot.getEntryList().getEntries();
        HashSet files = Sets.newHashSetWithExpectedSize((int)entries.size());
        for (Map.Entry<String, ZipEntry> e15 : entries.entrySet()) {
            files.add(new RelativeFile(new File(snapshot.getOriginalPath()), e15.getValue().getName()));
        }
        return Collections.unmodifiableSet(files);
    }
}

