/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.files;

import com.android.builder.files.ZipEntry;
import com.android.builder.files.ZipEntryListAdapter;
import com.android.zipflinger.Entry;
import com.android.zipflinger.ZipMap;
import java.io.File;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\n\u001a\u00020\u000bJ\u0015\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0004H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/android/builder/files/ZipEntryList;", "", "entries", "", "", "Lcom/android/builder/files/ZipEntry;", "<init>", "(Ljava/util/Map;)V", "getEntries", "()Ljava/util/Map;", "toByteArray", "", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "builder"})
public final class ZipEntryList {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, ZipEntry> entries;

    public ZipEntryList(@NotNull Map<String, ZipEntry> entries) {
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        this.entries = entries;
    }

    @NotNull
    public final Map<String, ZipEntry> getEntries() {
        return this.entries;
    }

    @NotNull
    public final byte[] toByteArray() {
        String string = ZipEntryListAdapter.INSTANCE.toJson(this);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        String string2 = string;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return byArray;
    }

    @NotNull
    public final Map<String, ZipEntry> component1() {
        return this.entries;
    }

    @NotNull
    public final ZipEntryList copy(@NotNull Map<String, ZipEntry> entries) {
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        return new ZipEntryList(entries);
    }

    public static /* synthetic */ ZipEntryList copy$default(ZipEntryList zipEntryList, Map map, int n15, Object object) {
        if ((n15 & 1) != 0) {
            map = zipEntryList.entries;
        }
        return zipEntryList.copy(map);
    }

    @NotNull
    public String toString() {
        return "ZipEntryList(entries=" + this.entries + ")";
    }

    public int hashCode() {
        return ((Object)this.entries).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ZipEntryList)) {
            return false;
        }
        ZipEntryList zipEntryList = (ZipEntryList)other;
        return Intrinsics.areEqual(this.entries, zipEntryList.entries);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001c\u0010\t\u001a\u00020\u00052\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/android/builder/files/ZipEntryList$Companion;", "", "<init>", "()V", "fromZip", "Lcom/android/builder/files/ZipEntryList;", "file", "Ljava/io/File;", "deserializeFile", "fromEntries", "map", "", "", "Lcom/android/zipflinger/Entry;", "builder"})
    @SourceDebugExtension(value={"SMAP\nZipEntryList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZipEntryList.kt\ncom/android/builder/files/ZipEntryList$Companion\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,130:1\n561#2:131\n546#2,6:132\n463#2:138\n413#2:139\n1252#3,4:140\n*S KotlinDebug\n*F\n+ 1 ZipEntryList.kt\ncom/android/builder/files/ZipEntryList$Companion\n*L\n51#1:131\n51#1:132,6\n69#1:138\n69#1:139\n69#1:140,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ZipEntryList fromZip(@NotNull File file) {
            void $this$filterNotTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Map map = ZipMap.from((Path)file.toPath()).getEntries();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getEntries(...)");
            Map $this$filterNot$iv = map;
            boolean $i$f$filterNot = false;
            Map map2 = $this$filterNot$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterNotTo = false;
            Iterator iterator = $this$filterNotTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry entry = element$iv$iv = iterator.next();
                boolean bl4 = false;
                Entry entry2 = (Entry)entry.getValue();
                if (entry2.isDirectory()) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Map it = destination$iv$iv;
            boolean bl5 = false;
            return Companion.fromEntries(it);
        }

        @NotNull
        public final ZipEntryList deserializeFile(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Object object = ZipEntryListAdapter.INSTANCE.fromJson(FilesKt.readText$default((File)file, null, (int)1, null));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
            return (ZipEntryList)object;
        }

        /*
         * WARNING - void declaration
         */
        private final ZipEntryList fromEntries(Map<String, ? extends Entry> map) {
            void $this$mapValuesTo$iv$iv;
            Map<String, ? extends Entry> $this$mapValues$iv = map;
            boolean $i$f$mapValues = false;
            Map<String, ? extends Entry> map2 = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void entry;
                void it$iv$iv;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv;
                boolean bl4 = false;
                Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
                Object k15 = it$iv$iv.getKey();
                Map map4 = map3;
                boolean bl5 = false;
                String string = ((Entry)entry.getValue()).getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                ZipEntry zipEntry = new ZipEntry(string, ((Entry)entry.getValue()).getCrc(), ((Entry)entry.getValue()).getUncompressedSize());
                map4.put(k15, zipEntry);
            }
            Map it = destination$iv$iv;
            boolean bl6 = false;
            return new ZipEntryList(it);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

