/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.merge;

import com.android.builder.files.RelativeFile;
import com.android.builder.merge.IncrementalFileMergerInput;
import com.android.ide.common.resources.FileStatus;
import com.android.tools.build.apkzlib.utils.CachedSupplier;
import com.android.tools.build.apkzlib.zip.StoredEntry;
import com.android.tools.build.apkzlib.zip.ZFile;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class LazyIncrementalFileMergerInput
implements IncrementalFileMergerInput {
    private final String name;
    @VisibleForTesting
    final CachedSupplier<Map<RelativeFile, FileStatus>> updates;
    @VisibleForTesting
    final CachedSupplier<ImmutableMap<String, RelativeFile>> updatePaths;
    @VisibleForTesting
    final CachedSupplier<ImmutableMap<String, RelativeFile>> filePaths;
    @VisibleForTesting
    final CachedSupplier<ImmutableSet<File>> zips;
    Map<File, ZFile> openZips;

    public LazyIncrementalFileMergerInput(String name, CachedSupplier<Map<RelativeFile, FileStatus>> updates, CachedSupplier<Set<RelativeFile>> files) {
        this.name = name;
        this.updates = updates;
        this.updatePaths = new CachedSupplier(() -> {
            ImmutableMap.Builder pathsBuilder = ImmutableMap.builder();
            for (Map.Entry e15 : ((Map)updates.get()).entrySet()) {
                pathsBuilder.put((Object)((RelativeFile)e15.getKey()).getRelativePath(), (Object)((RelativeFile)e15.getKey()));
            }
            return pathsBuilder.build();
        });
        this.filePaths = new CachedSupplier(() -> {
            ImmutableMap.Builder pathsBuilder = ImmutableMap.builder();
            for (RelativeFile rf5 : (Set)files.get()) {
                pathsBuilder.put((Object)rf5.getRelativePath(), (Object)rf5);
            }
            return pathsBuilder.build();
        });
        this.zips = new CachedSupplier(() -> {
            HashSet<File> zips = new HashSet<File>();
            HashSet<File> visitedZips = new HashSet<File>();
            for (RelativeFile rf5 : (Set)files.get()) {
                if (rf5.getType() != RelativeFile.Type.JAR || visitedZips.contains(rf5.getBase())) continue;
                visitedZips.add(rf5.getBase());
                if (!rf5.getBase().isFile()) continue;
                zips.add(rf5.getBase());
            }
            return ImmutableSet.copyOf(zips);
        });
        this.openZips = null;
    }

    @Override
    public ImmutableSet<String> getUpdatedPaths() {
        return ((ImmutableMap)this.updatePaths.get()).keySet();
    }

    @Override
    public ImmutableSet<String> getAllPaths() {
        return ((ImmutableMap)this.filePaths.get()).keySet();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public FileStatus getFileStatus(String path) {
        RelativeFile rf5 = (RelativeFile)((ImmutableMap)this.updatePaths.get()).get((Object)path);
        if (rf5 == null) {
            return null;
        }
        return (FileStatus)((Map)this.updates.get()).get(rf5);
    }

    @Override
    public InputStream openPath(String path) {
        Preconditions.checkState((this.openZips != null ? 1 : 0) != 0, (Object)"input not open");
        RelativeFile rf5 = (RelativeFile)((ImmutableMap)this.filePaths.get()).get((Object)path);
        Preconditions.checkState((rf5 != null ? 1 : 0) != 0, (String)"Unknown file: %s", (Object)path);
        if (rf5.getType() == RelativeFile.Type.JAR) {
            ZFile zf5 = this.openZips.get(rf5.getBase());
            Preconditions.checkState((zf5 != null ? 1 : 0) != 0, (String)"Unknown base: %s", (Object)rf5.getBase().getName());
            StoredEntry entry = zf5.get(path);
            Preconditions.checkState((entry != null ? 1 : 0) != 0, (String)"Unknown path %s in zip file %s", (Object)path, (Object)zf5.getFile().getAbsolutePath());
            try {
                return entry.open();
            }
            catch (IOException e15) {
                throw new UncheckedIOException(e15);
            }
        }
        try {
            return new FileInputStream(rf5.getFile());
        }
        catch (IOException e16) {
            throw new UncheckedIOException(e16);
        }
    }

    @Override
    public void open() {
        Preconditions.checkState((this.openZips == null ? 1 : 0) != 0, (Object)"input already open");
        HashMap<File, ZFile> open = new HashMap<File, ZFile>();
        UncheckedIOException failure = null;
        for (File f15 : (ImmutableSet)this.zips.get()) {
            try {
                ZFile zf5 = ZFile.openReadOnly((File)f15);
                open.put(f15, zf5);
            }
            catch (IOException e15) {
                failure = new UncheckedIOException(e15);
                break;
            }
        }
        if (failure != null) {
            for (ZFile zf6 : open.values()) {
                try {
                    zf6.close();
                }
                catch (IOException e16) {
                    failure.addSuppressed(e16);
                }
            }
            throw failure;
        }
        this.openZips = open;
    }

    @Override
    public void close() {
        Preconditions.checkState((this.openZips != null ? 1 : 0) != 0, (Object)"input not open");
        try (Closer closer = Closer.create();){
            for (ZFile zf5 : this.openZips.values()) {
                closer.register((Closeable)zf5);
            }
        }
        catch (IOException e15) {
            throw new UncheckedIOException(e15);
        }
        finally {
            this.openZips = null;
        }
    }
}

