/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.profile;

import com.android.builder.profile.ChromeTracingProfileConverter;
import com.android.tools.analytics.CommonMetricsData;
import com.android.tools.analytics.UsageTracker;
import com.android.utils.PathUtils;
import com.android.utils.StdLogger;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.GradleBuildProfile;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0012\u0010\u000f\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0006\u0010\u0010\u001a\u00020\fJ0\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J.\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001a\u001a\u00020\u0018R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/builder/profile/AnalyticsProfileWriter;", "", "()V", "profileFileName", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "random", "", "scheduledExecutorService", "Ljava/util/concurrent/ScheduledExecutorService;", "studioEventFileName", "cleanUpExtraChromeTraceDirectory", "", "profileDir", "Ljava/io/File;", "deInitializedAnalytics", "initializeUsageTracker", "writeAnalytics", "profile", "Lcom/google/wireless/android/sdk/stats/GradleBuildProfile;", "events", "", "Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$Builder;", "enableChromeTracingOutput", "", "writeAndFinish", "enableProfileJson", "Companion"})
@SourceDebugExtension(value={"SMAP\nAnalyticsProfileWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnalyticsProfileWriter.kt\ncom/android/builder/profile/AnalyticsProfileWriter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,165:1\n1863#2,2:166\n1863#2,2:169\n1#3:168\n*S KotlinDebug\n*F\n+ 1 AnalyticsProfileWriter.kt\ncom/android/builder/profile/AnalyticsProfileWriter\n*L\n100#1:166,2\n121#1:169,2\n*E\n"})
public final class AnalyticsProfileWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String random;
    private final DateTimeFormatter profileFileName;
    private final DateTimeFormatter studioEventFileName;
    @NotNull
    private final ScheduledExecutorService scheduledExecutorService;
    @NotNull
    private static final Object gate = new Object();

    public AnalyticsProfileWriter() {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.random = string;
        this.profileFileName = DateTimeFormatter.ofPattern("'profile-'yyyy-MM-dd-HH-mm-ss-SSS'-" + this.random + ".rawproto'", Locale.US);
        this.studioEventFileName = DateTimeFormatter.ofPattern("'studioEvent-'yyyy-MM-dd-HH-mm-ss-SSS'-" + this.random + ".trk'", Locale.US);
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"newScheduledThreadPool(...)");
        this.scheduledExecutorService = scheduledExecutorService;
    }

    public final void writeAndFinish(@NotNull GradleBuildProfile profile, @NotNull List<AndroidStudioEvent.Builder> events, @Nullable File profileDir, boolean enableProfileJson) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        Intrinsics.checkNotNullParameter(events, (String)"events");
        if (profileDir == null) {
            this.scheduledExecutorService.submit(new Runnable(this, profile, events, enableProfileJson, profileDir){
                final /* synthetic */ AnalyticsProfileWriter this$0;
                final /* synthetic */ GradleBuildProfile $profile;
                final /* synthetic */ List<AndroidStudioEvent.Builder> $events;
                final /* synthetic */ boolean $enableProfileJson;
                final /* synthetic */ File $profileDir;
                {
                    this.this$0 = $receiver;
                    this.$profile = $profile;
                    this.$events = $events;
                    this.$enableProfileJson = $enableProfileJson;
                    this.$profileDir = $profileDir;
                }

                public final void run() {
                    AnalyticsProfileWriter.access$writeAnalytics(this.this$0, this.$profile, this.$events, this.$enableProfileJson, this.$profileDir);
                }
            });
        } else {
            this.writeAnalytics(profile, events, enableProfileJson, profileDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeAnalytics(GradleBuildProfile profile, List<AndroidStudioEvent.Builder> events, boolean enableChromeTracingOutput, File profileDir) {
        Object object = gate;
        synchronized (object) {
            BufferedOutputStream outputStream;
            Throwable throwable;
            Object object2;
            Path studioMetricsFile;
            boolean bl2 = false;
            this.initializeUsageTracker();
            AndroidStudioEvent.Builder builder = AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.GRADLE).setKind(AndroidStudioEvent.EventKind.GRADLE_BUILD_PROFILE).setGradleBuildProfile(profile).setJavaProcessStats(CommonMetricsData.getJavaProcessStats()).setJvmDetails(CommonMetricsData.getJvmDetails());
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setJvmDetails(...)");
            UsageTracker.log((AndroidStudioEvent.Builder)builder);
            Iterable $this$forEach$iv = events;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AndroidStudioEvent.Builder it = (AndroidStudioEvent.Builder)element$iv;
                boolean bl3 = false;
                UsageTracker.log((AndroidStudioEvent.Builder)it);
            }
            Comparable<File> comparable = profileDir;
            Path outputFile = comparable != null && (comparable = ((File)comparable).toPath()) != null ? comparable.resolve(this.profileFileName.format(LocalDateTime.now())) : null;
            Comparable<File> comparable2 = profileDir;
            Path path = comparable2 != null && (comparable2 = ((File)comparable2).toPath()) != null ? comparable2.resolve(this.studioEventFileName.format(LocalDateTime.now())) : (studioMetricsFile = null);
            if (outputFile != null) {
                Files.createDirectories(outputFile.getParent(), new FileAttribute[0]);
                object2 = new OpenOption[]{StandardOpenOption.CREATE_NEW};
                object2 = new BufferedOutputStream(Files.newOutputStream(outputFile, object2));
                throwable = null;
                try {
                    outputStream = (BufferedOutputStream)object2;
                    boolean bl4 = false;
                    profile.writeTo((OutputStream)outputStream);
                    outputStream = Unit.INSTANCE;
                }
                catch (Throwable outputStream2) {
                    throwable = outputStream2;
                    throw outputStream2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
                }
                if (enableChromeTracingOutput) {
                    ChromeTracingProfileConverter.toJson(outputFile);
                }
            }
            if (studioMetricsFile != null) {
                object2 = new OpenOption[]{StandardOpenOption.CREATE_NEW};
                object2 = new BufferedOutputStream(Files.newOutputStream(studioMetricsFile, object2));
                throwable = null;
                try {
                    outputStream = (BufferedOutputStream)object2;
                    boolean bl5 = false;
                    Iterable $this$forEach$iv2 = events;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv : $this$forEach$iv2) {
                        AndroidStudioEvent.Builder it = (AndroidStudioEvent.Builder)element$iv;
                        boolean bl6 = false;
                        it.build().toByteString().writeTo((OutputStream)outputStream);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
                }
            }
            this.deInitializedAnalytics(profileDir);
            Unit unit = Unit.INSTANCE;
        }
    }

    public final void initializeUsageTracker() {
        UsageTracker.initialize((ScheduledExecutorService)this.scheduledExecutorService);
        UsageTracker.setMaxJournalTime((long)10L, (TimeUnit)TimeUnit.MINUTES);
        UsageTracker.setMaxJournalSize((int)1000);
    }

    private final void deInitializedAnalytics(File profileDir) {
        UsageTracker.deinitialize();
        this.cleanUpExtraChromeTraceDirectory(profileDir);
        this.scheduledExecutorService.shutdown();
    }

    private final void cleanUpExtraChromeTraceDirectory(File profileDir) {
        Path profileDirPath;
        File file = profileDir;
        Path path = profileDirPath = file != null ? file.toPath() : null;
        if (profileDirPath != null) {
            Path extraChromeTracePath = profileDirPath.resolve("extra_chrome_trace");
            try {
                PathUtils.deleteRecursivelyIfExists((Path)extraChromeTracePath);
            }
            catch (IOException e11) {
                Object[] objectArray = new Object[]{e11};
                new StdLogger(StdLogger.Level.WARNING).warning("Cannot extra Chrome trace directory " + extraChromeTracePath + ". The generatedChrome trace file may contain stale data.", objectArray);
            }
        }
    }

    public static final /* synthetic */ void access$writeAnalytics(AnalyticsProfileWriter $this, GradleBuildProfile profile, List events, boolean enableChromeTracingOutput, File profileDir) {
        $this.writeAnalytics(profile, events, enableChromeTracingOutput, profileDir);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/builder/profile/AnalyticsProfileWriter$Companion;", "", "()V", "gate", "getGate", "()Ljava/lang/Object;", "profile"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Object getGate() {
            return gate;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

