/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dexing;

import com.android.builder.dexing.ClassBucketGroup;
import com.android.builder.dexing.ClassFileEntry;
import com.android.builder.dexing.ClassFileInput;
import com.android.builder.dexing.ClassFileInputs;
import com.android.builder.dexing.JarBucketGroup;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J.\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00102\u0006\u0010\u0014\u001a\u00020\u0015J \u0010\n\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0013H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcom/android/builder/dexing/ClassBucket;", "Ljava/io/Serializable;", "bucketGroup", "Lcom/android/builder/dexing/ClassBucketGroup;", "bucketNumber", "", "<init>", "(Lcom/android/builder/dexing/ClassBucketGroup;I)V", "getBucketGroup", "()Lcom/android/builder/dexing/ClassBucketGroup;", "getBucketNumber", "()I", "getClassFiles", "Ljava/util/stream/Stream;", "Lcom/android/builder/dexing/ClassFileEntry;", "filter", "Lkotlin/Function2;", "Ljava/io/File;", "", "", "closer", "Lcom/google/common/io/Closer;", "relativePath", "numberOfBuckets", "isJarFile", "Companion", "builder-r8"})
public final class ClassBucket
implements Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClassBucketGroup bucketGroup;
    private final int bucketNumber;
    private static final long serialVersionUID = 1L;

    public ClassBucket(@NotNull ClassBucketGroup bucketGroup, int bucketNumber) {
        Intrinsics.checkNotNullParameter((Object)bucketGroup, (String)"bucketGroup");
        this.bucketGroup = bucketGroup;
        this.bucketNumber = bucketNumber;
    }

    @NotNull
    public final ClassBucketGroup getBucketGroup() {
        return this.bucketGroup;
    }

    public final int getBucketNumber() {
        return this.bucketNumber;
    }

    @NotNull
    public final Stream<ClassFileEntry> getClassFiles(@NotNull Function2<? super File, ? super String, Boolean> filter, @NotNull Closer closer) {
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        Intrinsics.checkNotNullParameter((Object)closer, (String)"closer");
        Stream<Object> classFiles = Stream.empty();
        for (File root : this.bucketGroup.getRoots()) {
            ClassFileInput classFileInput;
            Intrinsics.checkNotNullExpressionValue((Object)ClassFileInputs.fromPath(root.toPath()), (String)"fromPath(...)");
            closer.register((Closeable)classFileInput);
            classFiles = Stream.concat(classFiles, classFileInput.entries(new BiPredicate(this, filter){
                final /* synthetic */ ClassBucket this$0;
                final /* synthetic */ Function2<File, String, Boolean> $filter;
                {
                    this.this$0 = $receiver;
                    this.$filter = $filter;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean test(Path rootPath, String relativePath) {
                    Intrinsics.checkNotNull((Object)relativePath);
                    if (ClassBucket.access$getBucketNumber(this.this$0, relativePath, this.this$0.getBucketGroup().getNumOfBuckets(), this.this$0.getBucketGroup() instanceof JarBucketGroup) != this.this$0.getBucketNumber()) return false;
                    File file = rootPath.toFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
                    if ((Boolean)this.$filter.invoke((Object)file, (Object)relativePath) == false) return false;
                    return true;
                }
            }));
        }
        Stream stream = classFiles;
        Intrinsics.checkNotNull((Object)stream);
        return stream;
    }

    private final int getBucketNumber(String relativePath, int numberOfBuckets, boolean isJarFile2) {
        String string;
        if (!(!new File(relativePath).isAbsolute())) {
            boolean $i$a$-check-ClassBucket$getBucketNumber$22 = false;
            String $i$a$-check-ClassBucket$getBucketNumber$22 = "Expected relative path but found absolute path: " + relativePath;
            throw new IllegalStateException($i$a$-check-ClassBucket$getBucketNumber$22.toString());
        }
        if (isJarFile2) {
            string = new File(relativePath).getParent();
            if (string == null) {
                string = "";
            }
        } else {
            string = relativePath;
        }
        String pathOfPackageOrClass = string;
        String normalizedPath = FilesKt.getInvariantSeparatorsPath((File)new File(pathOfPackageOrClass));
        return Math.abs(normalizedPath.hashCode()) % numberOfBuckets;
    }

    public static final /* synthetic */ int access$getBucketNumber(ClassBucket $this, String relativePath, int numberOfBuckets, boolean isJarFile2) {
        return $this.getBucketNumber(relativePath, numberOfBuckets, isJarFile2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/builder/dexing/ClassBucket$Companion;", "", "<init>", "()V", "serialVersionUID", "", "builder-r8"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

