/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.aapt.v2;

import com.android.builder.internal.aapt.AaptConvertConfig;
import com.android.builder.internal.aapt.AaptPackageConfig;
import com.android.builder.internal.aapt.v2.Aapt2Daemon;
import com.android.builder.internal.aapt.v2.Aapt2DaemonImpl;
import com.android.builder.internal.aapt.v2.Aapt2DaemonTimeouts;
import com.android.builder.internal.aapt.v2.Aapt2DaemonUtil;
import com.android.builder.internal.aapt.v2.Aapt2Exception;
import com.android.builder.internal.aapt.v2.Aapt2InternalException;
import com.android.builder.internal.aapt.v2.AaptV2CommandBuilder;
import com.android.ide.common.resources.CompileResourceRequest;
import com.android.utils.GrabProcessOutput;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.SettableFuture;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeoutException;
import kotlin.ExceptionsKt;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000w\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006*\u0001\u0018\u0018\u00002\u00020\u0001:\u0004*+,-B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rB)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\u0010J\b\u0010\u001a\u001a\u00020\u001bH\u0014J\u001c\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00032\n\u0010\u001f\u001a\u00060 j\u0002`!H\u0002J\u0018\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0018\u0010%\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020&2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0018\u0010'\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020(2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010)\u001a\u00020\u001bH\u0014R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0019\u00a8\u0006."}, d2={"Lcom/android/builder/internal/aapt/v2/Aapt2DaemonImpl;", "Lcom/android/builder/internal/aapt/v2/Aapt2Daemon;", "displayId", "", "aaptPath", "aaptCommand", "", "versionString", "daemonTimeouts", "Lcom/android/builder/internal/aapt/v2/Aapt2DaemonTimeouts;", "logger", "Lcom/android/utils/ILogger;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;Lcom/android/builder/internal/aapt/v2/Aapt2DaemonTimeouts;Lcom/android/utils/ILogger;)V", "aaptExecutable", "Ljava/nio/file/Path;", "(Ljava/lang/String;Ljava/nio/file/Path;Lcom/android/builder/internal/aapt/v2/Aapt2DaemonTimeouts;Lcom/android/utils/ILogger;)V", "noOutputExpected", "Lcom/android/builder/internal/aapt/v2/Aapt2DaemonImpl$NoOutputExpected;", "process", "Ljava/lang/Process;", "writer", "Ljava/io/Writer;", "processOutput", "com/android/builder/internal/aapt/v2/Aapt2DaemonImpl$processOutput$1", "Lcom/android/builder/internal/aapt/v2/Aapt2DaemonImpl$processOutput$1;", "startProcess", "", "stopQuietly", "", "message", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "doCompile", "request", "Lcom/android/ide/common/resources/CompileResourceRequest;", "doLink", "Lcom/android/builder/internal/aapt/AaptPackageConfig;", "doConvert", "Lcom/android/builder/internal/aapt/AaptConvertConfig;", "stopProcess", "NoOutputExpected", "WaitForReadyOnStdOut", "WaitForTaskCompletion", "AllowShutdown", "builder"})
@SourceDebugExtension(value={"SMAP\nAapt2DaemonImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Aapt2DaemonImpl.kt\ncom/android/builder/internal/aapt/v2/Aapt2DaemonImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,388:1\n1#2:389\n*E\n"})
public final class Aapt2DaemonImpl
extends Aapt2Daemon {
    @NotNull
    private final String aaptPath;
    @NotNull
    private final List<String> aaptCommand;
    @NotNull
    private final Aapt2DaemonTimeouts daemonTimeouts;
    @NotNull
    private final NoOutputExpected noOutputExpected;
    private Process process;
    private Writer writer;
    @NotNull
    private final processOutput.1 processOutput;

    public Aapt2DaemonImpl(@NotNull String displayId, @NotNull String aaptPath, @NotNull List<String> aaptCommand, @NotNull String versionString, @NotNull Aapt2DaemonTimeouts daemonTimeouts, @NotNull ILogger logger) {
        Intrinsics.checkNotNullParameter((Object)displayId, (String)"displayId");
        Intrinsics.checkNotNullParameter((Object)aaptPath, (String)"aaptPath");
        Intrinsics.checkNotNullParameter(aaptCommand, (String)"aaptCommand");
        Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
        Intrinsics.checkNotNullParameter((Object)daemonTimeouts, (String)"daemonTimeouts");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        super("AAPT2 " + versionString + " Daemon " + displayId, logger);
        this.aaptPath = aaptPath;
        this.aaptCommand = aaptCommand;
        this.daemonTimeouts = daemonTimeouts;
        this.noOutputExpected = new NoOutputExpected(this.getDisplayName(), logger);
        this.processOutput = new GrabProcessOutput.IProcessOutput(this){
            private volatile GrabProcessOutput.IProcessOutput delegate;
            {
                this.delegate = Aapt2DaemonImpl.access$getNoOutputExpected$p($receiver);
            }

            public final GrabProcessOutput.IProcessOutput getDelegate() {
                return this.delegate;
            }

            public final void setDelegate(GrabProcessOutput.IProcessOutput iProcessOutput) {
                Intrinsics.checkNotNullParameter((Object)iProcessOutput, (String)"<set-?>");
                this.delegate = iProcessOutput;
            }

            public void out(String line) {
                this.delegate.out(line);
            }

            public void err(String line) {
                this.delegate.err(line);
            }
        };
    }

    public Aapt2DaemonImpl(@NotNull String displayId, @NotNull Path aaptExecutable, @NotNull Aapt2DaemonTimeouts daemonTimeouts, @NotNull ILogger logger) {
        Intrinsics.checkNotNullParameter((Object)displayId, (String)"displayId");
        Intrinsics.checkNotNullParameter((Object)aaptExecutable, (String)"aaptExecutable");
        Intrinsics.checkNotNullParameter((Object)daemonTimeouts, (String)"daemonTimeouts");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        String string = aaptExecutable.toFile().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        Object[] objectArray = new String[]{aaptExecutable.toFile().getAbsolutePath(), "m"};
        this(displayId, string, CollectionsKt.listOf((Object[])objectArray), ((Object)aaptExecutable.getParent().getFileName()).toString(), daemonTimeouts, logger);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void startProcess() throws TimeoutException {
        Comparable<Charset> comparable;
        Closeable closeable;
        WaitForReadyOnStdOut waitForReady = new WaitForReadyOnStdOut(this.getDisplayName(), this.getLogger());
        this.processOutput.setDelegate(waitForReady);
        ProcessBuilder processBuilder = new ProcessBuilder(this.aaptCommand);
        Process process = processBuilder.start();
        Intrinsics.checkNotNullExpressionValue((Object)process, (String)"start(...)");
        this.process = process;
        Aapt2DaemonImpl aapt2DaemonImpl = this;
        try {
            Aapt2DaemonImpl aapt2DaemonImpl2 = aapt2DaemonImpl;
            Process process2 = this.process;
            if (process2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"process");
                process2 = null;
            }
            GrabProcessOutput.grabProcessOutput((Process)process2, (GrabProcessOutput.Wait)GrabProcessOutput.Wait.ASYNC, (GrabProcessOutput.IProcessOutput)this.processOutput, null, null);
            Process process3 = this.process;
            if (process3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"process");
                process3 = null;
            }
            OutputStream outputStream = process3.getOutputStream();
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"getOutputStream(...)");
            closeable = outputStream;
            comparable = Charsets.UTF_8;
            Writer writer = new OutputStreamWriter((OutputStream)closeable, (Charset)comparable);
            int n15 = 8192;
            closeable = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer, n15);
        }
        catch (Exception exception) {
            void e15;
            void var5_8;
            void var6_12 = var5_8 = e15;
            boolean bl5 = false;
            try {
                Process process4 = this.process;
                if (process4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"process");
                    process4 = null;
                }
                process4.destroyForcibly();
            }
            catch (Exception suppressed) {
                void $this$startProcess_u24lambda_u240;
                ExceptionsKt.addSuppressed((Throwable)((Throwable)$this$startProcess_u24lambda_u240), (Throwable)suppressed);
            }
            Aapt2DaemonImpl aapt2DaemonImpl3 = aapt2DaemonImpl;
            throw (Throwable)var5_8;
        }
        aapt2DaemonImpl2.writer = closeable;
        try {
            comparable = (Boolean)waitForReady.getFuture().get(this.daemonTimeouts.getStart(), this.daemonTimeouts.getStartUnit());
        }
        catch (TimeoutException e16) {
            String string = this.getDisplayName();
            long l15 = this.daemonTimeouts.getStart();
            String string2 = this.daemonTimeouts.getStartUnit().name();
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string3 = string2.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            this.stopQuietly("Failed to start AAPT2 process " + string + ". Not ready within " + l15 + " " + string3 + ".", e16);
            throw new KotlinNothingValueException();
        }
        catch (Exception e17) {
            this.stopQuietly("Failed to start AAPT2 process.", e17);
            throw new KotlinNothingValueException();
        }
        Comparable<Charset> ready = comparable;
        if (!((Boolean)ready).booleanValue()) {
            this.stopQuietly("Failed to start AAPT2 process.", new IOException("Process unexpectedly exit."));
            throw new KotlinNothingValueException();
        }
        this.processOutput.setDelegate(this.noOutputExpected);
    }

    private final Void stopQuietly(String message, Exception e15) {
        Aapt2InternalException aapt2InternalException;
        Aapt2InternalException $this$stopQuietly_u24lambda_u241 = aapt2InternalException = new Aapt2InternalException(message, e15);
        boolean bl5 = false;
        try {
            this.stopProcess();
        }
        catch (Exception suppressed) {
            ExceptionsKt.addSuppressed((Throwable)$this$stopQuietly_u24lambda_u241, (Throwable)suppressed);
        }
        throw (Throwable)aapt2InternalException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doCompile(@NotNull CompileResourceRequest request, @NotNull ILogger logger) throws TimeoutException, Aapt2InternalException, Aapt2Exception {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        WaitForTaskCompletion waitForTask = new WaitForTaskCompletion(this.getDisplayName(), logger);
        try {
            block9: {
                File $this$doCompile_u24lambda_u242;
                block10: {
                    File file;
                    this.processOutput.setDelegate(waitForTask);
                    Writer writer = this.writer;
                    if (writer == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"writer");
                        writer = null;
                    }
                    Aapt2DaemonUtil.requestCompile(writer, request);
                    File file2 = request.getPartialRFile();
                    if (file2 == null) break block9;
                    $this$doCompile_u24lambda_u242 = file = file2;
                    boolean bl5 = false;
                    if (StringsKt.startsWith$default((String)request.getInputDirectoryName(), (String)"raw", (boolean)false, (int)2, null)) break block10;
                    String string = request.getInputFile().getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                    if (StringsKt.endsWith$default((String)string, (String)".xml", (boolean)false, (int)2, null)) break block9;
                }
                String type = StringsKt.substringBefore$default((String)request.getInputDirectoryName(), (char)'-', null, (int)2, null);
                String string = request.getInputFile().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                String nameWithoutExtension = StringsKt.substringBefore$default((String)string, (char)'.', null, (int)2, null);
                Files.write($this$doCompile_u24lambda_u242.toPath(), (Iterable<? extends CharSequence>)((Iterable)ImmutableList.of((Object)("default int " + type + " " + nameWithoutExtension))), new OpenOption[0]);
            }
            WaitForTaskCompletion.Result result = (WaitForTaskCompletion.Result)waitForTask.getFuture().get(this.daemonTimeouts.getCompile(), this.daemonTimeouts.getCompileUnit());
            if (!(result instanceof WaitForTaskCompletion.Result.Succeeded)) {
                if (result instanceof WaitForTaskCompletion.Result.Failed) {
                    String args = CollectionsKt.joinToString$default((Iterable)((Iterable)AaptV2CommandBuilder.makeCompileCommand(request)), (CharSequence)" \\\n        ", null, null, (int)0, null, null, (int)62, null);
                    throw Aapt2Exception.Companion.create$default(Aapt2Exception.Companion, logger, "Android resource compilation failed", null, ((WaitForTaskCompletion.Result.Failed)result).getStdErr(), this.getDisplayName(), this.aaptPath + " compile " + args, 4, null);
                }
                if (result instanceof WaitForTaskCompletion.Result.InternalAapt2Error) {
                    throw ((WaitForTaskCompletion.Result.InternalAapt2Error)result).getFailure();
                }
                throw new NoWhenBranchMatchedException();
            }
        }
        finally {
            this.processOutput.setDelegate(this.noOutputExpected);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doLink(@NotNull AaptPackageConfig request, @NotNull ILogger logger) throws TimeoutException, Aapt2InternalException, Aapt2Exception {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        WaitForTaskCompletion waitForTask = new WaitForTaskCompletion(this.getDisplayName(), logger);
        try {
            this.processOutput.setDelegate(waitForTask);
            Writer writer = this.writer;
            if (writer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"writer");
                writer = null;
            }
            Aapt2DaemonUtil.requestLink(writer, request);
            WaitForTaskCompletion.Result result = (WaitForTaskCompletion.Result)waitForTask.getFuture().get(this.daemonTimeouts.getLink(), this.daemonTimeouts.getLinkUnit());
            if (!(result instanceof WaitForTaskCompletion.Result.Succeeded)) {
                if (result instanceof WaitForTaskCompletion.Result.Failed) {
                    AaptPackageConfig configWithResourcesListed = request.getIntermediateDir() != null ? AaptPackageConfig.copy$default(request, null, null, null, null, null, null, null, null, null, false, null, null, null, null, null, null, null, false, null, false, null, false, null, true, false, null, null, false, false, false, false, null, null, null, null, null, null, false, -8388609, 63, null) : request;
                    String args = CollectionsKt.joinToString$default((Iterable)((Iterable)AaptV2CommandBuilder.makeLinkCommand(configWithResourcesListed)), (CharSequence)"\\\n        ", null, null, (int)0, null, null, (int)62, null);
                    throw Aapt2Exception.Companion.create$default(Aapt2Exception.Companion, logger, "Android resource linking failed", null, ((WaitForTaskCompletion.Result.Failed)result).getStdErr(), this.getDisplayName(), this.aaptPath + " link " + args, 4, null);
                }
                if (result instanceof WaitForTaskCompletion.Result.InternalAapt2Error) {
                    throw ((WaitForTaskCompletion.Result.InternalAapt2Error)result).getFailure();
                }
                throw new NoWhenBranchMatchedException();
            }
        }
        finally {
            this.processOutput.setDelegate(this.noOutputExpected);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doConvert(@NotNull AaptConvertConfig request, @NotNull ILogger logger) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        WaitForTaskCompletion waitForTask = new WaitForTaskCompletion(this.getDisplayName(), logger);
        try {
            this.processOutput.setDelegate(waitForTask);
            Writer writer = this.writer;
            if (writer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"writer");
                writer = null;
            }
            Aapt2DaemonUtil.requestConvert(writer, request);
            WaitForTaskCompletion.Result result = (WaitForTaskCompletion.Result)waitForTask.getFuture().get(this.daemonTimeouts.getLink(), this.daemonTimeouts.getLinkUnit());
            if (!(result instanceof WaitForTaskCompletion.Result.Succeeded)) {
                if (result instanceof WaitForTaskCompletion.Result.Failed) {
                    String args = CollectionsKt.joinToString$default((Iterable)((Iterable)AaptV2CommandBuilder.makeConvertCommand(request)), (CharSequence)"\\\n        ", null, null, (int)0, null, null, (int)62, null);
                    throw Aapt2Exception.Companion.create$default(Aapt2Exception.Companion, logger, "Android resource linking failed", null, ((WaitForTaskCompletion.Result.Failed)result).getStdErr(), this.getDisplayName(), this.aaptPath + " convert " + args, 4, null);
                }
                if (result instanceof WaitForTaskCompletion.Result.InternalAapt2Error) {
                    throw ((WaitForTaskCompletion.Result.InternalAapt2Error)result).getFailure();
                }
                throw new NoWhenBranchMatchedException();
            }
        }
        finally {
            this.processOutput.setDelegate(this.noOutputExpected);
        }
    }

    @Override
    protected void stopProcess() throws TimeoutException {
        boolean shutdown;
        Process process;
        this.processOutput.setDelegate(new AllowShutdown(this.getDisplayName(), this.getLogger()));
        IOException suppressed = null;
        try {
            Writer writer = this.writer;
            if (writer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"writer");
                writer = null;
            }
            writer.write("quit\n\n");
            Writer writer2 = this.writer;
            if (writer2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"writer");
                writer2 = null;
            }
            writer2.flush();
        }
        catch (IOException e15) {
            suppressed = e15;
        }
        if ((process = this.process) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"process");
            process = null;
        }
        if (shutdown = process.waitFor(this.daemonTimeouts.getStop(), this.daemonTimeouts.getStopUnit())) {
            return;
        }
        String string = this.getDisplayName();
        long l15 = this.daemonTimeouts.getStop();
        Object object = this.daemonTimeouts.getStopUnit().name();
        Locale locale = Locale.US;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
        String string2 = ((String)object).toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        Object $this$stopProcess_u24lambda_u244 = object = new TimeoutException(string + ": Failed to shut down within " + l15 + " " + string2 + ". Forcing shutdown");
        boolean bl5 = false;
        Exception exception = suppressed;
        if (exception != null) {
            Exception it = exception;
            boolean bl6 = false;
            ExceptionsKt.addSuppressed((Throwable)((Throwable)$this$stopProcess_u24lambda_u244), (Throwable)it);
        }
        try {
            Process process2 = this.process;
            if (process2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"process");
                process2 = null;
            }
            process2.destroyForcibly();
        }
        catch (Exception suppressed2) {
            ExceptionsKt.addSuppressed((Throwable)((Throwable)$this$stopProcess_u24lambda_u244), (Throwable)suppressed2);
        }
        throw (Throwable)object;
    }

    public static final /* synthetic */ NoOutputExpected access$getNoOutputExpected$p(Aapt2DaemonImpl $this) {
        return $this.noOutputExpected;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0016J\u0012\u0010\r\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lcom/android/builder/internal/aapt/v2/Aapt2DaemonImpl$AllowShutdown;", "Lcom/android/utils/GrabProcessOutput$IProcessOutput;", "displayName", "", "logger", "Lcom/android/utils/ILogger;", "<init>", "(Ljava/lang/String;Lcom/android/utils/ILogger;)V", "getLogger", "()Lcom/android/utils/ILogger;", "out", "", "line", "err", "builder"})
    public static final class AllowShutdown
    implements GrabProcessOutput.IProcessOutput {
        @NotNull
        private final String displayName;
        @NotNull
        private final ILogger logger;

        public AllowShutdown(@NotNull String displayName, @NotNull ILogger logger) {
            Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            this.displayName = displayName;
            this.logger = logger;
        }

        @NotNull
        public final ILogger getLogger() {
            return this.logger;
        }

        public void out(@Nullable String line) {
            String string = line;
            if (string == null || Intrinsics.areEqual((Object)string, (Object)"") || Intrinsics.areEqual((Object)string, (Object)"Exiting daemon")) {
                return;
            }
            this.logger.error(null, this.displayName + ": Unexpected standard output: " + line, new Object[0]);
        }

        public void err(@Nullable String line) {
            block0: {
                String string = line;
                if (string == null) break block0;
                String it = string;
                boolean bl5 = false;
                this.logger.error(null, this.displayName + ": Unexpected error output: " + line, new Object[0]);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0016J\u0012\u0010\r\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lcom/android/builder/internal/aapt/v2/Aapt2DaemonImpl$NoOutputExpected;", "Lcom/android/utils/GrabProcessOutput$IProcessOutput;", "displayName", "", "logger", "Lcom/android/utils/ILogger;", "<init>", "(Ljava/lang/String;Lcom/android/utils/ILogger;)V", "getLogger", "()Lcom/android/utils/ILogger;", "out", "", "line", "err", "builder"})
    public static final class NoOutputExpected
    implements GrabProcessOutput.IProcessOutput {
        @NotNull
        private final String displayName;
        @NotNull
        private final ILogger logger;

        public NoOutputExpected(@NotNull String displayName, @NotNull ILogger logger) {
            Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            this.displayName = displayName;
            this.logger = logger;
        }

        @NotNull
        public final ILogger getLogger() {
            return this.logger;
        }

        public void out(@Nullable String line) {
            if (line != null) {
                this.logger.error(null, this.displayName + ": Unexpected standard output: " + line, new Object[0]);
            }
        }

        public void err(@Nullable String line) {
            if (line != null) {
                this.logger.error(null, this.displayName + ": Unexpected error output: " + line, new Object[0]);
            } else {
                this.logger.error(null, this.displayName + ": Idle daemon unexpectedly exit. This should not happen.", new Object[0]);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u0016J\u0012\u0010\u0012\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lcom/android/builder/internal/aapt/v2/Aapt2DaemonImpl$WaitForReadyOnStdOut;", "Lcom/android/utils/GrabProcessOutput$IProcessOutput;", "displayName", "", "logger", "Lcom/android/utils/ILogger;", "<init>", "(Ljava/lang/String;Lcom/android/utils/ILogger;)V", "getLogger", "()Lcom/android/utils/ILogger;", "future", "Lcom/google/common/util/concurrent/SettableFuture;", "", "getFuture", "()Lcom/google/common/util/concurrent/SettableFuture;", "out", "", "line", "err", "builder"})
    public static final class WaitForReadyOnStdOut
    implements GrabProcessOutput.IProcessOutput {
        @NotNull
        private final String displayName;
        @NotNull
        private final ILogger logger;
        @NotNull
        private final SettableFuture<Boolean> future;

        public WaitForReadyOnStdOut(@NotNull String displayName, @NotNull ILogger logger) {
            Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            this.displayName = displayName;
            this.logger = logger;
            SettableFuture settableFuture = SettableFuture.create();
            Intrinsics.checkNotNullExpressionValue((Object)settableFuture, (String)"create(...)");
            this.future = settableFuture;
        }

        @NotNull
        public final ILogger getLogger() {
            return this.logger;
        }

        @NotNull
        public final SettableFuture<Boolean> getFuture() {
            return this.future;
        }

        public void out(@Nullable String line) {
            String string = line;
            if (string == null) {
                if (!this.future.isDone()) {
                    this.future.set((Object)false);
                }
            } else {
                if (Intrinsics.areEqual((Object)string, (Object)"")) {
                    return;
                }
                if (Intrinsics.areEqual((Object)string, (Object)"Ready")) {
                    this.future.set((Object)true);
                } else {
                    this.logger.error(null, this.displayName + ": Unexpected error output: " + line, new Object[0]);
                }
            }
        }

        public void err(@Nullable String line) {
            block0: {
                String string = line;
                if (string == null) break block0;
                String it = string;
                boolean bl5 = false;
                this.logger.error(null, this.displayName + ": Unexpected error output: " + it, new Object[0]);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0019B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0016J\u0012\u0010\u0018\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001f\u0010\n\u001a\u0010\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\n\u0018\u00010\u0011j\u0004\u0018\u0001`\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/builder/internal/aapt/v2/Aapt2DaemonImpl$WaitForTaskCompletion;", "Lcom/android/utils/GrabProcessOutput$IProcessOutput;", "displayName", "", "logger", "Lcom/android/utils/ILogger;", "<init>", "(Ljava/lang/String;Lcom/android/utils/ILogger;)V", "getLogger", "()Lcom/android/utils/ILogger;", "future", "Lcom/google/common/util/concurrent/SettableFuture;", "Lcom/android/builder/internal/aapt/v2/Aapt2DaemonImpl$WaitForTaskCompletion$Result;", "kotlin.jvm.PlatformType", "getFuture", "()Lcom/google/common/util/concurrent/SettableFuture;", "errors", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "foundError", "", "out", "", "line", "err", "Result", "builder"})
    @SourceDebugExtension(value={"SMAP\nAapt2DaemonImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Aapt2DaemonImpl.kt\ncom/android/builder/internal/aapt/v2/Aapt2DaemonImpl$WaitForTaskCompletion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,388:1\n1#2:389\n*E\n"})
    public static final class WaitForTaskCompletion
    implements GrabProcessOutput.IProcessOutput {
        @NotNull
        private final String displayName;
        @NotNull
        private final ILogger logger;
        @NotNull
        private final SettableFuture<Result> future;
        @Nullable
        private StringBuilder errors;
        private boolean foundError;

        public WaitForTaskCompletion(@NotNull String displayName, @NotNull ILogger logger) {
            Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            this.displayName = displayName;
            this.logger = logger;
            SettableFuture settableFuture = SettableFuture.create();
            Intrinsics.checkNotNull((Object)settableFuture);
            this.future = settableFuture;
        }

        @NotNull
        public final ILogger getLogger() {
            return this.logger;
        }

        @NotNull
        public final SettableFuture<Result> getFuture() {
            return this.future;
        }

        public void out(@Nullable String line) {
            block0: {
                String string = line;
                if (string == null) break block0;
                String it = string;
                boolean bl5 = false;
                Object[] objectArray = new Object[]{this.displayName, it};
                this.logger.lifecycle("%1$s: %2$s", objectArray);
            }
        }

        public void err(@Nullable String line) {
            String string = line;
            if (string == null) {
                this.foundError = true;
                if (this.errors == null) {
                    this.errors = new StringBuilder();
                }
                this.future.set((Object)new Result.InternalAapt2Error(new IOException("AAPT2 process unexpectedly exit. Error output:\n" + this.errors)));
            } else if (Intrinsics.areEqual((Object)string, (Object)"Done")) {
                boolean bl5;
                if (this.foundError) {
                    StringBuilder stringBuilder = this.errors;
                    Intrinsics.checkNotNull((Object)stringBuilder);
                    String string2 = stringBuilder.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                    bl5 = this.future.set((Object)new Result.Failed(string2));
                } else if (this.errors != null) {
                    this.logger.warning(String.valueOf(this.errors), new Object[0]);
                    bl5 = this.future.set((Object)Result.Succeeded.INSTANCE);
                } else {
                    bl5 = this.future.set((Object)Result.Succeeded.INSTANCE);
                }
                this.errors = null;
            } else if (Intrinsics.areEqual((Object)string, (Object)"Error")) {
                this.foundError = true;
                if (this.errors == null) {
                    this.errors = new StringBuilder();
                }
            } else {
                if (this.errors == null) {
                    this.errors = new StringBuilder();
                }
                StringBuilder stringBuilder = this.errors;
                Intrinsics.checkNotNull((Object)stringBuilder);
                stringBuilder.append(line).append('\n');
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0004\u0005\u0006B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0003\u0007\b\t\u00a8\u0006\n"}, d2={"Lcom/android/builder/internal/aapt/v2/Aapt2DaemonImpl$WaitForTaskCompletion$Result;", "", "<init>", "()V", "Succeeded", "Failed", "InternalAapt2Error", "Lcom/android/builder/internal/aapt/v2/Aapt2DaemonImpl$WaitForTaskCompletion$Result$Failed;", "Lcom/android/builder/internal/aapt/v2/Aapt2DaemonImpl$WaitForTaskCompletion$Result$InternalAapt2Error;", "Lcom/android/builder/internal/aapt/v2/Aapt2DaemonImpl$WaitForTaskCompletion$Result$Succeeded;", "builder"})
        public static abstract class Result {
            private Result() {
            }

            public /* synthetic */ Result(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/android/builder/internal/aapt/v2/Aapt2DaemonImpl$WaitForTaskCompletion$Result$Failed;", "Lcom/android/builder/internal/aapt/v2/Aapt2DaemonImpl$WaitForTaskCompletion$Result;", "stdErr", "", "<init>", "(Ljava/lang/String;)V", "getStdErr", "()Ljava/lang/String;", "builder"})
            public static final class Failed
            extends Result {
                @NotNull
                private final String stdErr;

                public Failed(@NotNull String stdErr) {
                    Intrinsics.checkNotNullParameter((Object)stdErr, (String)"stdErr");
                    super(null);
                    this.stdErr = stdErr;
                }

                @NotNull
                public final String getStdErr() {
                    return this.stdErr;
                }
            }

            @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/android/builder/internal/aapt/v2/Aapt2DaemonImpl$WaitForTaskCompletion$Result$InternalAapt2Error;", "Lcom/android/builder/internal/aapt/v2/Aapt2DaemonImpl$WaitForTaskCompletion$Result;", "failure", "Ljava/io/IOException;", "<init>", "(Ljava/io/IOException;)V", "getFailure", "()Ljava/io/IOException;", "builder"})
            public static final class InternalAapt2Error
            extends Result {
                @NotNull
                private final IOException failure;

                public InternalAapt2Error(@NotNull IOException failure) {
                    Intrinsics.checkNotNullParameter((Object)failure, (String)"failure");
                    super(null);
                    this.failure = failure;
                }

                @NotNull
                public final IOException getFailure() {
                    return this.failure;
                }
            }

            @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/android/builder/internal/aapt/v2/Aapt2DaemonImpl$WaitForTaskCompletion$Result$Succeeded;", "Lcom/android/builder/internal/aapt/v2/Aapt2DaemonImpl$WaitForTaskCompletion$Result;", "<init>", "()V", "builder"})
            public static final class Succeeded
            extends Result {
                @NotNull
                public static final Succeeded INSTANCE = new Succeeded();

                private Succeeded() {
                    super(null);
                }
            }
        }
    }
}

