/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.aapt.v2;

import com.android.builder.internal.aapt.AaptConvertConfig;
import com.android.builder.internal.aapt.AaptException;
import com.android.builder.internal.aapt.AaptPackageConfig;
import com.android.builder.internal.aapt.AaptUtils;
import com.android.builder.packaging.PackagingUtils;
import com.android.ide.common.resources.CompileResourceRequest;
import com.android.utils.FileUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\u001a\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0006\u001a\u00020\t\u001a\u0016\u0010\n\u001a\u00020\u00022\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0002\u00a8\u0006\r"}, d2={"makeCompileCommand", "Lcom/google/common/collect/ImmutableList;", "", "request", "Lcom/android/ide/common/resources/CompileResourceRequest;", "makeLinkCommand", "config", "Lcom/android/builder/internal/aapt/AaptPackageConfig;", "makeConvertCommand", "Lcom/android/builder/internal/aapt/AaptConvertConfig;", "getNoCompressRegex", "noCompressList", "", "builder"})
@JvmName(name="AaptV2CommandBuilder")
@SourceDebugExtension(value={"SMAP\nAaptV2CommandBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AaptV2CommandBuilder.kt\ncom/android/builder/internal/aapt/v2/AaptV2CommandBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,387:1\n1869#2,2:388\n1056#2:393\n1869#2,2:394\n1056#2:399\n1869#2,2:400\n1761#2,3:402\n3829#3:390\n4344#3,2:391\n3829#3:396\n4344#3,2:397\n*S KotlinDebug\n*F\n+ 1 AaptV2CommandBuilder.kt\ncom/android/builder/internal/aapt/v2/AaptV2CommandBuilder\n*L\n115#1:388,2\n144#1:393\n145#1:394,2\n154#1:399\n155#1:400,2\n220#1:402,3\n143#1:390\n143#1:391,2\n153#1:396\n153#1:397,2\n*E\n"})
public final class AaptV2CommandBuilder {
    @NotNull
    public static final ImmutableList<String> makeCompileCommand(@NotNull CompileResourceRequest request) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        ImmutableList.Builder parameters = new ImmutableList.Builder();
        if (request.isPseudoLocalize()) {
            parameters.add((Object)"--pseudo-localize");
        }
        if (!request.isPngCrunching()) {
            String string = request.getInputFile().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            String string2 = string;
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string3 = string2.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            String lowerName = string3;
            if (StringsKt.endsWith$default((String)lowerName, (String)".png", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)lowerName, (String)".9.png", (boolean)false, (int)2, null)) {
                parameters.add((Object)"--no-crunch");
            }
        }
        if (request.getPartialRFile() != null) {
            objectArray = new String[2];
            objectArray[0] = "--output-text-symbols";
            File file = request.getPartialRFile();
            Intrinsics.checkNotNull((Object)file);
            objectArray[1] = file.getAbsolutePath();
            parameters.add(objectArray);
        }
        parameters.add((Object)"--legacy");
        objectArray = new String[]{"-o", request.getOutputDirectory().getAbsolutePath()};
        parameters.add(objectArray);
        parameters.add((Object)request.getInputFile().getAbsolutePath());
        String it = request.getSourcePath();
        boolean bl5 = false;
        parameters.add((Object)"--source-path");
        parameters.add((Object)it);
        ImmutableList immutableList = parameters.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"build(...)");
        return immutableList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public static final ImmutableList<String> makeLinkCommand(@NotNull AaptPackageConfig config) throws AaptException {
        Object[] objectArray;
        Object[] joiner;
        Iterable<String> densityResSplits;
        List<String> additionalParameters;
        Object[] split;
        Object[] resourceListFile;
        File resourceOutputApk;
        ImmutableList.Builder builder;
        block65: {
            Object object;
            ImmutableList.Builder builder2;
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            builder = ImmutableList.builder();
            if (config.getVerbose()) {
                builder.add((Object)"-v");
            }
            if (config.getGenerateProtos()) {
                builder.add((Object)"--proto-format");
            }
            if (config.getExcludeSources()) {
                if (!config.getGenerateProtos()) {
                    throw new AaptException("AAPT2 only supports excluding sources when building for a bundle.");
                }
                builder.add((Object)"--exclude-sources");
            }
            if (config.getMergeOnly()) {
                builder2 = builder.add((Object)"--merge-only");
            } else {
                Object[] objectArray2 = new String[2];
                objectArray2[0] = "-I";
                Intrinsics.checkNotNull((Object)config.getAndroidJarPath());
                builder2 = builder.add(objectArray2);
            }
            Iterable $this$forEach$iv = (Iterable)config.getImports();
            boolean $i$f$forEach22 = false;
            for (Object element$iv : $this$forEach$iv) {
                File file = (File)element$iv;
                boolean bl5 = false;
                object = new String[]{"-I", file.getAbsolutePath()};
                builder.add(object);
            }
            File manifestFile = config.getManifestFile();
            Preconditions.checkNotNull((Object)manifestFile);
            Object[] $i$f$forEach22 = new String[]{"--manifest", manifestFile.getAbsolutePath()};
            builder.add($i$f$forEach22);
            resourceOutputApk = config.getResourceOutputApk();
            FileUtils.mkdirs((File)resourceOutputApk.getParentFile());
            Object[] objectArray3 = new String[]{"-o", resourceOutputApk.getAbsolutePath()};
            builder.add(objectArray3);
            if (!config.getResourceDirs().isEmpty()) {
                try {
                    if (config.isListResourceFiles()) {
                        Object element$iv;
                        File file = config.getIntermediateDir();
                        Intrinsics.checkNotNull((Object)file);
                        resourceListFile = new File(file, "resources-list-for-" + resourceOutputApk.getName() + ".txt");
                        FileUtils.deleteIfExists((File)resourceListFile);
                        Files.createDirectories(config.getIntermediateDir().toPath(), new FileAttribute[0]);
                        UnmodifiableIterator unmodifiableIterator = config.getResourceDirs().iterator();
                        Intrinsics.checkNotNullExpressionValue((Object)unmodifiableIterator, (String)"iterator(...)");
                        element$iv = unmodifiableIterator;
                        while (element$iv.hasNext()) {
                            File dir = (File)element$iv.next();
                            Closeable bl5 = new FileOutputStream((File)resourceListFile);
                            object = null;
                            try {
                                FileOutputStream fos = (FileOutputStream)bl5;
                                boolean bl6 = false;
                                Closeable closeable = new PrintWriter(fos);
                                Throwable throwable = null;
                                try {
                                    void $this$forEach$iv2;
                                    Iterable $this$sortedBy$iv;
                                    void $this$filterTo$iv$iv;
                                    Iterable $this$filter$iv;
                                    PrintWriter pw4 = (PrintWriter)closeable;
                                    boolean bl7 = false;
                                    Intrinsics.checkNotNull((Object)dir.listFiles());
                                    boolean $i$f$filter = false;
                                    Iterator iterator = $this$filter$iv;
                                    Collection destination$iv$iv = new ArrayList();
                                    boolean $i$f$filterTo = false;
                                    int n15 = ((void)$this$filterTo$iv$iv).length;
                                    for (int i15 = 0; i15 < n15; ++i15) {
                                        void element$iv$iv;
                                        void it = element$iv$iv = $this$filterTo$iv$iv[i15];
                                        boolean bl8 = false;
                                        if (!it.isFile()) continue;
                                        destination$iv$iv.add(element$iv$iv);
                                    }
                                    $this$filter$iv = (List)destination$iv$iv;
                                    boolean $i$f$sortedBy = false;
                                    $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                                        public final int compare(T a15, T b15) {
                                            File it = (File)a15;
                                            boolean bl5 = false;
                                            Comparable comparable = (Comparable)((Object)it.getPath());
                                            it = (File)b15;
                                            Comparable comparable2 = comparable;
                                            bl5 = false;
                                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getPath())));
                                        }
                                    });
                                    boolean $i$f$forEach = false;
                                    for (Object element$iv2 : $this$forEach$iv2) {
                                        File it = (File)element$iv2;
                                        boolean bl9 = false;
                                        pw4.print(it.getAbsolutePath() + " ");
                                    }
                                    pw4 = Unit.INSTANCE;
                                }
                                catch (Throwable bl7) {
                                    throwable = bl7;
                                    throw bl7;
                                }
                                finally {
                                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                                }
                                fos = Unit.INSTANCE;
                            }
                            catch (Throwable bl6) {
                                object = bl6;
                                throw bl6;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)bl5, (Throwable)object);
                            }
                        }
                        element$iv = new String[]{"-R", "@" + resourceListFile.getAbsolutePath()};
                        builder.add(element$iv);
                        break block65;
                    }
                    String[] stringArray = config.getResourceDirs().iterator();
                    Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"iterator(...)");
                    resourceListFile = stringArray;
                    while (resourceListFile.hasNext()) {
                        void $this$forEach$iv3;
                        Iterable $this$sortedBy$iv;
                        Iterator $this$filterTo$iv$iv;
                        Iterable $this$filter$iv;
                        File dir = (File)resourceListFile.next();
                        Intrinsics.checkNotNull((Object)dir.listFiles());
                        boolean $i$f$filter = false;
                        object = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$filterTo = false;
                        for (String element$iv$iv : $this$filterTo$iv$iv) {
                            void it = element$iv$iv;
                            boolean bl10 = false;
                            if (!it.isFile()) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $this$filter$iv = (List)destination$iv$iv;
                        boolean $i$f$sortedBy = false;
                        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                            public final int compare(T a15, T b15) {
                                File it = (File)a15;
                                boolean bl5 = false;
                                Comparable comparable = (Comparable)((Object)it.getPath());
                                it = (File)b15;
                                Comparable comparable2 = comparable;
                                bl5 = false;
                                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getPath())));
                            }
                        });
                        boolean $i$f$forEach = false;
                        $this$filterTo$iv$iv = $this$forEach$iv3.iterator();
                        while ($this$filterTo$iv$iv.hasNext()) {
                            Object element$iv = $this$filterTo$iv$iv.next();
                            File it = (File)element$iv;
                            boolean bl11 = false;
                            Object[] objectArray4 = new String[]{"-R", it.getAbsolutePath()};
                            builder.add(objectArray4);
                        }
                    }
                }
                catch (IOException e15) {
                    throw new AaptException("Failed to walk paths " + Joiner.on((char)File.pathSeparatorChar).join((Iterable)config.getResourceDirs()), e15);
                }
            }
        }
        builder.add((Object)"--auto-add-overlay");
        if (config.getSourceOutputDir() != null) {
            resourceListFile = new String[]{"--java", config.getSourceOutputDir().getAbsolutePath()};
            builder.add(resourceListFile);
        }
        if (config.getProguardOutputFile() != null) {
            resourceListFile = new String[]{"--proguard", config.getProguardOutputFile().getAbsolutePath()};
            builder.add(resourceListFile);
        }
        if (config.getMainDexListProguardOutputFile() != null) {
            resourceListFile = new String[]{"--proguard-main-dex", config.getMainDexListProguardOutputFile().getAbsolutePath()};
            builder.add(resourceListFile);
        }
        if (config.getSplits() != null) {
            UnmodifiableIterator unmodifiableIterator = config.getSplits().iterator();
            Intrinsics.checkNotNullExpressionValue((Object)unmodifiableIterator, (String)"iterator(...)");
            resourceListFile = unmodifiableIterator;
            while (resourceListFile.hasNext()) {
                split = (Object[])resourceListFile.next();
                String splitter = File.pathSeparator;
                Object[] $i$f$forEach = new String[]{"--split", resourceOutputApk + "_" + (String)split + splitter + (String)split};
                builder.add($i$f$forEach);
            }
        }
        if (!config.getComponentType().isNestedComponent() && config.getCustomPackageForR() != null) {
            resourceListFile = new String[]{"--custom-package", config.getCustomPackageForR()};
            builder.add(resourceListFile);
        }
        boolean generateFinalIds = true;
        if (config.getComponentType().isAar()) {
            generateFinalIds = false;
        }
        if (!generateFinalIds) {
            builder.add((Object)"--non-final-ids");
        }
        split = new String[]{"-0", "apk"};
        builder.add(split);
        Collection<String> noCompressList = Objects.requireNonNull(config.getOptions()).getNoCompress();
        if (noCompressList != null && !noCompressList.isEmpty()) {
            ImmutableList.Builder builder3;
            boolean bl12;
            Object[] $this$any$iv;
            block66: {
                $this$any$iv = (Object[])noCompressList;
                boolean $i$f$any = false;
                if (((Collection)$this$any$iv).isEmpty()) {
                    bl12 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl13 = false;
                        if (!Strings.isNullOrEmpty((String)it)) continue;
                        bl12 = true;
                        break block66;
                    }
                    bl12 = false;
                }
            }
            if (bl12) {
                builder3 = builder.add((Object)"--no-compress");
            } else {
                $this$any$iv = new String[]{"--no-compress-regex", AaptV2CommandBuilder.getNoCompressRegex(noCompressList)};
                builder3 = builder.add($this$any$iv);
            }
        }
        if ((additionalParameters = config.getOptions().getAdditionalParameters()) != null) {
            builder.addAll((Iterable)additionalParameters);
        }
        ArrayList resourceConfigs = new ArrayList((Collection)config.getResourceConfigs());
        ArrayList densityResourceConfigs = Lists.newArrayList(AaptUtils.getDensityResConfigs(resourceConfigs));
        ArrayList otherResourceConfigs = Lists.newArrayList(AaptUtils.getNonDensityResConfigs(resourceConfigs));
        String preferredDensity = config.getPreferredDensity();
        Iterable<String> iterable = densityResSplits = config.getSplits() != null ? AaptUtils.getDensityResConfigs((Iterable)config.getSplits()) : (Iterable<String>)ImmutableList.of();
        if (preferredDensity != null || densityResSplits.iterator().hasNext()) {
            Intrinsics.checkNotNull((Object)densityResourceConfigs);
            if (!((Collection)densityResourceConfigs).isEmpty()) {
                String element$iv$iv;
                element$iv$iv = "When using splits in tools 21 and above, resConfigs should not contain any densities. Right now, it contains \"%1$s\"\nSuggestion: remove these from resConfigs from build.gradle";
                Object[] it = new Object[]{Joiner.on((String)"\",\"").join((Iterable)densityResourceConfigs)};
                String string = String.format(element$iv$iv, Arrays.copyOf(it, it.length));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
                throw new AaptException(string);
            }
        }
        if (densityResourceConfigs.size() > 1) {
            throw new AaptException("Cannot filter assets for multiple densities using SDK build tools 21 or later. Consider using apk splits instead.");
        }
        Intrinsics.checkNotNull((Object)otherResourceConfigs);
        if (!((Collection)otherResourceConfigs).isEmpty() && config.getSplits() != null) {
            Iterable<String> nonDensitySplits = AaptUtils.getNonDensityResConfigs((Iterable)config.getSplits());
            otherResourceConfigs.addAll(Lists.newArrayList(nonDensitySplits));
        }
        if (preferredDensity == null && densityResourceConfigs.size() == 1) {
            preferredDensity = (String)Iterables.getOnlyElement((Iterable)densityResourceConfigs);
        }
        ArrayList<String> localeFilters = new ArrayList<String>((Collection)config.getLocaleFilters());
        if (!((Collection)otherResourceConfigs).isEmpty() || !((Collection)localeFilters).isEmpty()) {
            joiner = Joiner.on((char)',');
            if (config.getPseudoLocalesEnabled()) {
                localeFilters.add("en-rXA");
                localeFilters.add("ar-rXB");
            }
            Object[] it = new String[]{"-c", joiner.join((Iterable)CollectionsKt.plus((Collection)otherResourceConfigs, (Iterable)localeFilters))};
            builder.add(it);
        }
        if (preferredDensity != null) {
            joiner = new String[]{"--preferred-density", preferredDensity};
            builder.add(joiner);
        }
        if (config.getSymbolOutputDir() != null) {
            File rDotTxt = new File(config.getSymbolOutputDir(), "R.txt");
            Object[] it = new String[]{"--output-text-symbols", rDotTxt.getAbsolutePath()};
            builder.add(it);
        }
        if (config.getPackageId() != null) {
            if (config.getAllowReservedPackageId()) {
                builder.add((Object)"--allow-reserved-package-id");
            }
            objectArray = new String[]{"--package-id", "0x" + Integer.toHexString(config.getPackageId())};
            builder.add(objectArray);
            UnmodifiableIterator unmodifiableIterator = config.getDependentFeatures().iterator();
            Intrinsics.checkNotNullExpressionValue((Object)unmodifiableIterator, (String)"iterator(...)");
            objectArray = unmodifiableIterator;
            while (objectArray.hasNext()) {
                File dependentFeature = (File)objectArray.next();
                Object[] objectArray5 = new String[]{"-I", dependentFeature.getAbsolutePath()};
                builder.add(objectArray5);
            }
        } else if (!config.getDependentFeatures().isEmpty()) {
            throw new AaptException("Dependent features configured but no package ID was set.");
        }
        builder.add((Object)"--no-version-vectors");
        if (config.getUseConditionalKeepRules()) {
            builder.add((Object)"--proguard-conditional-keep-rules");
        }
        if (config.getUseMinimalKeepRules()) {
            builder.add((Object)"--proguard-minimal-keep-rules");
        }
        if (config.isStaticLibrary()) {
            builder.add((Object)"--static-lib");
            if (!config.getStaticLibraryDependencies().isEmpty()) {
                throw new AaptException("Static libraries to link against should be passed as imports");
            }
        } else {
            Object[] objectArray6 = config.getStaticLibraryDependencies().iterator();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray6, (String)"iterator(...)");
            objectArray = objectArray6;
            while (objectArray.hasNext()) {
                File file = (File)objectArray.next();
                builder.add((Object)file.getAbsolutePath());
            }
        }
        builder.add((Object)"--no-proguard-location-reference");
        if (config.getEmitStableIdsFile() != null) {
            objectArray = new String[]{"--emit-ids", config.getEmitStableIdsFile().getAbsolutePath()};
            builder.add(objectArray);
        }
        if (config.getConsumeStableIdsFile() != null) {
            objectArray = new String[]{"--stable-ids", config.getConsumeStableIdsFile().getAbsolutePath()};
            builder.add(objectArray);
        }
        ImmutableList immutableList = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"build(...)");
        return immutableList;
    }

    @NotNull
    public static final ImmutableList<String> makeConvertCommand(@NotNull AaptConvertConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)"--output-format");
        ImmutableList.Builder builder2 = config.getConvertToProtos() ? builder.add((Object)"proto") : builder.add((Object)"binary");
        FileUtils.mkdirs((File)config.getOutputFile().getParentFile());
        builder.add((Object)"-o").add((Object)config.getOutputFile().getAbsolutePath());
        builder.add((Object)config.getInputFile().getAbsolutePath());
        ImmutableList immutableList = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"build(...)");
        return immutableList;
    }

    private static final String getNoCompressRegex(Collection<String> noCompressList) {
        return "((" + Joiner.on((String)"$)|(").join((Iterable)PackagingUtils.getNoCompressForAapt(noCompressList)) + "$))";
    }
}

