/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.packaging;

import com.android.builder.files.RelativeFile;
import com.android.builder.internal.packaging.PackagedFileUpdate;
import com.android.builder.packaging.DexFileNameSupplier;
import com.android.builder.packaging.DexRelativeFileComparator;
import com.android.ide.common.resources.FileStatus;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;

class DexIncrementalRenameManager
implements Closeable {
    private static final String STATE_FILE = "dex-renamer-state.txt";
    private static final String FILE_KEY_PREFIX = "base.";
    private static final String RELATIVE_PATH_PREFIX = "path.";
    private static final String RENAMED_KEY_PREFIX = "renamed.";
    private final BiMap<RelativeFile, String> mNameMap;
    private final File mIncrementalDir;
    private boolean mClosed;

    DexIncrementalRenameManager(File incrementalDir) throws IOException {
        Preconditions.checkArgument((boolean)incrementalDir.isDirectory(), (Object)"!incrementalDir.isDirectory()");
        this.mNameMap = HashBiMap.create();
        this.mIncrementalDir = incrementalDir;
        this.mClosed = false;
        this.readState();
    }

    private void readState() throws IOException {
        File stateFile = new File(this.mIncrementalDir, STATE_FILE);
        if (!stateFile.isFile()) {
            return;
        }
        Properties props = new Properties();
        try (Closer closer = Closer.create();){
            props.load((Reader)closer.register((Closeable)new FileReader(stateFile)));
        }
        int i15 = 0;
        while (true) {
            String fileKey = FILE_KEY_PREFIX + i15;
            String relativePathKey = RELATIVE_PATH_PREFIX + i15;
            String renamedKey = RENAMED_KEY_PREFIX + i15;
            String file = props.getProperty(fileKey);
            String relativePath = props.getProperty(relativePathKey);
            String rename = props.getProperty(renamedKey);
            if (file == null || relativePath == null || rename == null) break;
            RelativeFile rf5 = RelativeFile.fileInDirectory(relativePath, new File(file));
            this.mNameMap.put((Object)rf5, (Object)rename);
            ++i15;
        }
    }

    private void writeState() throws IOException {
        File stateFile = new File(this.mIncrementalDir, STATE_FILE);
        Properties props = new Properties();
        int currIdx = 0;
        for (Map.Entry entry : this.mNameMap.entrySet()) {
            props.put(FILE_KEY_PREFIX + currIdx, ((RelativeFile)entry.getKey()).getFile().getAbsolutePath());
            props.put(RELATIVE_PATH_PREFIX + currIdx, ((RelativeFile)entry.getKey()).getRelativePath());
            props.put(RENAMED_KEY_PREFIX + currIdx, entry.getValue());
            ++currIdx;
        }
        try (Closer closer = Closer.create();){
            props.store((Writer)closer.register((Closeable)new FileWriter(stateFile)), null);
        }
    }

    Set<PackagedFileUpdate> update(Map<RelativeFile, FileStatus> files) throws IOException {
        Deque newFiles = files.entrySet().stream().filter(e15 -> e15.getValue() == FileStatus.NEW).map(Map.Entry::getKey).sorted(DexRelativeFileComparator.INSTANCE).collect(Collectors.toCollection(LinkedList::new));
        DexFileNameSupplier supplier = new DexFileNameSupplier();
        ArrayList<Bucket> buckets = new ArrayList<Bucket>();
        for (int i15 = 0; i15 < this.mNameMap.size(); ++i15) {
            String nameInDex = supplier.get();
            RelativeFile rf5 = (RelativeFile)this.mNameMap.inverse().get((Object)nameInDex);
            Verify.verify((rf5 != null ? 1 : 0) != 0, (String)"No file known for: %s\nKnown maps: %s", (Object)nameInDex, this.mNameMap);
            if (nameInDex.equals("classes.dex") && !DexIncrementalRenameManager.getOsIndependentFileName(rf5).equals("classes.dex") && !newFiles.isEmpty() && DexIncrementalRenameManager.getOsIndependentFileName((RelativeFile)newFiles.getFirst()).equals("classes.dex")) {
                Verify.verify((i15 == 0 ? 1 : 0) != 0);
                buckets.add(new Bucket((RelativeFile)newFiles.removeFirst(), nameInDex, BucketAction.UPDATE));
                newFiles.add(rf5);
                continue;
            }
            Bucket newBucket = new Bucket(rf5, nameInDex, BucketAction.NOTHING);
            FileStatus status = files.get(rf5);
            if (status == FileStatus.REMOVED) {
                if (newFiles.isEmpty()) {
                    newBucket.file = rf5;
                    newBucket.action = BucketAction.DELETE;
                } else {
                    newBucket.file = (RelativeFile)newFiles.removeFirst();
                    newBucket.action = BucketAction.UPDATE;
                }
            } else if (status == FileStatus.CHANGED) {
                newBucket.file = rf5;
                newBucket.action = BucketAction.UPDATE;
            }
            buckets.add(newBucket);
        }
        if (newFiles.isEmpty()) {
            int emp = 0;
            int use = buckets.size() - 1;
            while (true) {
                if (emp < buckets.size() && ((Bucket)buckets.get((int)emp)).action != BucketAction.DELETE) {
                    ++emp;
                    continue;
                }
                while (use >= 0 && ((Bucket)buckets.get((int)use)).action == BucketAction.DELETE) {
                    --use;
                }
                if (emp <= use) {
                    ((Bucket)buckets.get((int)emp)).file = ((Bucket)buckets.get((int)use)).file;
                    ((Bucket)buckets.get((int)emp)).action = BucketAction.UPDATE;
                    ((Bucket)buckets.get((int)use)).action = BucketAction.DELETE;
                    ++emp;
                    --use;
                    continue;
                }
                break;
            }
        } else {
            newFiles.forEach(nf5 -> buckets.add(new Bucket((RelativeFile)nf5, supplier.get(), BucketAction.CREATE)));
        }
        this.mNameMap.clear();
        return buckets.stream().peek(b15 -> {
            if (b15.action != BucketAction.DELETE) {
                this.mNameMap.put((Object)b15.file, (Object)b15.nameInDex);
            }
        }).map(b15 -> {
            switch (b15.action) {
                case CREATE: {
                    return new PackagedFileUpdate(b15.file, b15.nameInDex, FileStatus.NEW);
                }
                case DELETE: {
                    return new PackagedFileUpdate(b15.file, b15.nameInDex, FileStatus.REMOVED);
                }
                case NOTHING: {
                    return null;
                }
                case UPDATE: {
                    return new PackagedFileUpdate(b15.file, b15.nameInDex, FileStatus.CHANGED);
                }
            }
            throw new AssertionError();
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Override
    public void close() throws IOException {
        if (this.mClosed) {
            return;
        }
        this.mClosed = true;
        this.writeState();
    }

    private static String getOsIndependentFileName(RelativeFile file) {
        String[] pathSplit = file.getRelativePath().split("/");
        return pathSplit[pathSplit.length - 1];
    }

    private static class Bucket {
        RelativeFile file;
        String nameInDex;
        BucketAction action;

        Bucket(RelativeFile file, String nameInDex, BucketAction action) {
            this.file = file;
            this.nameInDex = nameInDex;
            this.action = action;
        }
    }

    private static enum BucketAction {
        NOTHING,
        UPDATE,
        DELETE,
        CREATE;

    }
}

