/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.splitters;

import com.android.aapt.Resources;
import com.android.bundle.Files;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.manifest.AndroidManifest;
import com.android.tools.build.bundletool.model.BundleModuleName;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.splitters.ModuleSplitMerger;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimaps;
import java.util.List;
import java.util.Optional;

public class SameTargetingMerger
implements ModuleSplitMerger {
    @Override
    public ImmutableCollection<ModuleSplit> merge(ImmutableCollection<ModuleSplit> moduleSplits) {
        ImmutableList.Builder result = new ImmutableList.Builder();
        ImmutableListMultimap splitsByTargeting = Multimaps.index(moduleSplits, ModuleSplit::getTargeting);
        for (Targeting.SplitTargeting targeting : splitsByTargeting.keySet()) {
            result.add((Object)this.mergeSplits((ImmutableCollection<ModuleSplit>)splitsByTargeting.get((Object)targeting)));
        }
        return result.build();
    }

    private ModuleSplit mergeSplits(ImmutableCollection<ModuleSplit> splits) {
        ModuleSplit.Builder builder = ModuleSplit.builder();
        ImmutableList.Builder entries = new ImmutableList.Builder();
        AndroidManifest mergedManifest = null;
        Resources.ResourceTable mergedResourceTable = null;
        Files.NativeLibraries mergedNativeConfig = null;
        BundleModuleName mergedModuleName = null;
        for (ModuleSplit split : splits) {
            if (split.getAndroidManifest().isPresent()) {
                mergedManifest = this.merge(mergedManifest, split.getAndroidManifest().get()).orElseThrow(() -> new IllegalStateException("Encountered two distinct manifests while merging."));
            }
            if (split.getResourceTable().isPresent()) {
                mergedResourceTable = this.merge(mergedResourceTable, split.getResourceTable().get()).orElseThrow(() -> new IllegalStateException("Unsupported case: encountered two distinct resource tables while merging."));
            }
            if (split.getNativeConfig().isPresent()) {
                mergedNativeConfig = this.merge(mergedNativeConfig, split.getNativeConfig().get()).orElseThrow(() -> new IllegalStateException("Encountered two distinct native configs while merging."));
            }
            mergedModuleName = this.merge(mergedModuleName, split.getModuleName()).orElseThrow(() -> new IllegalStateException("Encountered two distinct module names while merging."));
            entries.addAll(split.getEntries());
            builder.setTargeting(split.getTargeting());
        }
        if (mergedManifest != null) {
            builder.setAndroidManifest(mergedManifest);
        }
        if (mergedResourceTable != null) {
            builder.setResourceTable(mergedResourceTable);
        }
        if (mergedNativeConfig != null) {
            builder.setNativeConfig(mergedNativeConfig);
        }
        if (mergedModuleName != null) {
            builder.setModuleName(mergedModuleName);
        }
        builder.setEntries((List<ModuleEntry>)entries.build());
        return builder.build();
    }

    private <T> Optional<T> merge(T mergedValue, T readValue) {
        if (mergedValue == null || readValue.equals(mergedValue)) {
            return Optional.of(readValue);
        }
        return Optional.empty();
    }
}

