/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.utils.flags;

import com.android.tools.build.bundletool.utils.flags.AutoValue_ParsedFlags;
import com.android.tools.build.bundletool.utils.flags.FlagParser;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

@AutoValue
public abstract class ParsedFlags {
    private final Set<String> accessedFlags = new HashSet<String>();

    static ParsedFlags create(List<String> commands, ImmutableMap<String, String> flags) {
        return new AutoValue_ParsedFlags(commands, flags);
    }

    public abstract List<String> getCommands();

    protected abstract ImmutableMap<String, String> getFlags();

    Optional<String> getFlagValue(String name) {
        this.accessedFlags.add(name);
        return Optional.ofNullable(this.getFlags().get((Object)name));
    }

    public void checkNoUnknownFlags() {
        Sets.SetView unknownFlags = Sets.difference((Set)this.getFlags().keySet(), this.accessedFlags);
        if (!unknownFlags.isEmpty()) {
            throw new UnknownFlagsException((Collection<String>)unknownFlags);
        }
    }

    public static class UnknownFlagsException
    extends FlagParser.FlagParseException {
        public UnknownFlagsException(Collection<String> flags) {
            super("Unrecognized flags: " + flags.stream().map(f -> "--" + f).collect(Collectors.joining(", ")));
        }
    }
}

