/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.bundle.Files;
import com.android.tools.build.bundletool.exceptions.ValidationException;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.validation.BundleValidationUtils;
import com.android.tools.build.bundletool.validation.SubValidator;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;

public class AssetsTargetingValidator
extends SubValidator {
    @Override
    public void validateModule(BundleModule module) {
        module.getAssetsConfig().ifPresent(targeting -> this.validateTargeting(module, (Files.Assets)targeting));
    }

    private void validateTargeting(BundleModule module, Files.Assets assets) {
        ArrayList<String> targetedDirs = new ArrayList<String>();
        for (Files.AssetsDirectoryGroup directoryGroup : assets.getDirectoryGroupList()) {
            for (Files.TargetedAssetsDirectory targetedDirectory : directoryGroup.getTargetedDirectoryList()) {
                Path path = Paths.get(targetedDirectory.getPath(), new String[0]);
                if (!path.startsWith(BundleModule.ASSETS_DIRECTORY) || path.getNameCount() != 2) {
                    throw new ValidationException("Path of targeted assets directory must be in format 'assets/<directory>', found '%s'.", path);
                }
                if (BundleValidationUtils.directoryContainsNoFiles(module, path)) {
                    throw new ValidationException("Targeted directory '%s' is empty.", path);
                }
                targetedDirs.add(path.toString());
            }
        }
        BundleValidationUtils.checkNonOverlappingPathsAcrossDirectoryGroups(targetedDirs);
    }
}

