/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model;

import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.model.utils.EnumMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;

public enum AbiName {
    ARMEABI("armeabi"),
    ARMEABI_V7A("armeabi-v7a"),
    ARM64_V8A("arm64-v8a"),
    X86("x86"),
    X86_64("x86_64"),
    MIPS("mips"),
    MIPS64("mips64");

    private final String platformName;
    private static final ImmutableBiMap<Targeting.Abi.AbiAlias, AbiName> ABI_ALIAS_TO_ABI_NAME_MAP;
    private static final ImmutableMap<String, AbiName> PLATFORM_NAME_TO_ABI_NAME_MAP;

    private AbiName(String platformName) {
        this.platformName = platformName;
    }

    public String getPlatformName() {
        return this.platformName;
    }

    public Targeting.Abi.AbiAlias toProto() {
        return (Targeting.Abi.AbiAlias)((Object)ABI_ALIAS_TO_ABI_NAME_MAP.inverse().get((Object)this));
    }

    public static AbiName fromProto(Targeting.Abi.AbiAlias abiAlias) {
        return (AbiName)((Object)Preconditions.checkNotNull((Object)ABI_ALIAS_TO_ABI_NAME_MAP.get((Object)abiAlias), (String)"Unrecognized ABI '%s'.", (Object)((Object)abiAlias)));
    }

    public static Optional<AbiName> fromPlatformName(String platformAbiName) {
        return Optional.ofNullable(PLATFORM_NAME_TO_ABI_NAME_MAP.get((Object)platformAbiName));
    }

    public static ImmutableSet<String> getAllPlatformAbis() {
        return (ImmutableSet)Stream.of(AbiName.values()).map(AbiName::getPlatformName).collect(ImmutableSet.toImmutableSet());
    }

    static {
        ABI_ALIAS_TO_ABI_NAME_MAP = EnumMapper.mapByName(Targeting.Abi.AbiAlias.class, AbiName.class, ImmutableSet.of((Object)((Object)Targeting.Abi.AbiAlias.UNRECOGNIZED), (Object)((Object)Targeting.Abi.AbiAlias.UNSPECIFIED_CPU_ARCHITECTURE)));
        PLATFORM_NAME_TO_ABI_NAME_MAP = (ImmutableMap)Arrays.stream(AbiName.values()).collect(ImmutableMap.toImmutableMap(AbiName::getPlatformName, Function.identity()));
    }
}

