/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.splitters;

import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.splitters.ApkGenerationConfiguration;
import com.android.tools.build.bundletool.splitters.ModuleSplitSplitter;
import com.android.tools.build.bundletool.splitters.SplittingPipeline;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;

public class RemoteAssetModuleSplitter {
    private final BundleModule module;
    private final ApkGenerationConfiguration apkGenerationConfiguration;

    public RemoteAssetModuleSplitter(BundleModule module, ApkGenerationConfiguration apkGenerationConfiguration) {
        this.module = (BundleModule)Preconditions.checkNotNull((Object)module);
        this.apkGenerationConfiguration = (ApkGenerationConfiguration)Preconditions.checkNotNull((Object)apkGenerationConfiguration);
    }

    public ImmutableList<ModuleSplit> splitModule() {
        ImmutableList.Builder splits = ImmutableList.builder();
        SplittingPipeline assetsPipeline = this.createAssetsSplittingPipeline();
        splits.addAll(assetsPipeline.split(ModuleSplit.fromAssetBundleModule(this.module)));
        return splits.build();
    }

    private SplittingPipeline createAssetsSplittingPipeline() {
        ImmutableList.Builder assetsSplitters = ImmutableList.builder();
        return new SplittingPipeline((ImmutableList<ModuleSplitSplitter>)assetsSplitters.build());
    }
}

