/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.model.AndroidManifest;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ManifestDeliveryElement;
import com.android.tools.build.bundletool.model.ModuleConditions;
import com.android.tools.build.bundletool.model.exceptions.ValidationException;
import com.android.tools.build.bundletool.model.exceptions.manifest.ManifestDuplicateAttributeException;
import com.android.tools.build.bundletool.model.exceptions.manifest.ManifestFusingException;
import com.android.tools.build.bundletool.model.exceptions.manifest.ManifestSdkTargetingException;
import com.android.tools.build.bundletool.model.exceptions.manifest.ManifestVersionCodeConflictException;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoAttribute;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoElement;
import com.android.tools.build.bundletool.validation.SubValidator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;

public class AndroidManifestValidator
extends SubValidator {
    @Override
    public void validateAllModules(ImmutableList<BundleModule> modules) {
        this.validateSameVersionCode(modules);
        this.validateInstant(modules);
        this.validateNoVersionCodeInAssetModules(modules);
    }

    public void validateSameVersionCode(ImmutableList<BundleModule> modules) {
        ImmutableList versionCodes = (ImmutableList)modules.stream().map(BundleModule::getAndroidManifest).filter(manifest -> !manifest.getModuleType().equals((Object)BundleModule.ModuleType.ASSET_MODULE)).map(AndroidManifest::getVersionCode).distinct().sorted().collect(ImmutableList.toImmutableList());
        if (versionCodes.size() > 1) {
            throw new ManifestVersionCodeConflictException((Integer[])versionCodes.toArray((Object[])new Integer[0]));
        }
    }

    private void validateNoVersionCodeInAssetModules(ImmutableList<BundleModule> modules) {
        Optional<BundleModule> assetModuleWithVersionCode = modules.stream().filter(module -> module.getModuleType().equals((Object)BundleModule.ModuleType.ASSET_MODULE) && ((XmlProtoElement)module.getAndroidManifest().getManifestRoot().getElement()).getAndroidAttribute(16843291).isPresent()).findFirst();
        if (assetModuleWithVersionCode.isPresent()) {
            throw ValidationException.builder().withMessage("Asset packs cannot specify a version code, but '%s' does.", assetModuleWithVersionCode.get().getName()).build();
        }
    }

    @Override
    public void validateModule(BundleModule module) {
        this.validateInstant(module);
        this.validateDeliverySettings(module);
        this.validateInstantDeliverySettings(module);
        this.validateFusingConfig(module);
        this.validateMinMaxSdk(module);
        this.validateNumberOfDistinctSplitIds(module);
        this.validateOnDemandIsInstantMutualExclusion(module);
        this.validateAssetModuleManifest(module);
        this.validateMinSdkCondition(module);
        this.validateNoConditionalTargetingInAssetModules(module);
        this.validateInstantAndPersistentDeliveryCombinationsForAssetModules(module);
    }

    private void validateInstant(ImmutableList<BundleModule> modules) {
        BundleModule baseModule = modules.stream().filter(BundleModule::isBaseModule).findFirst().orElseThrow(() -> new ValidationException("App Bundle does not contain a mandatory 'base' module."));
        if (modules.stream().anyMatch(BundleModule::isInstantModule) && !baseModule.isInstantModule()) {
            throw ValidationException.builder().withMessage("App Bundle contains instant modules but the 'base' module is not marked 'instant'.").build();
        }
    }

    private void validateInstant(BundleModule module) {
        Optional<Integer> maxSdk;
        AndroidManifest manifest = module.getAndroidManifest();
        Optional<Boolean> isInstantModule = manifest.isInstantModule();
        if (isInstantModule.orElse(false).booleanValue() && (maxSdk = manifest.getMaxSdkVersion()).isPresent() && maxSdk.get() < 21) {
            throw new ManifestSdkTargetingException.MaxSdkLessThanMinInstantSdk(maxSdk.get());
        }
    }

    private void validateDeliverySettings(BundleModule module) {
        boolean deliveryTypeDeclared = module.getAndroidManifest().isDeliveryTypeDeclared();
        BundleModule.ModuleDeliveryType deliveryType = module.getDeliveryType();
        if (module.getAndroidManifest().getOnDemandAttribute().isPresent() && module.getAndroidManifest().getManifestDeliveryElement().isPresent()) {
            throw ValidationException.builder().withMessage("Module '%s' cannot use <dist:delivery> settings and legacy dist:onDemand attribute at the same time", module.getName()).build();
        }
        if (module.isBaseModule()) {
            if (deliveryType.equals((Object)BundleModule.ModuleDeliveryType.NO_INITIAL_INSTALL)) {
                throw new ValidationException("The base module cannot be marked on-demand since it will always be served.");
            }
            if (deliveryType.equals((Object)BundleModule.ModuleDeliveryType.CONDITIONAL_INITIAL_INSTALL)) {
                throw new ValidationException("The base module cannot have conditions since it will always be served.");
            }
        } else if (!deliveryTypeDeclared) {
            throw ValidationException.builder().withMessage("The module must explicitly set its delivery options using the <dist:delivery> element (module: '%s').", module.getName()).build();
        }
    }

    private void validateInstantDeliverySettings(BundleModule module) {
        if (module.getAndroidManifest().getInstantManifestDeliveryElement().isPresent() && module.getAndroidManifest().getInstantAttribute().isPresent()) {
            throw ValidationException.builder().withMessage("The <dist:instant-delivery> element and dist:instant attribute cannot be used together (module: '%s').", module.getName()).build();
        }
    }

    private void validateOnDemandIsInstantMutualExclusion(BundleModule module) {
        boolean isInstant = module.getAndroidManifest().isInstantModule().orElse(false);
        if (module.getDeliveryType().equals((Object)BundleModule.ModuleDeliveryType.NO_INITIAL_INSTALL) && isInstant && module.getModuleType().equals((Object)BundleModule.ModuleType.FEATURE_MODULE)) {
            throw ValidationException.builder().withMessage("Feature module cannot be on-demand and 'instant' at the same time (module '%s').", module.getName()).build();
        }
        if (module.getDeliveryType().equals((Object)BundleModule.ModuleDeliveryType.CONDITIONAL_INITIAL_INSTALL) && isInstant) {
            throw ValidationException.builder().withMessage("The attribute 'instant' cannot be true for conditional module (module '%s').", module.getName()).build();
        }
    }

    private void validateFusingConfig(BundleModule module) {
        Optional<Boolean> isInstant = module.getAndroidManifest().isInstantModule();
        if (isInstant.isPresent() && isInstant.get().booleanValue()) {
            return;
        }
        Optional<Boolean> includedInFusingByManifest = module.getAndroidManifest().getIsModuleIncludedInFusing();
        if (module.isBaseModule()) {
            if (includedInFusingByManifest.isPresent() && !includedInFusingByManifest.get().booleanValue()) {
                throw new ManifestFusingException.BaseModuleExcludedFromFusingException();
            }
        } else if (!includedInFusingByManifest.isPresent()) {
            throw new ManifestFusingException.ModuleFusingConfigurationMissingException(module.getName().getName());
        }
    }

    private void validateMinMaxSdk(BundleModule module) {
        AndroidManifest manifest = module.getAndroidManifest();
        Optional<Integer> maxSdk = manifest.getMaxSdkVersion();
        Optional<Integer> minSdk = manifest.getMinSdkVersion();
        maxSdk.filter(sdk -> sdk < 0).ifPresent(sdk -> {
            throw new ManifestSdkTargetingException.MaxSdkInvalidException((int)sdk);
        });
        minSdk.filter(sdk -> sdk < 0).ifPresent(sdk -> {
            throw new ManifestSdkTargetingException.MinSdkInvalidException((int)sdk);
        });
        if (maxSdk.isPresent() && minSdk.isPresent() && maxSdk.get() < minSdk.get()) {
            throw new ManifestSdkTargetingException.MinSdkGreaterThanMaxSdkException(minSdk.get(), maxSdk.get());
        }
    }

    private void validateNumberOfDistinctSplitIds(BundleModule module) {
        ImmutableSet splitIds = (ImmutableSet)((XmlProtoElement)module.getAndroidManifest().getManifestRoot().getElement()).getAttributes().filter(attr -> attr.getName().equals("split") && attr.getNamespaceUri().equals("")).collect(ImmutableSet.toImmutableSet());
        if (splitIds.size() > 1) {
            throw new ManifestDuplicateAttributeException("split", (ImmutableSet<XmlProtoAttribute>)splitIds, module.getName().toString());
        }
    }

    private void validateAssetModuleManifest(BundleModule module) {
        ImmutableMultimap allowedManifestElementChildren = ImmutableMultimap.of((Object)"http://schemas.android.com/apk/distribution", (Object)"module", (Object)"", (Object)"uses-split");
        AndroidManifest manifest = module.getAndroidManifest();
        if (!manifest.getModuleType().equals((Object)BundleModule.ModuleType.ASSET_MODULE)) {
            return;
        }
        if (((XmlProtoElement)manifest.getManifestRoot().getElement()).getChildrenElements().anyMatch(child -> !allowedManifestElementChildren.containsEntry((Object)child.getNamespaceUri(), (Object)child.getName()))) {
            throw ValidationException.builder().withMessage("Unexpected element declaration in manifest of asset pack '%s'.", module.getName()).build();
        }
    }

    private void validateMinSdkCondition(BundleModule module) {
        int effectiveMinSdkVersion = module.getAndroidManifest().getEffectiveMinSdkVersion();
        Optional minSdkCondition = module.getAndroidManifest().getManifestDeliveryElement().map(ManifestDeliveryElement::getModuleConditions).flatMap(ModuleConditions::getMinSdkVersion);
        if (minSdkCondition.isPresent() && (Integer)minSdkCondition.get() < effectiveMinSdkVersion) {
            throw ValidationException.builder().withMessage("Module '%s' has <dist:min-sdk> condition (%d) lower than the minSdkVersion(%d) of the module.", module.getName(), minSdkCondition.get(), effectiveMinSdkVersion).build();
        }
    }

    private void validateNoConditionalTargetingInAssetModules(BundleModule module) {
        if (module.getModuleType().equals((Object)BundleModule.ModuleType.ASSET_MODULE) && !module.getModuleMetadata().getTargeting().equals(Targeting.ModuleTargeting.getDefaultInstance())) {
            throw ValidationException.builder().withMessage("Conditional targeting is not allowed in asset packs, but found in '%s'.", module.getName()).build();
        }
    }

    private void validateInstantAndPersistentDeliveryCombinationsForAssetModules(BundleModule module) {
        if (!module.getAndroidManifest().getModuleType().equals((Object)BundleModule.ModuleType.ASSET_MODULE) || !module.isInstantModule()) {
            return;
        }
        if (!module.getDeliveryType().equals((Object)BundleModule.ModuleDeliveryType.NO_INITIAL_INSTALL)) {
            throw ValidationException.builder().withMessage("Instant asset packs cannot have install-time delivery (module '%s').", module.getName()).build();
        }
        BundleModule.ModuleDeliveryType instantDelivery = module.getInstantDeliveryType().get();
        if (instantDelivery.equals((Object)BundleModule.ModuleDeliveryType.ALWAYS_INITIAL_INSTALL) || instantDelivery.equals((Object)BundleModule.ModuleDeliveryType.CONDITIONAL_INITIAL_INSTALL)) {
            throw ValidationException.builder().withMessage("Instant delivery cannot be install-time (module '%s').", module.getName()).build();
        }
    }
}

