/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.support;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Ints;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import shadow.bundletool.com.android.support.AndroidxMigrationParserKt;
import shadow.bundletool.com.android.support.AndroidxName;
import shadow.bundletool.com.android.support.MigrationParserVisitor;

public class AndroidxNameUtils {
    private static final Logger LOG = Logger.getLogger(AndroidxName.class.getName());
    static final String ANDROID_SUPPORT_PKG = "android.support.";
    static final String ANDROID_ARCH_PKG = "android.arch.";
    static final String ANDROID_DATABINDING_PKG = "android.databinding.";
    static final ImmutableMap<String, String> ANDROIDX_PKG_MAPPING;
    static final ImmutableMap<String, String> ANDROIDX_FULL_CLASS_MAPPING;
    static final ImmutableMap<String, String> ANDROIDX_COORDINATES_MAPPING;
    static final ImmutableMap<String, String> ANDROIDX_VERSIONED_COORDINATES_MAPPING;
    static final ImmutableList<String> ANDROIDX_OLD_PKGS;

    static String getPackageMapping(String oldPkgName, boolean strictChecking) {
        int n = ANDROIDX_OLD_PKGS.size();
        for (int i = 0; i < n; ++i) {
            String prefix = (String)ANDROIDX_OLD_PKGS.get(i);
            if (!oldPkgName.startsWith(prefix)) continue;
            return (String)ANDROIDX_PKG_MAPPING.get((Object)prefix) + oldPkgName.substring(prefix.length());
        }
        if (strictChecking && LOG.isLoggable(Level.FINE)) {
            LOG.fine("support library package not found: " + oldPkgName);
        }
        return oldPkgName;
    }

    public static Collection<String> getAllAndroidxCoordinates() {
        return ANDROIDX_COORDINATES_MAPPING.values();
    }

    public static String getCoordinateMapping(String coordinate) {
        return (String)ANDROIDX_COORDINATES_MAPPING.getOrDefault((Object)coordinate, (Object)coordinate);
    }

    public static String getVersionedCoordinateMapping(String coordinate) {
        String[] components = coordinate.split(":");
        if (components.length < 2) {
            return coordinate;
        }
        String canonicalCoordinate = components[0] + ":" + components[1];
        return (String)ANDROIDX_VERSIONED_COORDINATES_MAPPING.getOrDefault((Object)canonicalCoordinate, (Object)coordinate);
    }

    public static String getNewName(String oldName) {
        int innerClassSymbol = oldName.indexOf(36);
        if (innerClassSymbol != -1) {
            String outerClassName = oldName.substring(0, innerClassSymbol);
            String innerClassName = oldName.substring(innerClassSymbol);
            return AndroidxNameUtils.getNewName(outerClassName) + innerClassName;
        }
        String newName = (String)ANDROIDX_FULL_CLASS_MAPPING.get((Object)oldName);
        if (newName != null) {
            return newName;
        }
        int lastDot = oldName.lastIndexOf(46);
        return AndroidxNameUtils.getPackageMapping(oldName.substring(0, lastDot + 1), false) + oldName.substring(lastDot + 1);
    }

    static {
        final ImmutableMap.Builder classTransformMap = ImmutableMap.builder();
        final ImmutableMap.Builder packageTransformMap = ImmutableMap.builder();
        final ImmutableMap.Builder coordinatesTransformMap = ImmutableMap.builder();
        final ImmutableMap.Builder versionedCoordinatesTransformMap = ImmutableMap.builder();
        try {
            AndroidxMigrationParserKt.parseMigrationFile(new MigrationParserVisitor(){

                @Override
                public void visitGradleCoordinateUpgrade(String groupName, String artifactName, String newBaseVersion) {
                }

                @Override
                public void visitGradleCoordinate(String oldGroupName, String oldArtifactName, String newGroupName, String newArtifactName, String newBaseVersion) {
                    coordinatesTransformMap.put((Object)(oldGroupName + ":" + oldArtifactName), (Object)(newGroupName + ":" + newArtifactName));
                    versionedCoordinatesTransformMap.put((Object)(oldGroupName + ":" + oldArtifactName), (Object)(newGroupName + ":" + newArtifactName + ":" + newBaseVersion));
                }

                @Override
                public void visitClass(String old, String newName) {
                    classTransformMap.put((Object)old, (Object)newName);
                }

                @Override
                public void visitPackage(String old, String newName) {
                    packageTransformMap.put((Object)old, (Object)newName);
                }
            });
        }
        catch (Throwable e) {
            LOG.severe("Error loading androidx migration mapping: " + e.getLocalizedMessage());
        }
        ANDROIDX_FULL_CLASS_MAPPING = classTransformMap.build();
        ANDROIDX_PKG_MAPPING = packageTransformMap.build();
        ANDROIDX_OLD_PKGS = Ordering.from((left, right) -> Ints.compare((int)right.length(), (int)left.length())).immutableSortedCopy((Iterable)ANDROIDX_PKG_MAPPING.keySet());
        ANDROIDX_COORDINATES_MAPPING = coordinatesTransformMap.build();
        ANDROIDX_VERSIONED_COORDINATES_MAPPING = versionedCoordinatesTransformMap.build();
    }
}

