/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import shadow.bundletool.com.android.tools.r8.ProgramResource;
import shadow.bundletool.com.android.tools.r8.ProgramResourceProvider;
import shadow.bundletool.com.android.tools.r8.ResourceException;
import shadow.bundletool.com.android.tools.r8.errors.CompilationError;
import shadow.bundletool.com.android.tools.r8.origin.ArchiveEntryOrigin;
import shadow.bundletool.com.android.tools.r8.origin.Origin;
import shadow.bundletool.com.android.tools.r8.origin.PathOrigin;
import shadow.bundletool.com.android.tools.r8.utils.DescriptorUtils;
import shadow.bundletool.com.android.tools.r8.utils.ZipUtils;

public class ArchiveProgramResourceProvider
implements ProgramResourceProvider {
    private final Origin origin;
    private final ZipFileSupplier supplier;
    private final Predicate<String> include;

    public static boolean includeClassFileEntries(String entry) {
        return ZipUtils.isClassFile(entry);
    }

    public static boolean includeDexEntries(String entry) {
        return ZipUtils.isDexFile(entry);
    }

    public static boolean includeClassFileOrDexEntries(String entry) {
        return ZipUtils.isClassFile(entry) || ZipUtils.isDexFile(entry);
    }

    public static ArchiveProgramResourceProvider fromArchive(Path archive) {
        return ArchiveProgramResourceProvider.fromArchive(archive, ArchiveProgramResourceProvider::includeClassFileOrDexEntries);
    }

    public static ArchiveProgramResourceProvider fromArchive(Path archive, Predicate<String> include) {
        return ArchiveProgramResourceProvider.fromSupplier(new PathOrigin(archive), () -> new ZipFile(archive.toFile(), StandardCharsets.UTF_8), include);
    }

    public static ArchiveProgramResourceProvider fromSupplier(Origin origin, ZipFileSupplier supplier) {
        return ArchiveProgramResourceProvider.fromSupplier(origin, supplier, ArchiveProgramResourceProvider::includeClassFileOrDexEntries);
    }

    public static ArchiveProgramResourceProvider fromSupplier(Origin origin, ZipFileSupplier supplier, Predicate<String> include) {
        return new ArchiveProgramResourceProvider(origin, supplier, include);
    }

    private ArchiveProgramResourceProvider(Origin origin, ZipFileSupplier supplier, Predicate<String> include) {
        assert (origin != null);
        assert (supplier != null);
        assert (include != null);
        this.origin = origin;
        this.supplier = supplier;
        this.include = include;
    }

    private List<ProgramResource> readArchive() throws IOException {
        ArrayList<ProgramResource> dexResources = new ArrayList<ProgramResource>();
        ArrayList<ProgramResource> classResources = new ArrayList<ProgramResource>();
        try (ZipFile zipFile = this.supplier.open();){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                InputStream stream = zipFile.getInputStream(entry);
                Throwable throwable = null;
                try {
                    String name = entry.getName();
                    ArchiveEntryOrigin entryOrigin = new ArchiveEntryOrigin(name, this.origin);
                    if (!this.include.test(name)) continue;
                    if (ZipUtils.isDexFile(name)) {
                        dexResources.add(ProgramResource.fromBytes(entryOrigin, ProgramResource.Kind.DEX, ByteStreams.toByteArray((InputStream)stream), null));
                        continue;
                    }
                    if (!ZipUtils.isClassFile(name)) continue;
                    String descriptor = DescriptorUtils.guessTypeDescriptor(name);
                    classResources.add(ProgramResource.fromBytes(entryOrigin, ProgramResource.Kind.CF, ByteStreams.toByteArray((InputStream)stream), Collections.singleton(descriptor)));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream == null) continue;
                    ArchiveProgramResourceProvider.$closeResource(throwable, stream);
                }
            }
        }
        catch (ZipException e) {
            throw new CompilationError("Zip error while reading archive" + e.getMessage(), e, this.origin);
        }
        if (!dexResources.isEmpty() && !classResources.isEmpty()) {
            throw new CompilationError("Cannot create android app from an archive containing both DEX and Java-bytecode content", this.origin);
        }
        return !dexResources.isEmpty() ? dexResources : classResources;
    }

    @Override
    public Collection<ProgramResource> getProgramResources() throws ResourceException {
        try {
            return this.readArchive();
        }
        catch (IOException e) {
            throw new ResourceException(this.origin, (Throwable)e);
        }
    }

    public static interface ZipFileSupplier {
        public ZipFile open() throws IOException;
    }
}

