/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.code;

import java.nio.ShortBuffer;
import shadow.bundletool.com.android.tools.r8.code.Base2Format;
import shadow.bundletool.com.android.tools.r8.code.BytecodeStream;
import shadow.bundletool.com.android.tools.r8.dex.IndexedItemCollection;
import shadow.bundletool.com.android.tools.r8.graph.ObjectToOffsetMapping;
import shadow.bundletool.com.android.tools.r8.naming.ClassNameMapper;
import shadow.bundletool.com.android.tools.r8.utils.StringUtils;

public abstract class Format22b
extends Base2Format {
    public final short AA;
    public final short BB;
    public final byte CC;

    Format22b(int high, BytecodeStream stream) {
        super(stream);
        this.AA = (short)high;
        this.CC = Format22b.readSigned8BitValue(stream);
        this.BB = Format22b.read8BitValue(stream);
    }

    Format22b(int AA, int BB, int CC) {
        assert (0 <= AA && AA <= 255);
        assert (0 <= BB && BB <= 255);
        assert (-128 <= CC && CC <= 127);
        this.AA = (short)AA;
        this.BB = (short)BB;
        this.CC = (byte)CC;
    }

    @Override
    public void write(ShortBuffer dest, ObjectToOffsetMapping mapping) {
        this.writeFirst(this.AA, dest);
        this.write16BitValue(Format22b.combineBytes(this.CC, this.BB), dest);
    }

    @Override
    public final int hashCode() {
        return (this.AA << 16 | this.BB << 8 | this.CC) ^ this.getClass().hashCode();
    }

    @Override
    public final boolean equals(Object other) {
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Format22b o = (Format22b)other;
        return o.AA == this.AA && o.BB == this.BB && o.CC == this.CC;
    }

    @Override
    public String toString(ClassNameMapper naming) {
        return this.formatString("v" + this.AA + ", v" + this.BB + ", #" + this.CC);
    }

    @Override
    public String toSmaliString(ClassNameMapper naming) {
        return this.formatSmaliString("v" + this.AA + ", v" + this.BB + ", " + StringUtils.hexString(this.CC, 2) + "  # " + this.CC);
    }

    @Override
    public void collectIndexedItems(IndexedItemCollection indexedItems) {
    }
}

