/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.graph;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import shadow.bundletool.com.android.tools.r8.graph.DexApplication;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexLibraryClass;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.GraphLense;
import shadow.bundletool.com.android.tools.r8.graph.LazyLoadedDexApplication;
import shadow.bundletool.com.android.tools.r8.naming.ClassNameMapper;
import shadow.bundletool.com.android.tools.r8.utils.ProgramClassCollection;
import shadow.bundletool.com.android.tools.r8.utils.Timing;

public class DirectMappedDexApplication
extends DexApplication {
    private final ImmutableMap<DexType, DexLibraryClass> libraryClasses;

    private DirectMappedDexApplication(ClassNameMapper proguardMap, ProgramClassCollection programClasses, ImmutableMap<DexType, DexLibraryClass> libraryClasses, ImmutableSet<DexType> mainDexList, String deadCode, DexItemFactory dexItemFactory, DexString highestSortingString, Timing timing) {
        super(proguardMap, programClasses, mainDexList, deadCode, dexItemFactory, highestSortingString, timing);
        this.libraryClasses = libraryClasses;
    }

    public Collection<DexLibraryClass> libraryClasses() {
        return this.libraryClasses.values();
    }

    @Override
    public DexClass definitionFor(DexType type) {
        Object result = this.programClasses.get(type);
        if (result == null) {
            result = (DexClass)this.libraryClasses.get((Object)type);
        }
        return result;
    }

    public Builder builder() {
        return new Builder(this);
    }

    @Override
    public DirectMappedDexApplication toDirect() {
        return this;
    }

    @Override
    public DirectMappedDexApplication asDirect() {
        return this;
    }

    @Override
    public String toString() {
        return "DexApplication (direct)";
    }

    public DirectMappedDexApplication rewrittenWithLense(GraphLense graphLense) {
        assert (graphLense.isContextFree());
        assert (this.mappingIsValid(graphLense, this.programClasses.getAllTypes()));
        assert (this.mappingIsValid(graphLense, (Iterable<DexType>)this.libraryClasses.keySet()));
        return this.builder().build().asDirect();
    }

    private boolean mappingIsValid(GraphLense graphLense, Iterable<DexType> types) {
        for (DexType type : types) {
            DexType renamed = graphLense.lookupType(type, null);
            if (renamed == type || this.definitionFor((DexType)type).type == renamed || this.definitionFor(renamed) != null) continue;
            return false;
        }
        return true;
    }

    public static class Builder
    extends DexApplication.Builder<Builder> {
        private final List<DexLibraryClass> libraryClasses = new ArrayList<DexLibraryClass>();

        Builder(LazyLoadedDexApplication application) {
            super(application);
            Map<DexType, DexClass> allClasses = application.getFullClassMap();
            Iterables.filter(allClasses.values(), DexLibraryClass.class).forEach(this.libraryClasses::add);
        }

        private Builder(DirectMappedDexApplication application) {
            super(application);
            this.libraryClasses.addAll((Collection<DexLibraryClass>)application.libraryClasses.values());
        }

        @Override
        Builder self() {
            return this;
        }

        @Override
        public DexApplication build() {
            return new DirectMappedDexApplication(this.proguardMap, ProgramClassCollection.create(this.programClasses, ProgramClassCollection::resolveClassConflictImpl), (ImmutableMap)this.libraryClasses.stream().collect(ImmutableMap.toImmutableMap(c -> c.type, c -> c)), ImmutableSet.copyOf((Collection)this.mainDexList), this.deadCode, this.dexItemFactory, this.highestSortingString, this.timing);
        }
    }
}

