/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.shaking.protolite;

import shadow.bundletool.com.android.tools.r8.graph.AppInfoWithSubtyping;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.graph.DexType;

abstract class ProtoLiteBase {
    static final int GETTER_NAME_PREFIX_LENGTH = 3;
    static final int COUNT_POSTFIX_LENGTH = 5;
    final AppInfoWithSubtyping appInfo;
    final DexType messageType;
    final DexString dynamicMethodName;
    final DexString writeToMethodName;
    final DexString getSerializedSizeMethodName;
    final DexString constructorMethodName;
    final DexString setterNamePrefix;
    final DexString getterNamePrefix;
    final DexString bitFieldPrefix;
    final DexString underscore;

    ProtoLiteBase(AppInfoWithSubtyping appInfo) {
        this.appInfo = appInfo;
        DexItemFactory factory = appInfo.dexItemFactory;
        this.messageType = factory.createType("Lcom/google/protobuf/GeneratedMessageLite;");
        this.dynamicMethodName = factory.createString("dynamicMethod");
        this.writeToMethodName = factory.createString("writeTo");
        this.getSerializedSizeMethodName = factory.createString("getSerializedSize");
        this.constructorMethodName = factory.constructorMethodName;
        this.setterNamePrefix = factory.createString("set");
        this.getterNamePrefix = factory.createString("get");
        this.bitFieldPrefix = factory.createString("bitField");
        this.underscore = factory.createString("_");
        assert (this.getterNamePrefix.size == 3);
    }

    abstract boolean isSetterThatNeedsProcessing(DexEncodedMethod var1);

    DexField getterToField(DexMethod getter) {
        return this.getterToField(getter, 0);
    }

    DexField getterToField(DexMethod getter, int postfixLength) {
        String getterName = getter.name.toString();
        assert (getterName.length() > 3 + postfixLength);
        String fieldName = Character.toLowerCase(getterName.charAt(3)) + getterName.substring(4, getterName.length() - postfixLength) + "_";
        DexItemFactory factory = this.appInfo.dexItemFactory;
        return factory.createField(getter.holder, getter.proto.returnType, factory.createString(fieldName));
    }

    boolean hasSingleIntArgument(DexMethod method) {
        return method.getArity() == 1 && method.proto.parameters.values[0] == this.appInfo.dexItemFactory.intType;
    }

    public boolean appliesTo(DexEncodedMethod method) {
        if (!method.method.holder.isSubtypeOf(this.messageType, this.appInfo)) {
            return false;
        }
        DexClass clazz = this.appInfo.definitionFor(method.method.holder);
        if (!clazz.accessFlags.isFinal()) {
            return false;
        }
        DexString methodName = method.method.name;
        return methodName == this.dynamicMethodName || methodName == this.writeToMethodName || methodName == this.getSerializedSizeMethodName || methodName == this.constructorMethodName || this.isSetterThatNeedsProcessing(method);
    }
}

