/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class VersionProperties {
    public static final VersionProperties INSTANCE = VersionProperties.get();
    private static final String VERSION_CODE_KEY = "version-file.version.code";
    private static final String SHA_KEY = "version.sha";
    private static final String RELEASER_KEY = "releaser";
    private static final String RESOURCE_NAME = "r8-version.properties";
    private String sha;
    private String releaser;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static VersionProperties get() {
        ClassLoader loader = VersionProperties.class.getClassLoader();
        try (InputStream resourceStream = loader.getResourceAsStream(RESOURCE_NAME);){
            VersionProperties versionProperties = resourceStream == null ? new VersionProperties() : new VersionProperties(resourceStream);
            return versionProperties;
        }
        catch (IOException e) {
            return new VersionProperties();
        }
    }

    private VersionProperties() {
    }

    private VersionProperties(InputStream resourceStream) throws IOException {
        Properties prop = new Properties();
        prop.load(resourceStream);
        long versionFileVersion = Long.parseLong(prop.getProperty(VERSION_CODE_KEY));
        assert (versionFileVersion >= 1L);
        this.sha = prop.getProperty(SHA_KEY);
        this.releaser = prop.getProperty(RELEASER_KEY);
    }

    public String getDescription() {
        return "build " + this.getSha() + (this.releaser != null ? " from " + this.releaser : "");
    }

    public String getSha() {
        return this.isEngineering() ? "engineering" : this.sha;
    }

    public String toString() {
        return this.sha + " from " + this.releaser;
    }

    public boolean isEngineering() {
        return this.sha == null || this.sha.trim().isEmpty();
    }
}

