/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.splitters;

import com.android.bundle.Files;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.model.ManifestMutator;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.targeting.TargetingDimension;
import com.android.tools.build.bundletool.model.targeting.TargetingUtils;
import com.android.tools.build.bundletool.splitters.ModuleSplitSplitter;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimaps;
import com.google.protobuf.Message;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;

public class AssetsDimensionSplitterFactory {
    public static <T extends Message> ModuleSplitSplitter createSplitter(Function<Targeting.AssetsDirectoryTargeting, T> dimensionGetter, Function<T, Targeting.ApkTargeting> targetingSetter, Predicate<Targeting.ApkTargeting> hasTargeting) {
        return AssetsDimensionSplitterFactory.createSplitter(dimensionGetter, targetingSetter, hasTargeting, Optional.empty());
    }

    public static <T extends Message> ModuleSplitSplitter createSplitter(final Function<Targeting.AssetsDirectoryTargeting, T> dimensionGetter, final Function<T, Targeting.ApkTargeting> targetingSetter, final Predicate<Targeting.ApkTargeting> hasTargeting, final Optional<TargetingDimension> targetingDimensionToRemove) {
        return new ModuleSplitSplitter(){

            @Override
            public ImmutableCollection<ModuleSplit> split(ModuleSplit split) {
                Preconditions.checkArgument((!hasTargeting.test(split.getApkTargeting()) ? 1 : 0) != 0, (Object)"Split is already targeting the splitting dimension.");
                return (ImmutableCollection)split.getAssetsConfig().map(assetsConfig -> this.splitAssetsDirectories((Files.Assets)assetsConfig, split)).orElse(ImmutableList.of((Object)split)).stream().map(moduleSplit -> this.removeAssetsTargeting((ModuleSplit)moduleSplit)).collect(ImmutableList.toImmutableList());
            }

            private ModuleSplit removeAssetsTargeting(ModuleSplit split) {
                return targetingDimensionToRemove.isPresent() ? TargetingUtils.removeAssetsTargeting(split, (TargetingDimension)((Object)targetingDimensionToRemove.get())) : split;
            }

            private ImmutableList<ModuleSplit> splitAssetsDirectories(Files.Assets assets, ModuleSplit split) {
                ImmutableListMultimap directoriesMap = Multimaps.index(assets.getDirectoryList(), targetedDirectory -> (Message)dimensionGetter.apply((Object)targetedDirectory.getTargeting()));
                return (ImmutableList)directoriesMap.asMap().entrySet().stream().map(entry -> {
                    ModuleSplit.Builder modifiedSplit = split.toBuilder();
                    boolean isMasterSplit = split.isMasterSplit() && this.isDefaultTargeting((Message)entry.getKey());
                    modifiedSplit.setEntries((List<ModuleEntry>)this.listEntriesFromDirectories((Collection)entry.getValue(), split)).setApkTargeting(this.generateTargeting(split.getApkTargeting(), (Message)entry.getKey())).setMasterSplit(isMasterSplit);
                    if (!isMasterSplit) {
                        modifiedSplit.addMasterManifestMutator(ManifestMutator.withSplitsRequired(true));
                    }
                    return modifiedSplit.build();
                }).filter(moduleSplit -> !moduleSplit.getEntries().isEmpty()).collect(ImmutableList.toImmutableList());
            }

            private boolean isDefaultTargeting(T splittingDimensionTargeting) {
                return splittingDimensionTargeting.equals((Object)splittingDimensionTargeting.getDefaultInstanceForType());
            }

            private Targeting.ApkTargeting generateTargeting(Targeting.ApkTargeting splitTargeting, T extraTargeting) {
                if (this.isDefaultTargeting(extraTargeting)) {
                    return splitTargeting;
                }
                return splitTargeting.toBuilder().mergeFrom((Targeting.ApkTargeting)targetingSetter.apply(extraTargeting)).build();
            }

            private ImmutableList<ModuleEntry> listEntriesFromDirectories(Collection<Files.TargetedAssetsDirectory> directories, ModuleSplit moduleSplit) {
                return (ImmutableList)directories.stream().map(targetedAssetsDirectory -> ZipPath.create(targetedAssetsDirectory.getPath())).flatMap(moduleSplit::getEntriesInDirectory).collect(ImmutableList.toImmutableList());
            }
        };
    }

    private AssetsDimensionSplitterFactory() {
    }
}

