/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.splitters;

import com.android.bundle.Config;
import com.android.bundle.Devices;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.device.ApkMatcher;
import com.android.tools.build.bundletool.mergers.D8DexMerger;
import com.android.tools.build.bundletool.mergers.ModuleSplitsToShardMerger;
import com.android.tools.build.bundletool.mergers.SameTargetingMerger;
import com.android.tools.build.bundletool.model.BundleMetadata;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.BundleModuleName;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.OptimizationDimension;
import com.android.tools.build.bundletool.model.ResourceId;
import com.android.tools.build.bundletool.model.ShardedSystemSplits;
import com.android.tools.build.bundletool.model.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.model.targeting.TargetingDimension;
import com.android.tools.build.bundletool.model.targeting.TargetingUtils;
import com.android.tools.build.bundletool.model.utils.TargetingProtoUtils;
import com.android.tools.build.bundletool.model.utils.TextureCompressionUtils;
import com.android.tools.build.bundletool.model.version.Version;
import com.android.tools.build.bundletool.preprocessors.AppBundle64BitNativeLibrariesPreprocessor;
import com.android.tools.build.bundletool.splitters.AbiApexImagesSplitter;
import com.android.tools.build.bundletool.splitters.AbiNativeLibrariesSplitter;
import com.android.tools.build.bundletool.splitters.BundleSharderConfiguration;
import com.android.tools.build.bundletool.splitters.LanguageAssetsSplitter;
import com.android.tools.build.bundletool.splitters.LanguageResourcesSplitter;
import com.android.tools.build.bundletool.splitters.ModuleSplitSplitter;
import com.android.tools.build.bundletool.splitters.SanitizerNativeLibrariesSplitter;
import com.android.tools.build.bundletool.splitters.ScreenDensityResourcesSplitter;
import com.android.tools.build.bundletool.splitters.SplittingPipeline;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;

public class BundleSharder {
    private final Version bundleVersion;
    private final ModuleSplitsToShardMerger merger;
    private final BundleSharderConfiguration bundleSharderConfiguration;

    public BundleSharder(Path globalTempDir, Version bundleVersion, BundleSharderConfiguration bundleSharderConfiguration) {
        this.bundleVersion = bundleVersion;
        this.merger = new ModuleSplitsToShardMerger(new D8DexMerger(), globalTempDir);
        this.bundleSharderConfiguration = bundleSharderConfiguration;
    }

    public ImmutableList<ModuleSplit> shardBundle(ImmutableList<BundleModule> modules, ImmutableSet<OptimizationDimension> shardingDimensions, BundleMetadata bundleMetadata) {
        Preconditions.checkState((!this.bundleSharderConfiguration.getDeviceSpec().isPresent() ? 1 : 0) != 0, (Object)"Device spec should be set only when sharding for system apps.");
        return this.merger.merge(this.generateUnfusedShards(modules, shardingDimensions), bundleMetadata);
    }

    public ShardedSystemSplits shardForSystemApps(ImmutableList<BundleModule> modules, ImmutableSet<BundleModuleName> modulesToFuse, ImmutableSet<OptimizationDimension> shardingDimensions, BundleMetadata bundleMetadata) {
        Preconditions.checkState((boolean)this.bundleSharderConfiguration.getDeviceSpec().isPresent(), (Object)"Device spec should be set when sharding for system apps.");
        return this.merger.mergeSystemShard((ImmutableCollection<ModuleSplit>)((ImmutableCollection)Iterables.getOnlyElement(this.generateUnfusedShards(modules, shardingDimensions))), modulesToFuse, bundleMetadata, this.bundleSharderConfiguration.getDeviceSpec().get());
    }

    private ImmutableList<ImmutableList<ModuleSplit>> generateUnfusedShards(ImmutableList<BundleModule> modules, ImmutableSet<OptimizationDimension> shardingDimensions) {
        Preconditions.checkArgument((!modules.isEmpty() ? 1 : 0) != 0, (Object)"At least one module is required.");
        if (this.bundleSharderConfiguration.getStrip64BitLibrariesFromShards()) {
            modules = ImmutableList.copyOf(AppBundle64BitNativeLibrariesPreprocessor.processModules(modules));
        }
        ImmutableList moduleSplits = (ImmutableList)modules.stream().flatMap(module -> this.generateSplits((BundleModule)module, shardingDimensions).stream()).collect(ImmutableList.toImmutableList());
        return this.groupSplitsToShards((ImmutableList<ModuleSplit>)moduleSplits);
    }

    public ImmutableList<ModuleSplit> shardApexBundle(BundleModule apexModule) {
        ImmutableList<ModuleSplit> splits = this.generateSplits(apexModule, (ImmutableSet<OptimizationDimension>)ImmutableSet.of());
        ImmutableList<ImmutableList<ModuleSplit>> unfusedShards = this.groupSplitsToShardsForApex(splits);
        return this.merger.mergeApex(unfusedShards);
    }

    private ImmutableList<ModuleSplit> generateSplits(BundleModule module, ImmutableSet<OptimizationDimension> shardingDimensions) {
        ImmutableList.Builder rawSplits = ImmutableList.builder();
        SplittingPipeline nativePipeline = this.createNativeLibrariesSplittingPipeline(shardingDimensions);
        rawSplits.addAll(nativePipeline.split(ModuleSplit.forNativeLibraries(module)));
        SplittingPipeline resourcesPipeline = this.createResourcesSplittingPipeline(shardingDimensions);
        rawSplits.addAll(resourcesPipeline.split(ModuleSplit.forResources(module)));
        SplittingPipeline apexPipeline = this.createApexImagesSplittingPipeline();
        rawSplits.addAll(apexPipeline.split(ModuleSplit.forApex(module)));
        SplittingPipeline assetsPipeline = this.createAssetsSplittingPipeline(shardingDimensions);
        rawSplits.addAll(assetsPipeline.split(ModuleSplit.forAssets(module)));
        rawSplits.add((Object)ModuleSplit.forDex(module));
        rawSplits.add((Object)ModuleSplit.forRoot(module));
        ImmutableList unmergedSplits = rawSplits.build();
        ImmutableList mergedSplits = new SameTargetingMerger().merge((ImmutableCollection<ModuleSplit>)unmergedSplits);
        mergedSplits = (ImmutableList)mergedSplits.stream().map(ModuleSplit::removeSplitName).collect(ImmutableList.toImmutableList());
        long masterSplitCount = mergedSplits.stream().filter(ModuleSplit::isMasterSplit).count();
        Preconditions.checkState((masterSplitCount == 1L ? 1 : 0) != 0, (String)"Expected one master split, got %s.", (long)masterSplitCount);
        return mergedSplits;
    }

    private ImmutableList<ModuleSplit> applySuffixStripping(ImmutableList<ModuleSplit> splits) {
        Config.SuffixStripping tcfSuffixStripping = (Config.SuffixStripping)this.bundleSharderConfiguration.getSuffixStrippings().get((Object)OptimizationDimension.TEXTURE_COMPRESSION_FORMAT);
        if (tcfSuffixStripping == null || !tcfSuffixStripping.getEnabled()) {
            return splits;
        }
        return (ImmutableList)splits.stream().map(split -> BundleSharder.applySuffixStripping(split, TargetingDimension.TEXTURE_COMPRESSION_FORMAT, tcfSuffixStripping)).collect(ImmutableList.toImmutableList());
    }

    private static ModuleSplit applySuffixStripping(ModuleSplit split, TargetingDimension dimension, Config.SuffixStripping suffixStripping) {
        Preconditions.checkArgument((boolean)dimension.equals((Object)TargetingDimension.TEXTURE_COMPRESSION_FORMAT));
        split = TargetingUtils.excludeAssetsTargetingOtherValue(split, dimension, suffixStripping.getDefaultSuffix());
        split = TargetingUtils.removeAssetsTargeting(split, dimension);
        return split.toBuilder().setApkTargeting(split.getApkTargeting().toBuilder().setTextureCompressionFormatTargeting((Targeting.TextureCompressionFormatTargeting)TextureCompressionUtils.TEXTURE_TO_TARGETING.get((Object)suffixStripping.getDefaultSuffix())).build()).setVariantTargeting(split.getVariantTargeting().toBuilder().setTextureCompressionFormatTargeting((Targeting.TextureCompressionFormatTargeting)TextureCompressionUtils.TEXTURE_TO_TARGETING.get((Object)suffixStripping.getDefaultSuffix())).build()).build();
    }

    private SplittingPipeline createNativeLibrariesSplittingPipeline(ImmutableSet<OptimizationDimension> shardingDimensions) {
        ImmutableList.Builder nativeSplitters = ImmutableList.builder();
        if (shardingDimensions.contains((Object)OptimizationDimension.ABI)) {
            nativeSplitters.add((Object)new AbiNativeLibrariesSplitter());
        }
        nativeSplitters.add((Object)new SanitizerNativeLibrariesSplitter());
        return new SplittingPipeline((ImmutableList<ModuleSplitSplitter>)nativeSplitters.build());
    }

    private SplittingPipeline createResourcesSplittingPipeline(ImmutableSet<OptimizationDimension> shardingDimensions) {
        ImmutableList.Builder resourceSplitters = ImmutableList.builder();
        if (shardingDimensions.contains((Object)OptimizationDimension.SCREEN_DENSITY)) {
            resourceSplitters.add((Object)new ScreenDensityResourcesSplitter(this.bundleVersion, (Predicate<ResourceId>)Predicates.alwaysFalse(), (Predicate<ResourceId>)Predicates.alwaysFalse()));
        }
        if (shardingDimensions.contains((Object)OptimizationDimension.LANGUAGE) && this.bundleSharderConfiguration.splitByLanguage()) {
            resourceSplitters.add((Object)new LanguageResourcesSplitter());
        }
        return new SplittingPipeline((ImmutableList<ModuleSplitSplitter>)resourceSplitters.build());
    }

    private SplittingPipeline createAssetsSplittingPipeline(ImmutableSet<OptimizationDimension> shardingDimensions) {
        ImmutableList.Builder assetsSplitters = ImmutableList.builder();
        if (shardingDimensions.contains((Object)OptimizationDimension.LANGUAGE) && this.bundleSharderConfiguration.splitByLanguage()) {
            assetsSplitters.add((Object)LanguageAssetsSplitter.create());
        }
        return new SplittingPipeline((ImmutableList<ModuleSplitSplitter>)assetsSplitters.build());
    }

    private SplittingPipeline createApexImagesSplittingPipeline() {
        return new SplittingPipeline((ImmutableList<ModuleSplitSplitter>)ImmutableList.of((Object)new AbiApexImagesSplitter()));
    }

    private ImmutableList<ImmutableList<ModuleSplit>> groupSplitsToShards(ImmutableList<ModuleSplit> splits) {
        ImmutableSet<ModuleSplit> abiSplits = this.subsetWithTargeting(splits, Targeting.ApkTargeting::hasAbiTargeting);
        ImmutableSet<ModuleSplit> densitySplits = this.subsetWithTargeting(splits, Targeting.ApkTargeting::hasScreenDensityTargeting);
        ImmutableSet<ModuleSplit> languageSplits = BundleSharder.getLanguageSplits(splits);
        ImmutableSet<ModuleSplit> masterSplits = this.getMasterSplits(splits);
        Preconditions.checkState((boolean)Sets.intersection((Set)Sets.newHashSet(abiSplits), (Set)Sets.newHashSet(densitySplits)).isEmpty(), (Object)"No split is expected to have both ABI and screen density targeting.");
        Preconditions.checkState((boolean)BundleSharder.sameTargetedUniverse(densitySplits, split -> TargetingProtoUtils.densityUniverse(split.getApkTargeting())), (Object)"Density splits are expected to cover the same densities.");
        if (!BundleSharder.sameTargetedUniverse(abiSplits, split -> TargetingProtoUtils.abiUniverse(split.getApkTargeting()))) {
            throw CommandExecutionException.builder().withMessage("Modules for standalone APKs must cover the same ABIs when optimizing for ABI.").build();
        }
        Collection abiSplitsSubsets = BundleSharder.nonEmpty(BundleSharder.partitionByTargeting(abiSplits));
        Collection densitySplitsSubsets = BundleSharder.nonEmpty(BundleSharder.partitionByTargeting(densitySplits));
        ImmutableList.Builder shards = ImmutableList.builder();
        for (Collection abiSplitsSubset : abiSplitsSubsets) {
            for (Collection densitySplitsSubset : densitySplitsSubsets) {
                shards.add((Object)ImmutableList.builder().addAll(masterSplits).addAll(languageSplits).addAll(abiSplitsSubset).addAll(densitySplitsSubset).build());
            }
        }
        return shards.build();
    }

    private ImmutableList<ImmutableList<ModuleSplit>> groupSplitsToShardsForApex(ImmutableList<ModuleSplit> splits) {
        ImmutableSet<ModuleSplit> multiAbiSplits = this.subsetWithTargeting(splits, Targeting.ApkTargeting::hasMultiAbiTargeting);
        Sets.SetView masterSplits = Sets.difference((Set)ImmutableSet.copyOf(splits), multiAbiSplits);
        ModuleSplit masterSplit = (ModuleSplit)Iterables.getOnlyElement((Iterable)masterSplits);
        Preconditions.checkState((boolean)masterSplit.getApkTargeting().equals(Targeting.ApkTargeting.getDefaultInstance()), (Object)"Master splits are expected to have default targeting.");
        return (ImmutableList)multiAbiSplits.stream().map(abiSplit -> ImmutableList.of((Object)masterSplit, (Object)abiSplit)).collect(ImmutableList.toImmutableList());
    }

    private ImmutableSet<ModuleSplit> subsetWithTargeting(ImmutableList<ModuleSplit> splits, Predicate<Targeting.ApkTargeting> predicate) {
        return (ImmutableSet)splits.stream().filter(split -> predicate.test(split.getApkTargeting())).filter(split -> this.bundleSharderConfiguration.getDeviceSpec().map(spec -> BundleSharder.splitMatchesDeviceSpec(split, spec)).orElse(true)).collect(ImmutableSet.toImmutableSet());
    }

    private ImmutableSet<ModuleSplit> getMasterSplits(ImmutableList<ModuleSplit> splits) {
        ImmutableSet masterSplits = (ImmutableSet)splits.stream().filter(ModuleSplit::isMasterSplit).collect(ImmutableSet.toImmutableSet());
        Preconditions.checkState((masterSplits.size() >= 1 ? 1 : 0) != 0, (String)"Expecting at least one master split, got %s.", (int)masterSplits.size());
        Preconditions.checkState((boolean)masterSplits.stream().allMatch(split -> split.getApkTargeting().toBuilder().clearTextureCompressionFormatTargeting().build().equals(Targeting.ApkTargeting.getDefaultInstance())), (Object)"Master splits are expected to have default or Texture Compression Format only targeting.");
        return masterSplits;
    }

    private static ImmutableSet<ModuleSplit> getLanguageSplits(ImmutableList<ModuleSplit> splits) {
        return (ImmutableSet)splits.stream().filter(split -> split.getApkTargeting().hasLanguageTargeting()).collect(ImmutableSet.toImmutableSet());
    }

    private static Collection<Collection<ModuleSplit>> partitionByTargeting(Collection<ModuleSplit> splits) {
        return Multimaps.index(splits, ModuleSplit::getApkTargeting).asMap().values();
    }

    private static <T> Collection<Collection<T>> nonEmpty(Collection<Collection<T>> x3) {
        return x3.isEmpty() ? ImmutableList.of((Object)ImmutableList.of()) : x3;
    }

    private static boolean sameTargetedUniverse(Set<ModuleSplit> splits, Function<ModuleSplit, Collection<?>> getUniverseFn) {
        long distinctNonEmptyUniverseCount = splits.stream().map(getUniverseFn::apply).filter((Predicate<Collection>)Predicates.not(Collection::isEmpty)).distinct().count();
        return distinctNonEmptyUniverseCount <= 1L;
    }

    static boolean splitMatchesDeviceSpec(ModuleSplit moduleSplit, Devices.DeviceSpec deviceSpec) {
        return new ApkMatcher(deviceSpec).matchesModuleSplitByTargeting(moduleSplit);
    }
}

