/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.utils;

import shadow.bundletool.com.android.utils.CharSequences;

public class OffsetTrackingDecodedXmlValue {
    private static final char[] DECODED = new char[]{'<', '>', '&', '\'', '\"'};
    private static final String[] ENCODED = new String[]{"&lt;", "&gt;", "&amp;", "&apos;", "&quot;"};
    private final CharSequence myDecodedCharacters;
    private final int[] myOffsetMap;

    public OffsetTrackingDecodedXmlValue(CharSequence encodedValue) {
        StringBuilder decodedValue = null;
        int[] offsetMap = null;
        int escapedLength = encodedValue.length();
        int i3 = 0;
        block0: while (i3 < escapedLength) {
            for (int j3 = 0; j3 < ENCODED.length; ++j3) {
                String toReplace = ENCODED[j3];
                if (i3 + toReplace.length() > escapedLength || !CharSequences.regionMatches(encodedValue, i3, toReplace, 0, toReplace.length())) continue;
                if (decodedValue == null) {
                    decodedValue = new StringBuilder(escapedLength);
                    offsetMap = new int[escapedLength];
                    for (int k3 = 0; k3 < i3; ++k3) {
                        offsetMap[k3] = k3;
                        decodedValue.append(encodedValue.charAt(k3));
                    }
                }
                decodedValue.append(DECODED[j3]);
                offsetMap[decodedValue.length() - 1] = i3 += toReplace.length();
                continue block0;
            }
            if (decodedValue != null) {
                decodedValue.append(encodedValue.charAt(i3));
                offsetMap[decodedValue.length() - 1] = i3;
            }
            ++i3;
        }
        this.myOffsetMap = offsetMap;
        this.myDecodedCharacters = decodedValue == null ? encodedValue : decodedValue.toString();
    }

    public CharSequence getDecodedCharacters() {
        return this.myDecodedCharacters;
    }

    public int getEncodedOffset(int decodedOffset) {
        if (this.myOffsetMap == null || decodedOffset <= 0) {
            return decodedOffset;
        }
        if (decodedOffset <= this.myDecodedCharacters.length()) {
            return this.myOffsetMap[decodedOffset - 1];
        }
        return this.myOffsetMap[this.myDecodedCharacters.length() - 1] + decodedOffset - this.myDecodedCharacters.length();
    }
}

