/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.benchmarks;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import shadow.bundletool.com.android.tools.r8.ByteDataView;
import shadow.bundletool.com.android.tools.r8.CompilationFailedException;
import shadow.bundletool.com.android.tools.r8.CompilationMode;
import shadow.bundletool.com.android.tools.r8.D8;
import shadow.bundletool.com.android.tools.r8.D8Command;
import shadow.bundletool.com.android.tools.r8.DexIndexedConsumer;
import shadow.bundletool.com.android.tools.r8.DiagnosticsHandler;
import shadow.bundletool.com.android.tools.r8.benchmarks.BenchmarkUtils;
import shadow.bundletool.com.android.tools.r8.utils.ThreadUtils;

public class IncrementalDexingBenchmark {
    private static final int ITERATIONS = 1000;

    public static void compile(ExecutorService executor) throws IOException, CompilationFailedException {
        D8.run((D8Command)((D8Command.Builder)((D8Command.Builder)((D8Command.Builder)((D8Command.Builder)D8Command.builder().addProgramFiles(Paths.get("build/test/examples/arithmetic.jar", new String[0]))).setMode(CompilationMode.DEBUG)).setDisableDesugaring(true)).setProgramConsumer(new DexIndexedConsumer.ForwardingConsumer(null){

            @Override
            public void accept(int fileIndex, ByteDataView data2, Set<String> descriptors, DiagnosticsHandler handler) {
                if (fileIndex != 0) {
                    throw new RuntimeException("WAT");
                }
            }
        })).build(), executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, CompilationFailedException {
        int threads = Integer.min(Runtime.getRuntime().availableProcessors(), 16) / 2;
        ExecutorService executor = ThreadUtils.getExecutorService(threads);
        try {
            long start = System.nanoTime();
            for (int i = 0; i < 1000; ++i) {
                IncrementalDexingBenchmark.compile(executor);
            }
            double elapsedMs = (double)(System.nanoTime() - start) / 1000000.0;
            BenchmarkUtils.printRuntimeMilliseconds("IncrementalDexing", elapsedMs);
        }
        finally {
            executor.shutdown();
        }
    }
}

