/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.cf.code;

import shadow.bundletool.com.android.tools.r8.cf.CfPrinter;
import shadow.bundletool.com.android.tools.r8.cf.code.CfInstruction;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.GraphLense;
import shadow.bundletool.com.android.tools.r8.graph.UseRegistry;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CfSourceCode;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CfState;
import shadow.bundletool.com.android.tools.r8.ir.conversion.IRBuilder;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Inliner;
import shadow.bundletool.com.android.tools.r8.ir.optimize.InliningConstraints;
import shadow.bundletool.com.android.tools.r8.naming.NamingLens;
import shadow.bundletool.com.android.tools.r8.org.objectweb.asm.MethodVisitor;

public class CfFieldInstruction
extends CfInstruction {
    private final int opcode;
    private final DexField field;
    private final DexField declaringField;

    public CfFieldInstruction(int opcode, DexField field, DexField declaringField) {
        this.opcode = opcode;
        this.field = field;
        this.declaringField = declaringField;
        assert (field.type == declaringField.type);
    }

    public DexField getField() {
        return this.field;
    }

    public int getOpcode() {
        return this.opcode;
    }

    @Override
    public CfFieldInstruction asFieldInstruction() {
        return this;
    }

    @Override
    public boolean isFieldInstruction() {
        return true;
    }

    @Override
    public void write(MethodVisitor visitor, NamingLens lens) {
        String owner = lens.lookupInternalName(this.field.holder);
        String name = lens.lookupName(this.declaringField).toString();
        String desc = lens.lookupDescriptor(this.field.type).toString();
        visitor.visitFieldInsn(this.opcode, owner, name, desc);
    }

    @Override
    public void print(CfPrinter printer) {
        printer.print(this);
    }

    @Override
    public void registerUse(UseRegistry registry, DexType clazz) {
        switch (this.opcode) {
            case 180: {
                registry.registerInstanceFieldRead(this.field);
                break;
            }
            case 181: {
                registry.registerInstanceFieldWrite(this.field);
                break;
            }
            case 178: {
                registry.registerStaticFieldRead(this.field);
                break;
            }
            case 179: {
                registry.registerStaticFieldWrite(this.field);
                break;
            }
            default: {
                throw new Unreachable("Unexpected opcode " + this.opcode);
            }
        }
    }

    @Override
    public boolean canThrow() {
        return true;
    }

    @Override
    public void buildIR(IRBuilder builder, CfState state, CfSourceCode code) {
        DexType type = this.field.type;
        switch (this.opcode) {
            case 178: {
                builder.addStaticGet(state.push((DexType)type).register, this.field);
                break;
            }
            case 179: {
                CfState.Slot value = state.pop();
                builder.addStaticPut(value.register, this.field);
                break;
            }
            case 180: {
                CfState.Slot object = state.pop();
                builder.addInstanceGet(state.push((DexType)type).register, object.register, this.field);
                break;
            }
            case 181: {
                CfState.Slot value = state.pop();
                CfState.Slot object = state.pop();
                builder.addInstancePut(value.register, object.register, this.field);
                break;
            }
            default: {
                throw new Unreachable("Unexpected opcode " + this.opcode);
            }
        }
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, DexType invocationContext, GraphLense graphLense, AppView<?> appView) {
        switch (this.opcode) {
            case 178: {
                return inliningConstraints.forStaticGet(this.field, invocationContext);
            }
            case 179: {
                return inliningConstraints.forStaticPut(this.field, invocationContext);
            }
            case 180: {
                return inliningConstraints.forInstanceGet(this.field, invocationContext);
            }
            case 181: {
                return inliningConstraints.forInstancePut(this.field, invocationContext);
            }
        }
        throw new Unreachable("Unexpected opcode " + this.opcode);
    }
}

