/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.cf.code;

import java.util.Arrays;
import shadow.bundletool.com.android.tools.r8.cf.CfPrinter;
import shadow.bundletool.com.android.tools.r8.cf.code.CfInstruction;
import shadow.bundletool.com.android.tools.r8.errors.CompilationError;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexProto;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.GraphLense;
import shadow.bundletool.com.android.tools.r8.graph.UseRegistry;
import shadow.bundletool.com.android.tools.r8.ir.code.Invoke;
import shadow.bundletool.com.android.tools.r8.ir.code.ValueType;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CfSourceCode;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CfState;
import shadow.bundletool.com.android.tools.r8.ir.conversion.IRBuilder;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Inliner;
import shadow.bundletool.com.android.tools.r8.ir.optimize.InliningConstraints;
import shadow.bundletool.com.android.tools.r8.jar.InliningConstraintVisitor;
import shadow.bundletool.com.android.tools.r8.naming.NamingLens;
import shadow.bundletool.com.android.tools.r8.org.objectweb.asm.MethodVisitor;

public class CfInvoke
extends CfInstruction {
    private final DexMethod method;
    private final int opcode;
    private final boolean itf;

    public CfInvoke(int opcode, DexMethod method, boolean itf) {
        assert (182 <= opcode && opcode <= 185);
        assert (opcode != 182 || !itf) : "InvokeVirtual on interface type";
        assert (opcode != 185 || itf) : "InvokeInterface on class type";
        this.opcode = opcode;
        this.method = method;
        this.itf = itf;
    }

    public DexMethod getMethod() {
        return this.method;
    }

    public int getOpcode() {
        return this.opcode;
    }

    public boolean isInterface() {
        return this.itf;
    }

    @Override
    public CfInvoke asInvoke() {
        return this;
    }

    @Override
    public boolean isInvoke() {
        return true;
    }

    @Override
    public void write(MethodVisitor visitor, NamingLens lens) {
        String owner = lens.lookupInternalName(this.method.holder);
        String name = lens.lookupName(this.method).toString();
        String desc = this.method.proto.toDescriptorString(lens);
        visitor.visitMethodInsn(this.opcode, owner, name, desc, this.itf);
    }

    @Override
    public void print(CfPrinter printer) {
        printer.print(this);
    }

    @Override
    public void registerUse(UseRegistry registry, DexType clazz) {
        switch (this.opcode) {
            case 185: {
                registry.registerInvokeInterface(this.method);
                break;
            }
            case 182: {
                registry.registerInvokeVirtual(this.method);
                break;
            }
            case 183: {
                if (this.method.name.toString().equals("<init>")) {
                    registry.registerInvokeDirect(this.method);
                    break;
                }
                if (this.method.holder == clazz) {
                    registry.registerInvokeDirect(this.method);
                    break;
                }
                registry.registerInvokeSuper(this.method);
                break;
            }
            case 184: {
                registry.registerInvokeStatic(this.method);
                break;
            }
            default: {
                throw new Unreachable("unknown CfInvoke opcode " + this.opcode);
            }
        }
    }

    public boolean isInvokeSuper(DexType clazz) {
        return this.opcode == 183 && this.method.holder != clazz && !this.method.name.toString().equals("<init>");
    }

    @Override
    public boolean canThrow() {
        return true;
    }

    @Override
    public void buildIR(IRBuilder builder, CfState state, CfSourceCode code) {
        Invoke.Type type;
        DexMethod canonicalMethod;
        DexProto callSiteProto = null;
        switch (this.opcode) {
            case 185: {
                canonicalMethod = this.method;
                type = Invoke.Type.INTERFACE;
                break;
            }
            case 182: {
                canonicalMethod = builder.appView.dexItemFactory().polymorphicMethods.canonicalize(this.method);
                if (canonicalMethod == null) {
                    type = Invoke.Type.VIRTUAL;
                    canonicalMethod = this.method;
                    break;
                }
                type = Invoke.Type.POLYMORPHIC;
                callSiteProto = this.method.proto;
                break;
            }
            case 183: {
                canonicalMethod = this.method;
                if (this.method.name.toString().equals("<init>")) {
                    type = Invoke.Type.DIRECT;
                    break;
                }
                if (code.getOriginalHolder() == this.method.holder) {
                    type = this.invokeTypeForInvokeSpecialToNonInitMethodOnHolder(builder.appView, code);
                    break;
                }
                type = Invoke.Type.SUPER;
                break;
            }
            case 184: {
                canonicalMethod = this.method;
                type = Invoke.Type.STATIC;
                break;
            }
            default: {
                throw new Unreachable("unknown CfInvoke opcode " + this.opcode);
            }
        }
        int parameterCount = this.method.proto.parameters.size();
        if (type != Invoke.Type.STATIC) {
            ++parameterCount;
        }
        ValueType[] types = new ValueType[parameterCount];
        Integer[] registers = new Integer[parameterCount];
        for (int i = parameterCount - 1; i >= 0; --i) {
            CfState.Slot slot = state.pop();
            types[i] = slot.type;
            registers[i] = slot.register;
        }
        builder.addInvoke(type, canonicalMethod, callSiteProto, Arrays.asList(types), Arrays.asList(registers), this.itf);
        if (!this.method.proto.returnType.isVoidType()) {
            builder.addMoveResult(state.push((DexType)this.method.proto.returnType).register);
        }
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, DexType invocationContext, GraphLense graphLense, AppView<?> appView) {
        return InliningConstraintVisitor.getConstraintForInvoke(this.opcode, this.method, graphLense, appView, inliningConstraints, invocationContext);
    }

    private Invoke.Type invokeTypeForInvokeSpecialToNonInitMethodOnHolder(AppView<?> appView, CfSourceCode code) {
        boolean desugaringEnabled = appView.options().isInterfaceMethodDesugaringEnabled();
        DexEncodedMethod encodedMethod = this.lookupMethod(appView, this.method);
        if (encodedMethod == null) {
            return this.itf && desugaringEnabled ? Invoke.Type.DIRECT : Invoke.Type.SUPER;
        }
        if (!encodedMethod.isNonPrivateVirtualMethod()) {
            return Invoke.Type.DIRECT;
        }
        if (encodedMethod.accessFlags.isFinal()) {
            return Invoke.Type.VIRTUAL;
        }
        if (this.itf && encodedMethod.isDefaultMethod()) {
            return desugaringEnabled ? Invoke.Type.DIRECT : Invoke.Type.SUPER;
        }
        throw new CompilationError("Failed to compile unsupported use of invokespecial", code.getOrigin());
    }

    private DexEncodedMethod lookupMethod(AppView<?> appView, DexMethod method) {
        GraphLense.GraphLenseLookupResult lookupResult = appView.graphLense().lookupMethod(method, method, Invoke.Type.DIRECT);
        DexMethod rewrittenMethod = lookupResult.getMethod();
        DexProgramClass clazz = appView.definitionForProgramType(rewrittenMethod.holder);
        assert (clazz != null);
        return clazz.lookupMethod(rewrittenMethod);
    }
}

