/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.cf.code;

import java.util.List;
import shadow.bundletool.com.android.tools.r8.cf.CfPrinter;
import shadow.bundletool.com.android.tools.r8.cf.code.CfInstruction;
import shadow.bundletool.com.android.tools.r8.cf.code.CfLabel;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.GraphLense;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CfSourceCode;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CfState;
import shadow.bundletool.com.android.tools.r8.ir.conversion.IRBuilder;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Inliner;
import shadow.bundletool.com.android.tools.r8.ir.optimize.InliningConstraints;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntArrayList;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntList;
import shadow.bundletool.com.android.tools.r8.naming.NamingLens;
import shadow.bundletool.com.android.tools.r8.org.objectweb.asm.Label;
import shadow.bundletool.com.android.tools.r8.org.objectweb.asm.MethodVisitor;

public class CfSwitch
extends CfInstruction {
    private final Kind kind;
    private final CfLabel defaultTarget;
    private final int[] keys;
    private final List<CfLabel> targets;

    public CfSwitch(Kind kind, CfLabel defaultTarget, int[] keys2, List<CfLabel> targets) {
        this.kind = kind;
        this.defaultTarget = defaultTarget;
        this.keys = keys2;
        this.targets = targets;
        assert (kind != Kind.LOOKUP || keys2.length == targets.size());
        assert (kind != Kind.TABLE || keys2.length == 1);
    }

    public Kind getKind() {
        return this.kind;
    }

    public CfLabel getDefaultTarget() {
        return this.defaultTarget;
    }

    public IntList getKeys() {
        return new IntArrayList(this.keys);
    }

    public List<CfLabel> getSwitchTargets() {
        return this.targets;
    }

    @Override
    public CfSwitch asSwitch() {
        return this;
    }

    @Override
    public boolean isSwitch() {
        return true;
    }

    @Override
    public boolean isJump() {
        return true;
    }

    @Override
    public void write(MethodVisitor visitor, NamingLens lens) {
        Label[] labels = new Label[this.targets.size()];
        for (int i = 0; i < this.targets.size(); ++i) {
            labels[i] = this.targets.get(i).getLabel();
        }
        switch (this.kind) {
            case LOOKUP: {
                visitor.visitLookupSwitchInsn(this.defaultTarget.getLabel(), this.keys, labels);
                break;
            }
            case TABLE: {
                int min = this.keys[0];
                int max = min + this.targets.size() - 1;
                visitor.visitTableSwitchInsn(min, max, this.defaultTarget.getLabel(), labels);
            }
        }
    }

    @Override
    public void print(CfPrinter printer) {
        printer.print(this);
    }

    @Override
    public void buildIR(IRBuilder builder, CfState state, CfSourceCode code) {
        int[] labelOffsets = new int[this.targets.size()];
        for (int i = 0; i < this.targets.size(); ++i) {
            labelOffsets[i] = code.getLabelOffset(this.targets.get(i));
        }
        CfState.Slot value = state.pop();
        builder.addSwitch(value.register, this.keys, code.getLabelOffset(this.defaultTarget), labelOffsets);
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, DexType invocationContext, GraphLense graphLense, AppView<?> appView) {
        return inliningConstraints.forJumpInstruction();
    }

    public static enum Kind {
        LOOKUP,
        TABLE;

    }
}

