/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.graph;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.BiMap;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.HashBiMap;
import shadow.bundletool.com.android.tools.r8.graph.AppInfoWithSubtyping;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.Descriptor;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.GraphLense;
import shadow.bundletool.com.android.tools.r8.ir.code.Invoke;

public class AppliedGraphLens
extends GraphLense {
    private final AppView<?> appView;
    private final BiMap<DexType, DexType> originalTypeNames = HashBiMap.create();
    private final BiMap<DexField, DexField> originalFieldSignatures = HashBiMap.create();
    private final BiMap<DexMethod, DexMethod> originalMethodSignatures = HashBiMap.create();
    private final Map<DexMethod, DexMethod> originalMethodSignaturesForBridges = new IdentityHashMap<DexMethod, DexMethod>();

    public AppliedGraphLens(AppView<? extends AppInfoWithSubtyping> appView, List<DexProgramClass> classes) {
        this.appView = appView;
        for (DexProgramClass clazz : classes) {
            Descriptor existing;
            Descriptor original;
            DexType original2;
            DexType type = clazz.type;
            if (appView.verticallyMergedClasses() != null && !appView.verticallyMergedClasses().hasBeenMergedIntoSubtype(type) && (original2 = appView.graphLense().getOriginalType(type)) != type) {
                DexType existing2 = this.originalTypeNames.forcePut(type, original2);
                assert (existing2 == null);
            }
            for (DexEncodedField encodedField : clazz.fields()) {
                DexField field = encodedField.field;
                original = appView.graphLense().getOriginalFieldSignature(field);
                if (original == field) continue;
                existing = this.originalFieldSignatures.forcePut(field, (DexField)original);
                assert (existing == null);
            }
            for (DexEncodedMethod encodedMethod : clazz.methods()) {
                DexMethod method = encodedMethod.method;
                original = appView.graphLense().getOriginalMethodSignature(method);
                if (original == method) continue;
                existing = (DexMethod)this.originalMethodSignatures.inverse().get(original);
                if (existing == null) {
                    this.originalMethodSignatures.put(method, (DexMethod)original);
                    continue;
                }
                DexMethod renamed = this.getRenamedMethodSignature((DexMethod)original);
                if (renamed == existing) {
                    this.originalMethodSignaturesForBridges.put(method, (DexMethod)original);
                    continue;
                }
                this.originalMethodSignatures.forcePut(method, (DexMethod)original);
                this.originalMethodSignaturesForBridges.put((DexMethod)existing, (DexMethod)original);
            }
        }
    }

    @Override
    public DexType getOriginalType(DexType type) {
        return this.originalTypeNames.getOrDefault(type, type);
    }

    @Override
    public DexField getOriginalFieldSignature(DexField field) {
        return this.originalFieldSignatures.getOrDefault(field, field);
    }

    @Override
    public DexMethod getOriginalMethodSignature(DexMethod method) {
        if (this.originalMethodSignaturesForBridges.containsKey(method)) {
            return this.originalMethodSignaturesForBridges.get(method);
        }
        return this.originalMethodSignatures.getOrDefault(method, method);
    }

    @Override
    public DexField getRenamedFieldSignature(DexField originalField) {
        return this.originalFieldSignatures.inverse().getOrDefault(originalField, originalField);
    }

    @Override
    public DexMethod getRenamedMethodSignature(DexMethod originalMethod) {
        return this.originalMethodSignatures.inverse().getOrDefault(originalMethod, originalMethod);
    }

    @Override
    public DexType lookupType(DexType type) {
        if (this.appView.verticallyMergedClasses() != null && this.appView.verticallyMergedClasses().hasBeenMergedIntoSubtype(type)) {
            return this.lookupType(this.appView.verticallyMergedClasses().getTargetFor(type));
        }
        return this.originalTypeNames.inverse().getOrDefault(type, type);
    }

    @Override
    public GraphLense.GraphLenseLookupResult lookupMethod(DexMethod method, DexMethod context, Invoke.Type type) {
        return new GraphLense.GraphLenseLookupResult(method, type);
    }

    @Override
    public GraphLense.RewrittenPrototypeDescription lookupPrototypeChanges(DexMethod method) {
        return GraphLense.RewrittenPrototypeDescription.none();
    }

    @Override
    public DexField lookupField(DexField field) {
        return field;
    }

    @Override
    public boolean isContextFreeForMethods() {
        return true;
    }
}

