/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.graph;

import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import shadow.bundletool.com.android.tools.r8.cf.CfPrinter;
import shadow.bundletool.com.android.tools.r8.cf.code.CfFrame;
import shadow.bundletool.com.android.tools.r8.cf.code.CfIinc;
import shadow.bundletool.com.android.tools.r8.cf.code.CfInstruction;
import shadow.bundletool.com.android.tools.r8.cf.code.CfLabel;
import shadow.bundletool.com.android.tools.r8.cf.code.CfLoad;
import shadow.bundletool.com.android.tools.r8.cf.code.CfPosition;
import shadow.bundletool.com.android.tools.r8.cf.code.CfReturnVoid;
import shadow.bundletool.com.android.tools.r8.cf.code.CfTryCatch;
import shadow.bundletool.com.android.tools.r8.com.google.common.base.Strings;
import shadow.bundletool.com.android.tools.r8.errors.InvalidDebugInfoException;
import shadow.bundletool.com.android.tools.r8.errors.Unimplemented;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.ArgumentUse;
import shadow.bundletool.com.android.tools.r8.graph.Code;
import shadow.bundletool.com.android.tools.r8.graph.DebugLocalInfo;
import shadow.bundletool.com.android.tools.r8.graph.DexCode;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexProto;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.GraphLense;
import shadow.bundletool.com.android.tools.r8.graph.UseRegistry;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Position;
import shadow.bundletool.com.android.tools.r8.ir.code.ValueNumberGenerator;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CfSourceCode;
import shadow.bundletool.com.android.tools.r8.ir.conversion.IRBuilder;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Inliner;
import shadow.bundletool.com.android.tools.r8.ir.optimize.InliningConstraints;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceArrayMap;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import shadow.bundletool.com.android.tools.r8.naming.ClassNameMapper;
import shadow.bundletool.com.android.tools.r8.naming.NamingLens;
import shadow.bundletool.com.android.tools.r8.org.objectweb.asm.Label;
import shadow.bundletool.com.android.tools.r8.org.objectweb.asm.MethodVisitor;
import shadow.bundletool.com.android.tools.r8.origin.Origin;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;

public class CfCode
extends Code {
    private final DexType originalHolder;
    private final int maxStack;
    private final int maxLocals;
    public List<CfInstruction> instructions;
    private final List<CfTryCatch> tryCatchRanges;
    private final List<LocalVariableInfo> localVariables;

    public CfCode(DexType originalHolder, int maxStack, int maxLocals, List<CfInstruction> instructions, List<CfTryCatch> tryCatchRanges, List<LocalVariableInfo> localVariables) {
        this.originalHolder = originalHolder;
        this.maxStack = maxStack;
        this.maxLocals = maxLocals;
        this.instructions = instructions;
        this.tryCatchRanges = tryCatchRanges;
        this.localVariables = localVariables;
    }

    public DexType getOriginalHolder() {
        return this.originalHolder;
    }

    public int getMaxStack() {
        return this.maxStack;
    }

    public int getMaxLocals() {
        return this.maxLocals;
    }

    public List<CfTryCatch> getTryCatchRanges() {
        return this.tryCatchRanges;
    }

    public List<CfInstruction> getInstructions() {
        return Collections.unmodifiableList(this.instructions);
    }

    public List<LocalVariableInfo> getLocalVariables() {
        return Collections.unmodifiableList(this.localVariables);
    }

    @Override
    public int estimatedSizeForInlining() {
        return this.countNonStackOperations(Integer.MAX_VALUE);
    }

    @Override
    public boolean estimatedSizeForInliningAtMost(int threshold) {
        return this.countNonStackOperations(threshold) <= threshold;
    }

    private int countNonStackOperations(int threshold) {
        int result = 0;
        for (CfInstruction instruction : this.instructions) {
            if (instruction.emitsIR() && ++result > threshold) break;
        }
        return result;
    }

    @Override
    public boolean isCfCode() {
        return true;
    }

    @Override
    public CfCode asCfCode() {
        return this;
    }

    private boolean shouldAddParameterNames(DexEncodedMethod method, AppView<?> appView) {
        if (appView.options().debug) {
            return false;
        }
        assert (this.localVariables.isEmpty());
        if (!method.hasParameterInfo()) {
            return false;
        }
        return !((AppInfo)appView.appInfo()).hasLiveness() || ((AppInfo)appView.appInfo()).withLiveness().isPinned(method.method);
    }

    public void write(DexEncodedMethod method, MethodVisitor visitor, NamingLens namingLens, AppView<?> appView, int classFileVersion) {
        InternalOptions options = appView.options();
        CfLabel parameterLabel = null;
        if (this.shouldAddParameterNames(method, appView)) {
            parameterLabel = new CfLabel();
            parameterLabel.write(visitor, namingLens);
        }
        for (CfInstruction cfInstruction : this.instructions) {
            if (cfInstruction instanceof CfFrame && (classFileVersion <= 49 || classFileVersion == 50 && !options.shouldKeepStackMapTable())) continue;
            cfInstruction.write(visitor, namingLens);
        }
        visitor.visitEnd();
        visitor.visitMaxs(this.maxStack, this.maxLocals);
        for (CfTryCatch cfTryCatch : this.tryCatchRanges) {
            Label start = cfTryCatch.start.getLabel();
            Label end = cfTryCatch.end.getLabel();
            for (int i = 0; i < cfTryCatch.guards.size(); ++i) {
                DexType guard = cfTryCatch.guards.get(i);
                Label target = cfTryCatch.targets.get(i).getLabel();
                visitor.visitTryCatchBlock(start, end, target, guard == options.itemFactory.throwableType ? null : namingLens.lookupInternalName(guard));
            }
        }
        if (parameterLabel != null) {
            assert (this.localVariables.isEmpty());
            for (Map.Entry entry : method.getParameterInfo().entrySet()) {
                this.writeLocalVariableEntry(visitor, namingLens, (DebugLocalInfo)entry.getValue(), parameterLabel, parameterLabel, (Integer)entry.getKey());
            }
        } else {
            for (LocalVariableInfo localVariableInfo : this.localVariables) {
                this.writeLocalVariableEntry(visitor, namingLens, localVariableInfo.local, localVariableInfo.start, localVariableInfo.end, localVariableInfo.index);
            }
        }
    }

    private void writeLocalVariableEntry(MethodVisitor visitor, NamingLens namingLens, DebugLocalInfo info, CfLabel start, CfLabel end, int index) {
        visitor.visitLocalVariable(info.name.toString(), namingLens.lookupDescriptor(info.type).toString(), info.signature == null ? null : info.signature.toString(), start.getLabel(), end.getLabel(), index);
    }

    @Override
    protected int computeHashCode() {
        throw new Unimplemented();
    }

    @Override
    protected boolean computeEquals(Object other) {
        throw new Unimplemented();
    }

    @Override
    public boolean isEmptyVoidMethod() {
        for (CfInstruction insn : this.instructions) {
            if (insn instanceof CfReturnVoid || insn instanceof CfLabel || insn instanceof CfPosition) continue;
            return false;
        }
        return true;
    }

    @Override
    public IRCode buildIR(DexEncodedMethod encodedMethod, AppView<?> appView, Origin origin) {
        return this.internalBuildPossiblyWithLocals(encodedMethod, encodedMethod, appView, null, null, origin);
    }

    @Override
    public IRCode buildInliningIR(DexEncodedMethod context, DexEncodedMethod encodedMethod, AppView<?> appView, ValueNumberGenerator valueNumberGenerator, Position callerPosition, Origin origin) {
        assert (valueNumberGenerator != null);
        assert (callerPosition != null);
        return this.internalBuildPossiblyWithLocals(context, encodedMethod, appView, valueNumberGenerator, callerPosition, origin);
    }

    private IRCode internalBuildPossiblyWithLocals(DexEncodedMethod context, DexEncodedMethod encodedMethod, AppView<?> appView, ValueNumberGenerator generator, Position callerPosition, Origin origin) {
        if (!encodedMethod.keepLocals(appView.options())) {
            return this.internalBuild(Collections.emptyList(), context, encodedMethod, appView, generator, callerPosition, origin);
        }
        return this.internalBuildWithLocals(context, encodedMethod, appView, generator, callerPosition, origin);
    }

    private IRCode internalBuildWithLocals(DexEncodedMethod context, DexEncodedMethod encodedMethod, AppView<?> appView, ValueNumberGenerator generator, Position callerPosition, Origin origin) {
        try {
            return this.internalBuild(Collections.unmodifiableList(this.localVariables), context, encodedMethod, appView, generator, callerPosition, origin);
        }
        catch (InvalidDebugInfoException e) {
            appView.options().warningInvalidDebugInfo(encodedMethod, origin, e);
            return this.internalBuild(Collections.emptyList(), context, encodedMethod, appView, generator, callerPosition, origin);
        }
    }

    private IRCode internalBuild(List<LocalVariableInfo> localVariables, DexEncodedMethod context, DexEncodedMethod encodedMethod, AppView<?> appView, ValueNumberGenerator generator, Position callerPosition, Origin origin) {
        CfSourceCode source = new CfSourceCode(this, localVariables, encodedMethod, appView.graphLense().getOriginalMethodSignature(encodedMethod.method), callerPosition, origin, appView);
        return new IRBuilder(encodedMethod, appView, source, origin, generator).build(context);
    }

    @Override
    public void registerCodeReferences(DexEncodedMethod method, UseRegistry registry) {
        for (CfInstruction instruction : this.instructions) {
            instruction.registerUse(registry, method.method.holder);
        }
        for (CfTryCatch tryCatch : this.tryCatchRanges) {
            for (DexType guard : tryCatch.guards) {
                registry.registerTypeReference(guard);
            }
        }
    }

    @Override
    public Int2ReferenceMap<DebugLocalInfo> collectParameterInfo(DexEncodedMethod encodedMethod, AppView<?> appView) {
        CfLabel firstLabel = null;
        for (CfInstruction instruction : this.instructions) {
            if (!(instruction instanceof CfLabel)) continue;
            firstLabel = (CfLabel)instruction;
            break;
        }
        if (firstLabel == null) {
            return DexEncodedMethod.NO_PARAMETER_INFO;
        }
        if (!appView.options().hasProguardConfiguration() || !appView.options().getProguardConfiguration().isKeepParameterNames()) {
            return DexEncodedMethod.NO_PARAMETER_INFO;
        }
        if (((AppInfo)appView.appInfo()).hasLiveness() && !((AppInfo)appView.appInfo()).withLiveness().isPinned(encodedMethod.method)) {
            return DexEncodedMethod.NO_PARAMETER_INFO;
        }
        BitSet localSlotsForParameters = new BitSet(0);
        int nextLocalSlotsForParameters = 0;
        if (!encodedMethod.isStatic()) {
            localSlotsForParameters.set(nextLocalSlotsForParameters++);
        }
        for (DexType type : encodedMethod.method.proto.parameters.values) {
            localSlotsForParameters.set(nextLocalSlotsForParameters);
            nextLocalSlotsForParameters += type.isLongType() || type.isDoubleType() ? 2 : 1;
        }
        Int2ReferenceArrayMap<DebugLocalInfo> parameterInfo = new Int2ReferenceArrayMap<DebugLocalInfo>(localSlotsForParameters.cardinality());
        for (LocalVariableInfo node : this.localVariables) {
            if (node.start != firstLabel || !localSlotsForParameters.get(node.index) || parameterInfo.containsKey(node.index)) continue;
            parameterInfo.put(node.index, new DebugLocalInfo(((LocalVariableInfo)node).local.name, ((LocalVariableInfo)node).local.type, ((LocalVariableInfo)node).local.signature));
        }
        return parameterInfo;
    }

    @Override
    public void registerArgumentReferences(DexEncodedMethod method, ArgumentUse registry) {
        DexProto proto = method.method.proto;
        boolean isStatic = method.accessFlags.isStatic();
        int argumentCount = proto.parameters.values.length + (isStatic ? 0 : 1);
        Int2IntArrayMap indexToNumber = new Int2IntArrayMap(argumentCount);
        int index = 0;
        int number = 0;
        if (!isStatic) {
            indexToNumber.put(index++, number++);
        }
        for (DexType value : proto.parameters.values) {
            indexToNumber.put(index++, number++);
            if (!value.isLongType() && !value.isDoubleType()) continue;
            ++index;
        }
        assert (indexToNumber.size() == argumentCount);
        for (CfInstruction instruction : this.instructions) {
            int index2 = -1;
            if (instruction instanceof CfLoad) {
                index2 = ((CfLoad)instruction).getLocalIndex();
            } else {
                if (!(instruction instanceof CfIinc)) continue;
                index2 = ((CfIinc)instruction).getLocalIndex();
            }
            if (index2 < 0) continue;
            registry.register(indexToNumber.get(index2));
        }
    }

    @Override
    public String toString() {
        return new CfPrinter(this).toString();
    }

    @Override
    public String toString(DexEncodedMethod method, ClassNameMapper naming) {
        return new CfPrinter(this, method, naming).toString();
    }

    public Inliner.ConstraintWithTarget computeInliningConstraint(DexEncodedMethod encodedMethod, AppView<AppInfoWithLiveness> appView, GraphLense graphLense, DexType invocationContext) {
        Inliner.ConstraintWithTarget constraint;
        InliningConstraints inliningConstraints = new InliningConstraints(appView, graphLense);
        if (appView.options().isInterfaceMethodDesugaringEnabled()) {
            inliningConstraints.disallowStaticInterfaceMethodCalls();
        }
        Inliner.ConstraintWithTarget constraintWithTarget = constraint = encodedMethod.accessFlags.isSynchronized() ? inliningConstraints.forMonitor() : Inliner.ConstraintWithTarget.ALWAYS;
        if (constraint == Inliner.ConstraintWithTarget.NEVER) {
            return constraint;
        }
        for (CfInstruction insn : this.instructions) {
            if ((constraint = Inliner.ConstraintWithTarget.meet(constraint, insn.inliningConstraint(inliningConstraints, invocationContext, graphLense, appView), appView)) != Inliner.ConstraintWithTarget.NEVER) continue;
            return constraint;
        }
        if (!this.tryCatchRanges.isEmpty()) {
            constraint = Inliner.ConstraintWithTarget.meet(constraint, inliningConstraints.forMoveException(), appView);
        }
        return constraint;
    }

    void addFakeThisParameter(DexItemFactory factory) {
        if (this.localVariables == null || this.localVariables.isEmpty()) {
            return;
        }
        int largestPrefix = 1;
        int existingThisIndex = -1;
        for (int i = 0; i < this.localVariables.size(); ++i) {
            LocalVariableInfo localVariable = this.localVariables.get(i);
            largestPrefix = Math.max(largestPrefix, DexCode.getLargestPrefix(factory, ((LocalVariableInfo)localVariable).local.name));
            if (!((LocalVariableInfo)localVariable).local.name.toString().equals("this")) continue;
            existingThisIndex = i;
        }
        if (existingThisIndex < 0) {
            return;
        }
        String fakeThisName = Strings.repeat("_", largestPrefix + 1) + "this";
        DebugLocalInfo debugLocalInfo = new DebugLocalInfo(factory.createString(fakeThisName), this.originalHolder, null);
        LocalVariableInfo thisLocalInfo = this.localVariables.get(existingThisIndex);
        this.localVariables.set(existingThisIndex, new LocalVariableInfo(thisLocalInfo.index, debugLocalInfo, thisLocalInfo.start, thisLocalInfo.end));
    }

    public static class LocalVariableInfo {
        private final int index;
        private final DebugLocalInfo local;
        private final CfLabel start;
        private CfLabel end;

        public LocalVariableInfo(int index, DebugLocalInfo local, CfLabel start) {
            this.index = index;
            this.local = local;
            this.start = start;
        }

        public LocalVariableInfo(int index, DebugLocalInfo local, CfLabel start, CfLabel end) {
            this(index, local, start);
            this.setEnd(end);
        }

        public void setEnd(CfLabel end) {
            assert (this.end == null);
            assert (end != null);
            this.end = end;
        }

        public int getIndex() {
            return this.index;
        }

        public DebugLocalInfo getLocal() {
            return this.local;
        }

        public CfLabel getStart() {
            return this.start;
        }

        public CfLabel getEnd() {
            return this.end;
        }

        public String toString() {
            return "" + this.index + " => " + this.local;
        }
    }
}

